/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.xmi;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.ExportFilter;
import org.eclipse.fordiac.ide.export.xmi.Messages;
import org.eclipse.fordiac.ide.globalconstantseditor.ui.resource.GlobalConstantsResourceSetInitializer;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextalgorithm.ui.resource.STAlgorithmResourceSetInitializer;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.StructuredTextParseUtil;
import org.eclipse.fordiac.ide.structuredtextcore.parsetree.reconstr.STCoreCommentAssociater;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCorePackage;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STInitializerExpressionSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTypeDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.ui.resource.STFunctionResourceSetInitializer;
import org.eclipse.fordiac.ide.xmiexport.xmiexport.XMIExportAttributeValue;
import org.eclipse.fordiac.ide.xmiexport.xmiexport.XMIExportAttributeValues;
import org.eclipse.fordiac.ide.xmiexport.xmiexport.XMIExportFactory;
import org.eclipse.fordiac.ide.xmiexport.xmiexport.XMIExportInitialValue;
import org.eclipse.fordiac.ide.xmiexport.xmiexport.XMIExportInitialValues;
import org.eclipse.fordiac.ide.xmiexport.xmiexport.XMIExportLiteralType;
import org.eclipse.fordiac.ide.xmiexport.xmiexport.XMIExportLiteralTypes;
import org.eclipse.fordiac.ide.xmiexport.xmiexport.XMIExportTypeDeclaration;
import org.eclipse.fordiac.ide.xmiexport.xmiexport.XMIExportTypeDeclarations;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class XMIExportFilter
extends ExportFilter {
    public static final String XMI_EXTENSION = "xmi";
    private static final Set<EClass> LITERAL_CLASSES = Set.of(STCorePackage.Literals.ST_DATE_AND_TIME_LITERAL, STCorePackage.Literals.ST_DATE_LITERAL, STCorePackage.Literals.ST_ENUM_LITERAL, STCorePackage.Literals.ST_NUMERIC_LITERAL, STCorePackage.Literals.ST_STRING_LITERAL, STCorePackage.Literals.ST_TIME_LITERAL, STCorePackage.Literals.ST_TIME_OF_DAY_LITERAL);

    public void export(IFile typeFile, String destination, boolean forceOverwrite) throws ExportException {
        this.export(typeFile, destination, forceOverwrite, null);
    }

    public void export(IFile typeFile, String destination, boolean forceOverwrite, EObject element) throws ExportException {
        XtextResource xtextResource;
        EObject root;
        if (typeFile == null || !typeFile.exists()) {
            this.getErrors().add(Messages.XMIExportFilter_UnknownFile);
            return;
        }
        URI sourceUri = URI.createPlatformResourceURI((String)typeFile.getFullPath().toString(), (boolean)true);
        URI destinationUri = URI.createFileURI((String)destination);
        URI xmiUri = destinationUri.appendSegment(typeFile.getName()).appendFileExtension(XMI_EXTENSION);
        XtextResourceSet resourceSet = new XtextResourceSet();
        new STAlgorithmResourceSetInitializer().initialize((ResourceSet)resourceSet, typeFile.getProject());
        new STFunctionResourceSetInitializer().initialize((ResourceSet)resourceSet, typeFile.getProject());
        new GlobalConstantsResourceSetInitializer().initialize((ResourceSet)resourceSet, typeFile.getProject());
        Resource resource = resourceSet.getResource(sourceUri, true);
        if (resource instanceof XtextResource && (root = (xtextResource = (XtextResource)resource).getParseResult().getRootASTElement()) instanceof STSource) {
            STSource source = (STSource)root;
            STCoreCommentAssociater commentAssociater = (STCoreCommentAssociater)((XtextResource)resource).getResourceServiceProvider().get(STCoreCommentAssociater.class);
            if (commentAssociater != null) {
                source.getComments().addAll((Collection)commentAssociater.associateComments((EObject)source));
            }
        }
        resource.getContents().add((Object)this.createInitialValues(resource));
        resource.getContents().add((Object)this.createTypeDeclarations(resource));
        resource.getContents().add((Object)this.createAttributeValues(resource));
        resource.getContents().add((Object)this.createLiteralTypes(resource));
        ResourceSetImpl xmiResourceSet = new ResourceSetImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().putIfAbsent(XMI_EXTENSION, new XMIResourceFactoryImpl());
        Resource xmiResource = xmiResourceSet.createResource(xmiUri);
        xmiResource.getContents().addAll(EcoreUtil.copyAll((Collection)resource.getContents()));
        if (!forceOverwrite && xmiResourceSet.getURIConverter().exists(xmiUri, Collections.emptyMap()) && !MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.XMIExportFilter_OverwriteDialogTitle, (String)MessageFormat.format(Messages.XMIExportFilter_OverwriteDialogMessage, xmiUri.toFileString()))) {
            return;
        }
        try {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("PROCESS_DANGLING_HREF", "DISCARD");
            options.put("SKIP_ESCAPE_URI", Boolean.FALSE);
            xmiResource.save(options);
        }
        catch (IOException e) {
            this.getErrors().add(e.getMessage());
        }
    }

    protected XMIExportInitialValues createInitialValues(Resource resource) {
        XMIExportInitialValues result = XMIExportFactory.eINSTANCE.createXMIExportInitialValues();
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(EcoreUtil.getAllProperContents((Resource)resource, (boolean)true), 0), false).filter(VarDeclaration.class::isInstance).map(VarDeclaration.class::cast).filter(XMIExportFilter::hasInitialValue).map(this::createInitialValue).flatMap(Optional::stream).forEachOrdered(arg_0 -> result.getInitialValues().add(arg_0));
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(EcoreUtil.getAllProperContents((Resource)resource, (boolean)true), 0), false).filter(DirectlyDerivedType.class::isInstance).map(DirectlyDerivedType.class::cast).filter(XMIExportFilter::hasInitialValue).map(this::createInitialValue).flatMap(Optional::stream).forEachOrdered(arg_0 -> result.getInitialValues().add(arg_0));
        return result;
    }

    protected Optional<XMIExportInitialValue> createInitialValue(VarDeclaration varDeclaration) {
        STInitializerExpressionSource source = this.parseInitialValue(varDeclaration);
        if (source == null || source.getInitializerExpression() == null) {
            return Optional.empty();
        }
        XMIExportInitialValue result = XMIExportFactory.eINSTANCE.createXMIExportInitialValue();
        result.setVariable((INamedElement)varDeclaration);
        result.setExpression(source.getInitializerExpression());
        result.setValue(this.evaluateInitialValue(varDeclaration));
        return Optional.of(result);
    }

    protected STInitializerExpressionSource parseInitialValue(VarDeclaration varDeclaration) {
        return StructuredTextParseUtil.parse((String)varDeclaration.getValue().getValue(), (URI)varDeclaration.eResource().getURI(), (LibraryElement)STCoreUtil.getFeatureType((INamedElement)varDeclaration), (LibraryElement)((LibraryElement)EcoreUtil2.getContainerOfType((EObject)varDeclaration, LibraryElement.class)), null, (List)this.getErrors(), (List)this.getWarnings(), (List)this.getInfos());
    }

    protected String evaluateInitialValue(VarDeclaration varDeclaration) {
        try {
            return VariableOperations.newVariable((VarDeclaration)varDeclaration).toString();
        }
        catch (Exception e) {
            this.getErrors().add(MessageFormat.format(Messages.XMIExportFilter_InitialValueError, varDeclaration.getQualifiedName(), e.getMessage()));
            return null;
        }
    }

    protected static boolean hasInitialValue(VarDeclaration varDeclaration) {
        return varDeclaration.getValue() != null && varDeclaration.getValue().getValue() != null && !varDeclaration.getValue().getValue().isBlank();
    }

    protected Optional<XMIExportInitialValue> createInitialValue(DirectlyDerivedType directlyDerivedType) {
        STInitializerExpressionSource source = this.parseInitialValue(directlyDerivedType);
        if (source == null || source.getInitializerExpression() == null) {
            return Optional.empty();
        }
        XMIExportInitialValue result = XMIExportFactory.eINSTANCE.createXMIExportInitialValue();
        result.setVariable((INamedElement)directlyDerivedType);
        result.setExpression(source.getInitializerExpression());
        result.setValue(this.evaluateInitialValue(directlyDerivedType));
        return Optional.of(result);
    }

    protected STInitializerExpressionSource parseInitialValue(DirectlyDerivedType directlyDerivedType) {
        return StructuredTextParseUtil.parse((String)directlyDerivedType.getInitialValue(), (URI)directlyDerivedType.eResource().getURI(), (LibraryElement)directlyDerivedType.getBaseType(), (LibraryElement)((LibraryElement)EcoreUtil2.getContainerOfType((EObject)directlyDerivedType, LibraryElement.class)), null, (List)this.getErrors(), (List)this.getWarnings(), (List)this.getInfos());
    }

    protected String evaluateInitialValue(DirectlyDerivedType directlyDerivedType) {
        try {
            return VariableOperations.newVariable((DirectlyDerivedType)directlyDerivedType).toString();
        }
        catch (Exception e) {
            this.getErrors().add(MessageFormat.format(Messages.XMIExportFilter_InitialValueError, directlyDerivedType.getQualifiedName(), e.getMessage()));
            return null;
        }
    }

    protected static boolean hasInitialValue(DirectlyDerivedType directlyDerivedType) {
        return directlyDerivedType.getInitialValue() != null && !directlyDerivedType.getInitialValue().isBlank();
    }

    protected XMIExportTypeDeclarations createTypeDeclarations(Resource resource) {
        XMIExportTypeDeclarations result = XMIExportFactory.eINSTANCE.createXMIExportTypeDeclarations();
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(EcoreUtil.getAllProperContents((Resource)resource, (boolean)true), 0), false).filter(VarDeclaration.class::isInstance).map(VarDeclaration.class::cast).filter(VarDeclaration::isArray).map(this::createTypeDeclaration).flatMap(Optional::stream).forEachOrdered(arg_0 -> result.getTypeDeclarations().add(arg_0));
        return result;
    }

    protected Optional<XMIExportTypeDeclaration> createTypeDeclaration(VarDeclaration varDeclaration) {
        STTypeDeclaration source = this.parseTypeDeclaration(varDeclaration);
        if (source == null || source.getType() == null) {
            return Optional.empty();
        }
        XMIExportTypeDeclaration result = XMIExportFactory.eINSTANCE.createXMIExportTypeDeclaration();
        result.setVariable(varDeclaration);
        result.setTypeDeclaration(source);
        result.setResultType((LibraryElement)EcoreUtil.copy((EObject)this.evaluateResultType(varDeclaration)));
        return Optional.of(result);
    }

    protected STTypeDeclaration parseTypeDeclaration(VarDeclaration varDeclaration) {
        return StructuredTextParseUtil.parseType((VarDeclaration)varDeclaration, (List)this.getErrors(), (List)this.getWarnings(), (List)this.getInfos());
    }

    protected LibraryElement evaluateResultType(VarDeclaration varDeclaration) {
        try {
            return VariableOperations.evaluateResultType((VarDeclaration)varDeclaration);
        }
        catch (Exception e) {
            this.getErrors().add(MessageFormat.format(Messages.XMIExportFilter_ResultTypeError, varDeclaration.getQualifiedName(), e.getMessage()));
            return null;
        }
    }

    protected XMIExportAttributeValues createAttributeValues(Resource resource) {
        XMIExportAttributeValues result = XMIExportFactory.eINSTANCE.createXMIExportAttributeValues();
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(EcoreUtil.getAllProperContents((Resource)resource, (boolean)true), 0), false).filter(Attribute.class::isInstance).map(Attribute.class::cast).filter(XMIExportFilter::hasAttributeValue).map(this::createAttributeValue).flatMap(Optional::stream).forEachOrdered(arg_0 -> result.getAttributeValues().add(arg_0));
        return result;
    }

    protected Optional<XMIExportAttributeValue> createAttributeValue(Attribute attribute) {
        STInitializerExpressionSource source = this.parseAttributeValue(attribute);
        if (source == null || source.getInitializerExpression() == null) {
            return Optional.empty();
        }
        XMIExportAttributeValue result = XMIExportFactory.eINSTANCE.createXMIExportAttributeValue();
        result.setAttribute(attribute);
        result.setExpression(source.getInitializerExpression());
        result.setValue(this.evaluateAttributeValue(attribute));
        return Optional.of(result);
    }

    protected STInitializerExpressionSource parseAttributeValue(Attribute attribute) {
        return StructuredTextParseUtil.parse((String)attribute.getValue(), (URI)attribute.eResource().getURI(), (LibraryElement)attribute.getType(), (LibraryElement)((LibraryElement)EcoreUtil2.getContainerOfType((EObject)attribute, LibraryElement.class)), null, (List)this.getWarnings(), (List)this.getWarnings(), (List)this.getInfos());
    }

    protected String evaluateAttributeValue(Attribute attribute) {
        try {
            return VariableOperations.newVariable((Attribute)attribute).toString();
        }
        catch (Exception e) {
            this.getWarnings().add(MessageFormat.format(Messages.XMIExportFilter_AttributeValueError, attribute.getQualifiedName(), e.getMessage()));
            return null;
        }
    }

    protected static boolean hasAttributeValue(Attribute attribute) {
        return attribute.getType() instanceof AnyType && attribute.getValue() != null && !attribute.getValue().isBlank();
    }

    protected XMIExportLiteralTypes createLiteralTypes(Resource resource) {
        XMIExportLiteralTypes result = XMIExportFactory.eINSTANCE.createXMIExportLiteralTypes();
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(EcoreUtil.getAllProperContents((Resource)resource, (boolean)true), 0), false).filter(STExpression.class::isInstance).map(STExpression.class::cast).filter(XMIExportFilter::isLiteral).map(this::createLiteralType).flatMap(Optional::stream).forEachOrdered(arg_0 -> result.getLiteralTypes().add(arg_0));
        return result;
    }

    protected Optional<XMIExportLiteralType> createLiteralType(STExpression expression) {
        LibraryElement resultType = expression.getResultType();
        if (resultType == null) {
            this.getWarnings().add(MessageFormat.format(Messages.XMIExportFilter_LiteralTypeError, EcoreUtil.getURI((EObject)expression).fragment()));
            return Optional.empty();
        }
        XMIExportLiteralType result = XMIExportFactory.eINSTANCE.createXMIExportLiteralType();
        result.setLiteral(expression);
        result.setType((LibraryElement)EcoreUtil.copy((EObject)resultType));
        return Optional.of(result);
    }

    protected static boolean isLiteral(STExpression expression) {
        return LITERAL_CLASSES.contains(expression.eClass());
    }
}

