/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantChecker {
    private static final Logger log = Logger.getLogger(ConstantChecker.class.getName());
    List<String> errors = new ArrayList<String>();

    public static List<String> checkConstants() {
        ConstantChecker checker = new ConstantChecker();
        checker.check(1, 1, "GL_ONE", 1);
        checker.check(0, 0, "GL_ZERO", 0);
        checker.check(6914, 6914, "GL_FILL", 6914);
        checker.check(6913, 6913, "GL_LINE", 6913);
        checker.check(1032, 1032, "GL_FRONT_AND_BACK", 1032);
        checker.check(1, 1, "GL_LINES", 1);
        checker.check(2852, 2852, "GL_LINE_STIPPLE", 2852);
        checker.check(3, 3, "GL_LINE_STRIP", 3);
        checker.check(5888, 5888, "GL_MODELVIEW", 5888);
        checker.check(7, 7, "GL_QUADS", 7);
        checker.check(9, 9, "GL_POLYGON", 9);
        checker.check(4, 4, "GL_TRIANGLES", 4);
        checker.check(5, 5, "GL_TRIANGLE_STRIP", 5);
        checker.check(6, 6, "GL_TRIANGLE_FAN", 6);
        checker.check(7681, 7681, "GL_REPLACE", 7681);
        checker.check(6408, 6408, "GL_RGBA", 6408);
        checker.check(3553, 3553, "GL_TEXTURE_2D", 3553);
        checker.check(8960, 8960, "GL_TEXTURE_ENV", 8960);
        checker.check(8704, 8704, "GL_TEXTURE_ENV_MODE", 8704);
        checker.check(5121, 5121, "GL_UNSIGNED_BYTE", 5121);
        checker.check(3317, 3317, "GL_UNPACK_ALIGNMENT", 3317);
        checker.check(7938, 7938, "GL_VERSION", 7938);
        checker.check(2929, 2929, "GL_DEPTH_TEST", 2929);
        checker.check(5889, 5889, "GL_PROJECTION", 5889);
        checker.check(6410, 6410, "GL_LUMINANCE_ALPHA", 6410);
        checker.check(3042, 3042, "GL_BLEND", 3042);
        checker.check(4864, 4864, "GL_COMPILE", 4864);
        checker.check(16384, 16384, "GL_COLOR_BUFFER_BIT", 16384);
        checker.check(256, 256, "GL_DEPTH_BUFFER_BIT", 256);
        checker.check(6402, 6402, "GL_DEPTH_COMPONENT", 6402);
        checker.check(6407, 6407, "GL_RGB", 6407);
        checker.check(5126, 5126, "GL_FLOAT", 5126);
        checker.check(3024, 3024, "GL_DITHER", 3024);
        checker.check(32925, 32925, "GL_MULTISAMPLE", 32925);
        checker.check(2, 2, "GL_LINE_LOOP", 2);
        checker.check(7424, 7424, "GL_FLAT", 7424);
        checker.check(2884, 2884, "GL_CULL_FACE", 2884);
        checker.check(3154, 3154, "GL_LINE_SMOOTH_HINT", 3154);
        checker.check(4354, 4354, "GL_NICEST", 4354);
        checker.check(2848, 2848, "GL_LINE_SMOOTH", 2848);
        checker.check(2978, 2978, "GL_VIEWPORT", 2978);
        checker.check(2983, 2983, "GL_PROJECTION_MATRIX", 2983);
        checker.check(2982, 2982, "GL_MODELVIEW_MATRIX", 2982);
        checker.check(770, 770, "GL_SRC_ALPHA", 770);
        checker.check(771, 771, "GL_ONE_MINUS_SRC_ALPHA", 771);
        checker.check(3333, 3333, "GL_PACK_ALIGNMENT", 3333);
        checker.check(32992, 32992, "GL_BGR", 32992);
        checker.check(6400, 6400, "GL_COLOR_INDEX", 6400);
        checker.check(6403, 6403, "GL_RED", 6403);
        checker.check(6404, 6404, "GL_GREEN", 6404);
        checker.check(6405, 6405, "GL_BLUE", 6405);
        checker.check(6406, 6406, "GL_ALPHA", 6406);
        checker.check(6409, 6409, "GL_LUMINANCE", 6409);
        checker.check(6401, 6401, "GL_STENCIL_INDEX", 6401);
        checker.check(5120, 5120, "GL_BYTE", 5120);
        checker.check(5123, 5123, "GL_UNSIGNED_SHORT", 5123);
        checker.check(5122, 5122, "GL_SHORT", 5122);
        checker.check(5125, 5125, "GL_UNSIGNED_INT", 5125);
        checker.check(5124, 5124, "GL_INT", 5124);
        checker.check(32993, 32993, "GL_BGRA", 32993);
        checker.check(32818, 32818, "GL_UNSIGNED_BYTE_3_3_2", 32818);
        checker.check(33634, 33634, "GL_UNSIGNED_BYTE_2_3_3_REV", 33634);
        checker.check(33635, 33635, "GL_UNSIGNED_SHORT_5_6_5", 33635);
        checker.check(33636, 33636, "GL_UNSIGNED_SHORT_5_6_5_REV", 33636);
        checker.check(32819, 32819, "GL_UNSIGNED_SHORT_4_4_4_4", 32819);
        checker.check(33637, 33637, "GL_UNSIGNED_SHORT_4_4_4_4_REV", 33637);
        checker.check(32820, 32820, "GL_UNSIGNED_SHORT_5_5_5_1", 32820);
        checker.check(33638, 33638, "GL_UNSIGNED_SHORT_1_5_5_5_REV", 33638);
        checker.check(32821, 32821, "GL_UNSIGNED_INT_8_8_8_8", 32821);
        checker.check(33639, 33639, "GL_UNSIGNED_INT_8_8_8_8_REV", 33639);
        checker.check(32822, 32822, "GL_UNSIGNED_INT_10_10_10_2", 32822);
        checker.check(33640, 33640, "GL_UNSIGNED_INT_2_10_10_10_REV", 33640);
        checker.check(0, 0, "GL_POINTS", 0);
        checker.check(8, 8, "GL_QUAD_STRIP", 8);
        return checker.errors;
    }

    protected void check(int constGraphics3DDraw, int constLWJGL, String i_name, int checkedValue) {
        if (constGraphics3DDraw != constLWJGL) {
            this.errors.add("Graphics3DDraw." + i_name + " (" + constGraphics3DDraw + ") != GL11." + i_name + " (" + constLWJGL + "), reference=" + checkedValue);
        }
        if (constGraphics3DDraw != checkedValue && log.isLoggable(Level.INFO)) {
            log.info("LWJGL constant, reference changed: Graphics3DDraw." + i_name + " (" + constGraphics3DDraw + ") == GL11." + i_name + " (" + constLWJGL + "), reference=" + checkedValue);
        }
    }
}

