/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.basic.requirement.docgen;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.basic.requirement.Requirement;
import org.polarsys.capella.basic.requirement.RequirementsPkg;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.SortedTreeNode;

public class RequirementTreeServices {
    public static final String REQUIREMENT_TREE_ID = "requirementTreeView";
    private static final Comparator<DefaultMutableTreeNode> requirementsComparator = new Comparator<DefaultMutableTreeNode>(){

        @Override
        public int compare(DefaultMutableTreeNode arg0, DefaultMutableTreeNode arg1) {
            Object obj0 = arg0.getUserObject();
            Object obj1 = arg1.getUserObject();
            if (obj0 instanceof RequirementsPkg && obj1 instanceof Requirement) {
                return 1;
            }
            if (obj0 instanceof Requirement && obj1 instanceof RequirementsPkg) {
                return -1;
            }
            if (obj0 instanceof NamedElement && obj1 instanceof NamedElement) {
                return ((NamedElement)obj0).getName().compareTo(((NamedElement)obj1).getName());
            }
            return 0;
        }
    };

    public static String getRequirementsTree(List<Requirement> appliedReq, String projectName, String outputFolder) {
        StringBuilder sb = new StringBuilder();
        DefaultMutableTreeNode tree = RequirementTreeServices.buildRequirementsTree(appliedReq);
        sb.append("<ul id=\"").append(REQUIREMENT_TREE_ID).append("\" class=\"treeview\">");
        sb.append(RequirementTreeServices.printRequirementsTree(tree, projectName, outputFolder));
        sb.append("</ul>");
        return sb.toString();
    }

    private static DefaultMutableTreeNode buildRequirementsTree(List<Requirement> appliedReq) {
        SortedTreeNode tree = new SortedTreeNode(requirementsComparator);
        HashMap<RequirementsPkg, SortedTreeNode> reqPkgToTreeNodeMap = new HashMap<RequirementsPkg, SortedTreeNode>();
        for (Requirement req : appliedReq) {
            SortedTreeNode currentNode = new SortedTreeNode((Object)req, requirementsComparator);
            EObject parent = req.eContainer();
            boolean hasFoundParent = false;
            while (parent instanceof RequirementsPkg) {
                SortedTreeNode pkgNode = (SortedTreeNode)reqPkgToTreeNodeMap.get(parent);
                if (pkgNode == null) {
                    pkgNode = new SortedTreeNode((Object)parent, requirementsComparator);
                    reqPkgToTreeNodeMap.put((RequirementsPkg)parent, pkgNode);
                } else {
                    hasFoundParent = true;
                }
                pkgNode.add((MutableTreeNode)currentNode);
                currentNode = pkgNode;
                parent = parent.eContainer();
                if (hasFoundParent) break;
            }
            if (hasFoundParent) continue;
            tree.add((MutableTreeNode)currentNode);
        }
        return tree;
    }

    private static String printRequirementsTree(DefaultMutableTreeNode tree, String projectName, String outputFolder) {
        StringBuilder sb = new StringBuilder();
        Enumeration<TreeNode> childs = tree.children();
        if (childs instanceof Enumeration) {
            while (childs.hasMoreElements()) {
                DefaultMutableTreeNode node;
                TreeNode element = childs.nextElement();
                if (!(element instanceof DefaultMutableTreeNode) || !((node = (DefaultMutableTreeNode)element).getUserObject() instanceof EObject)) continue;
                EObject obj = (EObject)node.getUserObject();
                sb.append("<li>");
                sb.append(CapellaServices.buildHyperlinkWithIcon((String)projectName, (String)outputFolder, (EObject)obj));
                if (obj instanceof RequirementsPkg) {
                    sb.append("<ul>");
                    sb.append(RequirementTreeServices.printRequirementsTree(node, projectName, outputFolder));
                    sb.append("</ul>");
                }
                sb.append("</li>");
            }
        }
        return sb.toString();
    }
}

