/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.basic.requirement.docgen.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.basic.requirement.Requirement;
import org.polarsys.capella.basic.requirement.RequirementsPkg;
import org.polarsys.capella.basic.requirement.helpers.RequirementModelHelper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.docgen.util.CapellaLabelProviderHelper;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;

public class CapellaRequirementHelper {
    public static Collection<String> getTracingModelElements(Requirement requirement, String projectName, String outputFolder) {
        ArrayList<String> elementsToDisplay = new ArrayList<String>();
        for (CapellaElement element : RequirementModelHelper.getRelatedCapellaElements((Requirement)requirement)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)element, (String)projectName, (String)outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)element));
            elementsToDisplay.add(buffer.toString());
        }
        return elementsToDisplay;
    }

    public static String getRequirementPathHyperLinkWithIcon(String projectName, String outputFolder, EObject element) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<EObject> iterator = CapellaRequirementHelper.getFullRequirementPath(element).iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(CapellaLabelProviderHelper.getText((EObject)iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" > ");
        }
        StringBuilder hyperLinkStringBuilder = new StringBuilder();
        hyperLinkStringBuilder.append(CapellaServices.getImageLinkFromElement((EObject)element, (String)projectName, (String)outputFolder));
        hyperLinkStringBuilder.append(" ");
        hyperLinkStringBuilder.append(CapellaServices.getHyperlinkFromElement((EObject)element, (String)stringBuilder.toString()));
        return hyperLinkStringBuilder.toString();
    }

    public static String getRequirementPath(EObject element) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<EObject> iterator = CapellaRequirementHelper.getFullRequirementPath(element).iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(CapellaLabelProviderHelper.getText((EObject)iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" > ");
        }
        return stringBuilder.toString();
    }

    private static List<EObject> getFullRequirementPath(EObject element) {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        EObject parent = element.eContainer();
        if (parent instanceof RequirementsPkg) {
            eObjects.addAll(CapellaRequirementHelper.getFullRequirementPath(parent));
        }
        eObjects.add(element);
        return eObjects;
    }

    public static Collection<String> getRequirementsToLine(CapellaElement element, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Requirement requirement : RequirementModelHelper.getAppliedRequirements((CapellaElement)element)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<tr>");
            buffer.append("<td>");
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)requirement, (String)projectName, (String)outputFolder));
            buffer.append(" ");
            buffer.append("<a href=\"");
            buffer.append(CapellaServices.getPathFromElement((EObject)requirement));
            buffer.append("\">");
            buffer.append(requirement.getRequirementId());
            buffer.append("</a>");
            buffer.append("</td>");
            buffer.append("<td>");
            buffer.append(requirement.getName());
            buffer.append("</td>");
            buffer.append("<td>");
            buffer.append(StringUtil.transformAREFString((EObject)requirement, (String)requirement.getDescription(), (String)projectName, (String)outputFolder));
            buffer.append("</td>");
            buffer.append("</tr>");
            ret.add(buffer.toString());
        }
        return ret;
    }
}

