/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.ui.properties.fields;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticCheckboxGroup;
import org.polarsys.capella.cybersecurity.model.provider.CybersecurityEditPlugin;

public class SemanticCheckboxGroup
extends AbstractSemanticCheckboxGroup {
    private static final String KEY_ENABLER = "semantic_checkbox_enabler";
    private final List<Button> semanticFields;
    private final Composite parent;

    public SemanticCheckboxGroup(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, EAttribute ... attributes) {
        super(parent, widgetFactory);
        this.parent = parent;
        this.semanticFields = new ArrayList<Button>();
        EAttribute[] eAttributeArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            EAttribute att = eAttributeArray[n2];
            this.addCheckbox(att);
            ++n2;
        }
    }

    public SemanticCheckboxGroup(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        this(parent, widgetFactory, new EAttribute[0]);
    }

    public void addCheckbox(EAttribute att, Predicate<EObject> enabler) {
        Button button = this.createButton((EStructuralFeature)att, CybersecurityEditPlugin.INSTANCE.getString("_UI_" + att.getEContainingClass().getName() + "_" + att.getName() + "_feature"), this.parent);
        button.setData(KEY_ENABLER, enabler);
        this.semanticFields.add(button);
    }

    public void addCheckbox(EAttribute att) {
        this.addCheckbox(att, null);
    }

    public List<Button> getSemanticFields() {
        return this.semanticFields;
    }

    public void loadData(EObject semanticElement) {
        super.loadData(semanticElement);
        for (Button b : this.getSemanticFields()) {
            Predicate enabler = (Predicate)b.getData(KEY_ENABLER);
            if (enabler == null) continue;
            b.setEnabled(enabler.test(semanticElement));
        }
    }
}

