/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.model.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.polarsys.capella.common.lib.IdGenerator;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPackage;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.model.FunctionStorage;
import org.polarsys.capella.cybersecurity.model.FunctionalPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.InformationPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetMember;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetStorage;
import org.polarsys.capella.cybersecurity.model.SecurityNeeds;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.model.ThreatApplication;
import org.polarsys.capella.cybersecurity.model.ThreatInvolvement;
import org.polarsys.capella.cybersecurity.model.ThreatKind;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.capella.cybersecurity.model.impl.CybersecurityPkgImpl;
import org.polarsys.capella.cybersecurity.model.impl.FunctionStorageImpl;
import org.polarsys.capella.cybersecurity.model.impl.FunctionalPrimaryAssetImpl;
import org.polarsys.capella.cybersecurity.model.impl.InformationPrimaryAssetImpl;
import org.polarsys.capella.cybersecurity.model.impl.PrimaryAssetMemberImpl;
import org.polarsys.capella.cybersecurity.model.impl.PrimaryAssetStorageImpl;
import org.polarsys.capella.cybersecurity.model.impl.SecurityNeedsImpl;
import org.polarsys.capella.cybersecurity.model.impl.ThreatApplicationImpl;
import org.polarsys.capella.cybersecurity.model.impl.ThreatImpl;
import org.polarsys.capella.cybersecurity.model.impl.ThreatInvolvementImpl;
import org.polarsys.capella.cybersecurity.model.impl.TrustBoundaryStorageImpl;

public class CybersecurityFactoryImpl
extends EFactoryImpl
implements CybersecurityFactory {
    public static CybersecurityFactory init() {
        try {
            CybersecurityFactory theCybersecurityFactory = (CybersecurityFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.polarsys.org/capella/cybersecurity/1.0");
            if (theCybersecurityFactory != null) {
                return theCybersecurityFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new CybersecurityFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createCybersecurityPkg();
            }
            case 1: {
                return this.createThreat();
            }
            case 2: {
                return this.createThreatInvolvement();
            }
            case 3: {
                return this.createFunctionStorage();
            }
            case 4: {
                return this.createThreatApplication();
            }
            case 5: {
                return this.createPrimaryAssetStorage();
            }
            case 6: {
                return this.createSecurityNeeds();
            }
            case 7: {
                return this.createTrustBoundaryStorage();
            }
            case 9: {
                return this.createFunctionalPrimaryAsset();
            }
            case 10: {
                return this.createInformationPrimaryAsset();
            }
            case 11: {
                return this.createPrimaryAssetMember();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return this.createThreatKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return this.convertThreatKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public CybersecurityPkg createCybersecurityPkg() {
        CybersecurityPkgImpl cybersecurityPkg = new CybersecurityPkgImpl();
        cybersecurityPkg.setId(IdGenerator.createId());
        return cybersecurityPkg;
    }

    @Override
    public Threat createThreat() {
        ThreatImpl threat = new ThreatImpl();
        threat.setId(IdGenerator.createId());
        return threat;
    }

    @Override
    public ThreatInvolvement createThreatInvolvement() {
        ThreatInvolvementImpl threatInvolvement = new ThreatInvolvementImpl();
        threatInvolvement.setId(IdGenerator.createId());
        return threatInvolvement;
    }

    @Override
    public FunctionStorage createFunctionStorage() {
        FunctionStorageImpl functionStorage = new FunctionStorageImpl();
        functionStorage.setId(IdGenerator.createId());
        return functionStorage;
    }

    @Override
    public ThreatApplication createThreatApplication() {
        ThreatApplicationImpl threatApplication = new ThreatApplicationImpl();
        threatApplication.setId(IdGenerator.createId());
        return threatApplication;
    }

    @Override
    public PrimaryAssetStorage createPrimaryAssetStorage() {
        PrimaryAssetStorageImpl primaryAssetStorage = new PrimaryAssetStorageImpl();
        primaryAssetStorage.setId(IdGenerator.createId());
        return primaryAssetStorage;
    }

    @Override
    public SecurityNeeds createSecurityNeeds() {
        SecurityNeedsImpl securityNeeds = new SecurityNeedsImpl();
        securityNeeds.setId(IdGenerator.createId());
        return securityNeeds;
    }

    @Override
    public TrustBoundaryStorage createTrustBoundaryStorage() {
        TrustBoundaryStorageImpl trustBoundaryStorage = new TrustBoundaryStorageImpl();
        trustBoundaryStorage.setId(IdGenerator.createId());
        return trustBoundaryStorage;
    }

    @Override
    public FunctionalPrimaryAsset createFunctionalPrimaryAsset() {
        FunctionalPrimaryAssetImpl functionalPrimaryAsset = new FunctionalPrimaryAssetImpl();
        functionalPrimaryAsset.setId(IdGenerator.createId());
        return functionalPrimaryAsset;
    }

    @Override
    public InformationPrimaryAsset createInformationPrimaryAsset() {
        InformationPrimaryAssetImpl informationPrimaryAsset = new InformationPrimaryAssetImpl();
        informationPrimaryAsset.setId(IdGenerator.createId());
        return informationPrimaryAsset;
    }

    @Override
    public PrimaryAssetMember createPrimaryAssetMember() {
        PrimaryAssetMemberImpl primaryAssetMember = new PrimaryAssetMemberImpl();
        primaryAssetMember.setId(IdGenerator.createId());
        return primaryAssetMember;
    }

    public ThreatKind createThreatKindFromString(EDataType eDataType, String initialValue) {
        ThreatKind result = ThreatKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertThreatKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public CybersecurityPackage getCybersecurityPackage() {
        return (CybersecurityPackage)this.getEPackage();
    }

    @Deprecated
    public static CybersecurityPackage getPackage() {
        return CybersecurityPackage.eINSTANCE;
    }

    public CybersecurityPkg createCybersecurityPkg(String name_p) {
        CybersecurityPkg cybersecurityPkg = this.createCybersecurityPkg();
        cybersecurityPkg.setName(name_p);
        return cybersecurityPkg;
    }

    public Threat createThreat(String name_p) {
        Threat threat = this.createThreat();
        threat.setName(name_p);
        return threat;
    }

    public FunctionalPrimaryAsset createFunctionalPrimaryAsset(String name_p) {
        FunctionalPrimaryAsset functionalPrimaryAsset = this.createFunctionalPrimaryAsset();
        functionalPrimaryAsset.setName(name_p);
        return functionalPrimaryAsset;
    }

    public InformationPrimaryAsset createInformationPrimaryAsset(String name_p) {
        InformationPrimaryAsset informationPrimaryAsset = this.createInformationPrimaryAsset();
        informationPrimaryAsset.setName(name_p);
        return informationPrimaryAsset;
    }
}

