/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.handlers.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.contextscope.IContextScopeHandler;
import org.polarsys.capella.core.transition.common.handlers.scope.IScopeRetriever;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ExternalFunctionsScopeRetriever
implements IScopeRetriever {
    public IStatus init(IContext context_p) {
        return Status.OK_STATUS;
    }

    public IStatus dispose(IContext context_p) {
        return Status.OK_STATUS;
    }

    public Collection<? extends EObject> retrieveRelatedElements(EObject source_p, IContext context_p) {
        HashSet<FunctionalExchange> result = new HashSet<FunctionalExchange>();
        IContextScopeHandler scope = ContextScopeHandlerHelper.getInstance((IContext)context_p);
        if (source_p instanceof AbstractFunction) {
            AbstractFunction element = (AbstractFunction)source_p;
            for (FunctionalExchange exchange : this.getFE(element, context_p)) {
                AbstractFunction oppositeFunction;
                AbstractFunction sourceFunction = (AbstractFunction)exchange.getSource().eContainer();
                AbstractFunction targetFunction = (AbstractFunction)exchange.getTarget().eContainer();
                AbstractFunction abstractFunction = oppositeFunction = element.equals(targetFunction) ? sourceFunction : targetFunction;
                if (!ExternalFunctionsScopeRetriever.isLinkToPrimaryFunction(oppositeFunction, context_p)) continue;
                for (FunctionalExchange fe : this.getFE(oppositeFunction, context_p)) {
                    AbstractFunction opposite;
                    if (scope.contains("SOURCE_SCOPE", (EObject)fe, context_p)) continue;
                    AbstractFunction source = (AbstractFunction)fe.getSource().eContainer();
                    AbstractFunction target = (AbstractFunction)fe.getTarget().eContainer();
                    AbstractFunction abstractFunction2 = opposite = oppositeFunction.equals(target) ? source : target;
                    if (!ExternalFunctionsScopeRetriever.isLinkToPrimaryFunction(opposite, context_p)) continue;
                    Collection<FunctionalExchange> srcFes = this.getFE(source, context_p);
                    Collection<FunctionalExchange> trgFes = this.getFE(target, context_p);
                    Collection<FunctionalChain> srcFcs = this.getFunctionalChains(srcFes);
                    Collection<FunctionalChain> trgFcs = this.getFunctionalChains(trgFes);
                    EList feFcs = fe.getInvolvingFunctionalChains();
                    ArrayList retained = new ArrayList();
                    retained.addAll(feFcs);
                    retained.retainAll(srcFcs);
                    retained.retainAll(trgFcs);
                    if (retained.isEmpty() || scope.contains("SOURCE_SCOPE", (EObject)fe, context_p)) continue;
                    scope.add("SOURCE_SCOPE", (EObject)fe, context_p);
                    result.add(fe);
                }
            }
        }
        return result;
    }

    protected Collection<FunctionalChain> getFunctionalChains(Collection<FunctionalExchange> srcs) {
        ArrayList<FunctionalChain> res = new ArrayList<FunctionalChain>();
        for (FunctionalExchange fe : srcs) {
            res.addAll((Collection<FunctionalChain>)fe.getInvolvingFunctionalChains());
        }
        return res;
    }

    protected Collection<FunctionalExchange> getScopedFE(AbstractFunction function, IContext context_p) {
        IContextScopeHandler scope = ContextScopeHandlerHelper.getInstance((IContext)context_p);
        ArrayList<FunctionalExchange> res = new ArrayList<FunctionalExchange>();
        ArrayList edges = new ArrayList();
        edges.addAll(function.getIncoming());
        edges.addAll(function.getOutgoing());
        for (ActivityEdge edge : edges) {
            if (!(edge instanceof FunctionalExchange) || !scope.contains("SOURCE_SCOPE", (EObject)edge, context_p)) continue;
            res.add((FunctionalExchange)edge);
        }
        return res;
    }

    protected Collection<FunctionalExchange> getFE(AbstractFunction function, IContext context_p) {
        ArrayList<FunctionalExchange> res = new ArrayList<FunctionalExchange>();
        res.addAll(FunctionExt.getIncomingExchange((AbstractFunction)function));
        res.addAll(FunctionExt.getOutGoingExchange((AbstractFunction)function));
        return res;
    }

    public Collection<? extends EObject> retrieveSharedElements(IContext context_p) {
        return Collections.emptyList();
    }

    public static boolean isLinkToPrimaryFunction(AbstractFunction function, IContext context_p) {
        ArrayList edges = new ArrayList();
        edges.addAll(function.getIncoming());
        edges.addAll(function.getOutgoing());
        IContextScopeHandler scope = ContextScopeHandlerHelper.getInstance((IContext)context_p);
        for (ActivityEdge edge : edges) {
            if (!(edge instanceof FunctionalExchange)) continue;
            FunctionalExchange fe = (FunctionalExchange)edge;
            AbstractFunction opposite = null;
            opposite = fe.getSource().eContainer().equals(function) ? (AbstractFunction)fe.getTarget().eContainer() : (AbstractFunction)fe.getSource().eContainer();
            if (!scope.contains("SOURCE_SCOPE", (EObject)opposite, context_p)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLinkToPrimaryFunction(FunctionalExchange exchange_p, IContext context_p) {
        AbstractFunction source = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)exchange_p);
        AbstractFunction target = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)exchange_p);
        if (ExternalFunctionsScopeRetriever.isPrimaryFunction(source, context_p)) {
            return !ExternalFunctionsScopeRetriever.isPrimaryFunction(target, context_p);
        }
        if (ExternalFunctionsScopeRetriever.isPrimaryFunction(target, context_p)) {
            return !ExternalFunctionsScopeRetriever.isPrimaryFunction(source, context_p);
        }
        return false;
    }

    public static boolean isPrimaryExchange(FunctionalExchange exchange_p, IContext context_p) {
        AbstractFunction source = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)exchange_p);
        AbstractFunction target = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)exchange_p);
        return ExternalFunctionsScopeRetriever.isPrimaryFunction(source, context_p) && ExternalFunctionsScopeRetriever.isPrimaryFunction(target, context_p);
    }

    public static boolean isPrimaryFunction(AbstractFunction function, IContext context_p) {
        return ContextScopeHandlerHelper.getInstance((IContext)context_p).contains("SOURCE_SCOPE", (EObject)function, context_p);
    }
}

