/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.core.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.IArtifactMetaModelAdapter;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.adapters.ITraceabilityInformationModelAdapter;
import org.eclipse.capra.core.handlers.AnnotationException;
import org.eclipse.capra.core.handlers.IAnnotateArtifact;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class TraceHelper {
    private EObject traceModel;
    private ITraceabilityInformationModelAdapter traceAdapter = ExtensionPointHelper.getTraceabilityInformationModelAdapter().orElseThrow();
    private IArtifactMetaModelAdapter artifactAdapter = ExtensionPointHelper.getArtifactMetaModelAdapter().orElseThrow();

    public TraceHelper() {
        ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
        IPersistenceAdapter tracePersistenceAdapter = ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        this.traceModel = tracePersistenceAdapter.getTraceModel(resourceSet);
    }

    public TraceHelper(EObject traceModel) {
        this.traceModel = traceModel;
    }

    public EObject createTrace(List<EObject> origins, List<EObject> targets, EClass traceType) {
        return this.traceAdapter.createTrace(traceType, this.traceModel, origins, targets);
    }

    public void deleteTraces(List<Connection> toDelete) {
        this.traceAdapter.deleteTrace(toDelete, this.traceModel);
    }

    public void updateTrace(final Connection connection, final String featureName, final Object value) throws InterruptedException, IllegalStateException {
        TransactionalEditingDomain editingDomain = EditingDomainHelper.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain, "Update Trace Model"){

            protected void doExecute() {
                EStructuralFeature structuralFeature = connection.getTlink().eClass().getEStructuralFeature(featureName);
                connection.getTlink().eSet(structuralFeature, value);
            }
        };
        try {
            ((TransactionalCommandStack)editingDomain.getCommandStack()).execute((Command)cmd, null);
        }
        catch (RollbackException rbe) {
            throw new IllegalStateException(rbe.getMessage(), rbe.getCause());
        }
    }

    public void annotateTrace(List<EObject> wrappers) {
        for (EObject wrapper : wrappers) {
            IArtifactHandler<?> handler = this.artifactAdapter.getArtifactHandlerInstance(wrapper);
            if (!(handler instanceof IAnnotateArtifact)) continue;
            IAnnotateArtifact h = (IAnnotateArtifact)((Object)handler);
            try {
                HashSet connectedElements = new HashSet();
                StringBuilder annotation = new StringBuilder();
                List<Connection> connections = this.traceAdapter.getConnectedElements(wrapper, this.traceModel);
                connections.forEach(c -> c.getTargets().forEach(t -> {
                    if (t != wrapper) {
                        connectedElements.add(t);
                    }
                }));
                connectedElements.forEach(e -> {
                    if (annotation.length() > 0) {
                        annotation.append(", ");
                    }
                    String name = this.artifactAdapter.getArtifactName((EObject)e);
                    annotation.append(name);
                });
                h.annotateArtifact(wrapper, annotation.toString());
            }
            catch (AnnotationException annotationException) {
                // empty catch block
            }
        }
    }

    public List<EObject> getTracedElements(Connection connection) {
        ArrayList<EObject> tracedElements = new ArrayList<EObject>();
        for (EObject origin : connection.getOrigins()) {
            if (tracedElements.contains(origin)) continue;
            tracedElements.add(origin);
        }
        for (EObject target : connection.getTargets()) {
            if (tracedElements.contains(target)) continue;
            tracedElements.addAll(connection.getTargets());
        }
        return tracedElements;
    }

    @Deprecated
    public boolean traceExists(List<EObject> selection, EClass traceType) {
        return !this.getTraces(selection, traceType).isEmpty();
    }

    public boolean traceExists(List<EObject> origins, List<EObject> targets, EClass traceType) {
        return !this.getTraces(origins, targets, traceType).isEmpty();
    }

    @Deprecated
    public List<Connection> getTraces(List<EObject> selection, EClass traceType) {
        ArrayList<EObject> targets = new ArrayList<EObject>(selection);
        EObject origin = (EObject)targets.get(0);
        targets.remove(0);
        return this.getTraces(Arrays.asList(origin), targets, traceType);
    }

    public List<Connection> getTraces(List<EObject> origins, List<EObject> targets, EClass traceType) {
        EObject tempTraceModel = ExtensionPointHelper.getPersistenceAdapter().orElseThrow().getTraceModel((ResourceSet)new ResourceSetImpl());
        EObject tempTlink = this.traceAdapter.createTrace(traceType, tempTraceModel, origins, targets);
        Connection connection = new Connection(origins, targets, tempTlink);
        return this.traceAdapter.getAllTraceLinks(this.traceModel).stream().filter(c -> c.equals(connection)).collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean isArtifactInTraceModel(EObject artifact) {
        List<Connection> connections = this.traceAdapter.getAllTraceLinks(this.traceModel);
        for (Connection c : connections) {
            for (EObject a : this.getTracedElements(c)) {
                if (!EcoreUtil.equals((EObject)artifact, (EObject)a)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Connection> getTraces(List<EObject> artifacts) {
        List<Connection> connections = this.traceAdapter.getAllTraceLinks(this.traceModel);
        ArrayList<Connection> possibleConnections = new ArrayList<Connection>();
        ArrayList<Connection> relevantConnections = new ArrayList<Connection>();
        if (artifacts != null && !artifacts.isEmpty()) {
            for (Connection c : connections) {
                List<EObject> artifactsFromConnection = this.getTracedElements(c);
                for (EObject a : artifactsFromConnection) {
                    if (artifacts.contains(a) && !possibleConnections.contains(c)) {
                        possibleConnections.add(c);
                        continue;
                    }
                    if (!artifacts.contains(a) || !possibleConnections.contains(c)) continue;
                    relevantConnections.add(c);
                }
            }
        }
        return relevantConnections;
    }

    public static Set<EObject> getTracedElements(Collection<Connection> traces) {
        HashSet<EObject> inserted = new HashSet<EObject>();
        for (Connection trace : traces) {
            inserted.addAll(trace.getOrigins());
            inserted.addAll(trace.getTargets());
        }
        return inserted;
    }
}

