/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.handler.file.notification;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.IArtifactMetaModelAdapter;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.handler.file.FileHandler;
import org.eclipse.capra.ui.notification.CapraNotificationHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class FileChangeListener
implements IResourceChangeListener {
    private final IArtifactMetaModelAdapter artifactAdapter = (IArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactMetaModelAdapter().orElseThrow();

    public void resourceChanged(IResourceChangeEvent event) {
        IPersistenceAdapter tracePersistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        EObject artifactModel = tracePersistenceAdapter.getArtifactWrappers(EditingDomainHelper.getResourceSet());
        List allArtifacts = this.artifactAdapter.getAllArtifacts(artifactModel);
        final List fileArtifacts = allArtifacts.stream().filter(p -> this.artifactAdapter.getArtifactHandler(p).equals(FileHandler.class.getName())).collect(Collectors.toList());
        if (fileArtifacts.isEmpty()) {
            return;
        }
        Path path = new Path(EcoreUtil.getURI((EObject)artifactModel).toPlatformString(false));
        final IFile wrapperContainer = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(final IResourceDelta delta) throws CoreException {
                WorkspaceJob job = new WorkspaceJob("CapraNotificationJob"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        FileChangeListener.this.handleDelta(delta, fileArtifacts, wrapperContainer);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
                return true;
            }
        };
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta.accept(visitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void handleDelta(IResourceDelta delta, List<EObject> fileArtifacts, IFile wrapperContainer) {
        for (EObject aw : fileArtifacts) {
            if (!this.artifactAdapter.getArtifactUri(aw).equals(delta.getFullPath().toString())) continue;
            int changeType = delta.getKind();
            CapraNotificationHelper.IssueType issueType = null;
            if (changeType == 2) {
                IPath toPath = delta.getMovedToPath();
                issueType = toPath == null ? CapraNotificationHelper.IssueType.DELETED : (delta.getFullPath().toFile().getName().equals(toPath.toFile().getName()) ? CapraNotificationHelper.IssueType.MOVED : CapraNotificationHelper.IssueType.RENAMED);
            } else if (changeType == 4) {
                issueType = CapraNotificationHelper.IssueType.CHANGED;
            } else if (changeType == 1) {
                issueType = CapraNotificationHelper.IssueType.ADDED;
            }
            if (issueType == CapraNotificationHelper.IssueType.ADDED) {
                CapraNotificationHelper.deleteCapraMarker((String)this.artifactAdapter.getArtifactUri(aw), (CapraNotificationHelper.IssueType[])new CapraNotificationHelper.IssueType[]{CapraNotificationHelper.IssueType.MOVED, CapraNotificationHelper.IssueType.RENAMED, CapraNotificationHelper.IssueType.DELETED}, (IFile)wrapperContainer);
                continue;
            }
            if (issueType == null) continue;
            Map<String, String> markerInfo = this.generateMarkerInfo(delta, issueType);
            CapraNotificationHelper.createCapraMarker(markerInfo, (IResource)wrapperContainer);
        }
    }

    private Map<String, String> generateMarkerInfo(IResourceDelta delta, CapraNotificationHelper.IssueType issueType) {
        HashMap<String, String> markerInfo = new HashMap<String, String>();
        String oldArtifactUri = delta.getFullPath().toString();
        IPath newArtifactUri = delta.getMovedToPath();
        String message = "";
        switch (issueType) {
            case RENAMED: {
                message = String.valueOf(oldArtifactUri) + " has been renamed to " + newArtifactUri + ".";
                break;
            }
            case MOVED: {
                message = String.valueOf(oldArtifactUri) + " has been moved to " + newArtifactUri + ".";
                break;
            }
            case DELETED: {
                message = String.valueOf(oldArtifactUri) + " has been deleted.";
                break;
            }
            case CHANGED: {
                message = String.valueOf(oldArtifactUri) + " has been changed. Please check if associated trace links are still valid.";
                break;
            }
        }
        markerInfo.put("issueType", issueType.getValue());
        markerInfo.put("message", message);
        markerInfo.put("oldArtifactUri", oldArtifactUri);
        if (newArtifactUri != null) {
            markerInfo.put("newArtifactUri", newArtifactUri.toString());
            markerInfo.put("newArtifactName", newArtifactUri.toFile().getName());
        }
        return markerInfo;
    }
}

