/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.office.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.ConnectionQuery;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.adapters.ITraceabilityInformationModelAdapter;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.office.model.CapraOfficeObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;

public class OfficeTableDataProvider
implements IDataProvider {
    private List<EntryData> rows = new ArrayList<EntryData>();
    private List<EntryData> columns = new ArrayList<EntryData>();
    private List<CapraOfficeObject> officeObjects;
    private Map<String, List<String>> cellValue = new HashMap<String, List<String>>();
    private Map<Integer, CapraOfficeObject> mappedObjects = new HashMap<Integer, CapraOfficeObject>();

    public OfficeTableDataProvider(List<CapraOfficeObject> officeObjects) {
        this.officeObjects = officeObjects;
        int count = 0;
        for (CapraOfficeObject element : officeObjects) {
            EntryData rowEntry = new EntryData(this.getAllCapraOfficeObjectsIDForRow(element));
            this.mappedObjects.put(count, element);
            ArrayList cols = new ArrayList();
            if (count == 0) {
                this.getAllCapraOfficeObjectsForRow(element).forEach(v -> this.columns.add(new EntryData((String)v)));
            } else {
                this.getAllCapraOfficeObjectsForRow(element).forEach(v -> cols.add(v));
                this.cellValue.put(this.getAllCapraOfficeObjectsIDForRow(element), cols);
                this.rows.add(rowEntry);
            }
            ++count;
        }
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    private List<String> getAllCapraOfficeObjectsForRow(CapraOfficeObject obj) {
        List<String> cellValue = Arrays.asList(obj.getData().split("[|:]"));
        ArrayList<String> elements = new ArrayList<String>();
        elements.addAll(cellValue);
        elements.remove(0);
        return elements;
    }

    private String getAllCapraOfficeObjectsIDForRow(CapraOfficeObject obj) {
        List<String> cellValue = Arrays.asList(obj.getData().split(":"));
        return cellValue.get(0);
    }

    public Object getDataValue(int colIndex, int rowIndex) {
        EntryData rowEntry = this.rows.get(rowIndex);
        return this.cellValue.get(rowEntry.officeObject).get(colIndex);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public void setDataValue(int arg0, int arg1, Object arg2) {
        throw new UnsupportedOperationException();
    }

    public List<Object> getColumns() {
        return this.columns.stream().map(e -> e.officeObject).collect(Collectors.toCollection(ArrayList::new));
    }

    public String getColumn(int index) {
        return this.columns.get((int)index).officeObject;
    }

    public CapraOfficeObject getColumnHighlight(int index) {
        return this.mappedObjects.get(index);
    }

    public CapraOfficeObject getRowHighlight(int index) {
        return this.mappedObjects.get(index);
    }

    public List<Object> getRows() {
        return this.rows.stream().map(e -> e.officeObject).collect(Collectors.toCollection(ArrayList::new));
    }

    public String getRow(int index) {
        return this.rows.get((int)index).officeObject;
    }

    public List<CapraOfficeObject> getAllEllements() {
        return this.officeObjects;
    }

    public List<EntryData> getAllRows() {
        return this.rows;
    }

    public List<Connection> getIncomingConnectionsForRow(int rowPosition) {
        return this.getConnectionsForOfficeObject(rowPosition, true);
    }

    public List<Connection> getOutgoingConnectionsForRow(int rowPosition) {
        return this.getConnectionsForOfficeObject(rowPosition, false);
    }

    private List<Connection> getConnectionsForOfficeObject(int rowPosition, boolean reverseDirection) {
        CapraOfficeObject officeObject = this.getRowHighlight(rowPosition);
        IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        ITraceabilityInformationModelAdapter timAdapter = (ITraceabilityInformationModelAdapter)ExtensionPointHelper.getTraceabilityInformationModelAdapter().orElseThrow();
        ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
        EObject traceModel = persistenceAdapter.getTraceModel(resourceSet);
        EObject artifactModel = persistenceAdapter.getArtifactWrappers(resourceSet);
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        EObject officeObjectWrapper = artifactHelper.createWrapper((Object)officeObject);
        ConnectionQuery incomingLinksQuery = ConnectionQuery.of((EObject)traceModel, (EObject)officeObjectWrapper).setReverseDirection(reverseDirection).build();
        return timAdapter.getConnections(incomingLinksQuery);
    }

    private class EntryData {
        private String officeObject;

        public EntryData(String officeObject) {
            this.officeObject = officeObject;
        }
    }
}

