/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudFoundryCredentialsPart;
import org.eclipse.cft.server.ui.internal.CloudServerSpacesDelegate;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.ValidationEventHandler;
import org.eclipse.cft.server.ui.internal.wizards.CredentialsWizardValidator;
import org.eclipse.cft.server.ui.internal.wizards.WizardPageStatusHandler;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CloudFoundryCredentialsWizardPage
extends WizardPage {
    private final CloudFoundryCredentialsPart credentialsPart;
    private CloudServerSpacesDelegate cloudServerSpaceDelegate;
    private ValidationEventHandler validationNotifier;

    protected CloudFoundryCredentialsWizardPage(CloudFoundryServer server) {
        super(String.valueOf(server.getServer().getName()) + Messages.CloudFoundryCredentialsWizardPage_TEXT_CRENDENTIAL);
        this.cloudServerSpaceDelegate = new CloudServerSpacesDelegate(server);
        WizardPageStatusHandler wizardUpdateHandler = new WizardPageStatusHandler(this);
        this.validationNotifier = new ValidationEventHandler(new CredentialsWizardValidator(server, this.cloudServerSpaceDelegate));
        this.validationNotifier.addStatusHandler(wizardUpdateHandler);
        this.credentialsPart = new CloudFoundryCredentialsPart(server, this);
        this.validationNotifier.addValidationListener(this.credentialsPart);
        this.credentialsPart.addPartChangeListener(this.validationNotifier);
    }

    public void createControl(Composite parent) {
        Control control = this.credentialsPart.createPart(parent);
        this.setControl(control);
    }

    public boolean isPageComplete() {
        return this.validationNotifier.isOK();
    }

    public CloudServerSpacesDelegate getServerSpaceDelegate() {
        return this.cloudServerSpaceDelegate;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getNextPage() != null;
    }
}

