/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.purity;

import org.eclipse.chemclipse.chromatogram.msd.comparison.exceptions.ComparisonException;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.purity.IMassSpectrumPurityResult;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IIonRange;

public abstract class AbstractMassSpectrumPurityResult
implements IMassSpectrumPurityResult {
    private float fitValue = 0.0f;
    private float reverseFitValue = 0.0f;

    public AbstractMassSpectrumPurityResult(IScanMSD unknown, IScanMSD reference) throws ComparisonException {
        if (unknown == null) {
            throw new ComparisonException("The unknown must not be null.");
        }
        if (reference == null) {
            throw new ComparisonException("The reference must not be null.");
        }
        this.fitValue = this.calculateFitValue(unknown, reference);
        this.reverseFitValue = this.calculateReverseFitValue(unknown, reference);
    }

    @Override
    public float getFitValue() {
        return this.fitValue * 100.0f;
    }

    @Override
    public float getReverseFitValue() {
        return this.reverseFitValue * 100.0f;
    }

    private float calculateFitValue(IScanMSD unknown, IScanMSD reference) {
        IIonRange ionRange = unknown.getExtractedIonSignal().getIonRange();
        IExtractedIonSignal u = unknown.getExtractedIonSignal((double)ionRange.getStartIon(), (double)ionRange.getStopIon());
        IExtractedIonSignal r = reference.getExtractedIonSignal((double)ionRange.getStartIon(), (double)ionRange.getStopIon());
        return this.calculateMatch(u, r);
    }

    private float calculateReverseFitValue(IScanMSD unknown, IScanMSD reference) {
        IIonRange ionRange = reference.getExtractedIonSignal().getIonRange();
        IExtractedIonSignal u = unknown.getExtractedIonSignal((double)ionRange.getStartIon(), (double)ionRange.getStopIon());
        IExtractedIonSignal r = reference.getExtractedIonSignal((double)ionRange.getStartIon(), (double)ionRange.getStopIon());
        return this.calculateMatch(r, u);
    }

    private float calculateMatch(IExtractedIonSignal massSpectrum1, IExtractedIonSignal massSpectrum2) {
        int startIon = massSpectrum1.getStartIon();
        int stopIon = massSpectrum1.getStopIon();
        float abundance = 0.0f;
        int count = 0;
        int match = 0;
        int ion = startIon;
        while (ion <= stopIon) {
            abundance = massSpectrum1.getAbundance(ion);
            if (abundance > 0.0f) {
                ++count;
                if (massSpectrum2.getAbundance(ion) > 0.0f) {
                    ++match;
                }
            }
            ++ion;
        }
        if (count == 0) {
            return 0.0f;
        }
        return 1.0f / (float)count * (float)match;
    }
}

