/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.core;

import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.IPeakIdentifierMSD;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IPeakIdentifierSettingsMSD;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.internal.identifier.FileIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.PeakIdentifierSettings;
import org.eclipse.chemclipse.model.identifier.IPeakIdentificationResults;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakIdentifierFile
implements IPeakIdentifierMSD<IPeakIdentificationResults> {
    public IProcessingInfo<IPeakIdentificationResults> identify(List<? extends IPeakMSD> peaks, IPeakIdentifierSettingsMSD identifierSettings, IProgressMonitor monitor) {
        if (identifierSettings == null) {
            identifierSettings = PreferenceSupplier.getPeakIdentifierSettings();
        }
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (identifierSettings instanceof PeakIdentifierSettings) {
            try {
                PeakIdentifierSettings peakIdentifierSettings = (PeakIdentifierSettings)identifierSettings;
                FileIdentifier fileIdentifier = new FileIdentifier();
                IPeakIdentificationResults peakIdentificationResults = fileIdentifier.runPeakIdentification(peaks, peakIdentifierSettings, (IProcessingInfo<?>)processingInfo, monitor);
                processingInfo.setProcessingResult((Object)peakIdentificationResults);
                processingInfo.addInfoMessage("File Identifier", "Done - peaks have been identified.");
            }
            catch (FileNotFoundException e) {
                processingInfo.addErrorMessage("File Identifier", "An I/O error ocurred.");
            }
        } else {
            processingInfo.addErrorMessage("File Identifier", "The settings are not of type: " + PeakIdentifierSettings.class);
        }
        return processingInfo;
    }
}

