/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.peak;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.IPeakIdentifierSupplierMSD;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.IPeakIdentifierSupportMSD;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.PeakIdentifierMSD;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IPeakIdentifierSettingsMSD;
import org.eclipse.chemclipse.model.exceptions.NoIdentifierAvailableException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class PeakIdentifierMSDProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Peak Identifier";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            IPeakIdentifierSupportMSD support = PeakIdentifierMSD.getPeakIdentifierSupport();
            ArrayList list = new ArrayList();
            for (String processorId : support.getAvailableIdentifierIds()) {
                IPeakIdentifierSupplierMSD supplier = support.getIdentifierSupplier(processorId);
                list.add((IProcessSupplier<?>)new PeakIdentifierProcessorSupplier(supplier, this));
            }
            return list;
        }
        catch (NoIdentifierAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class PeakIdentifierProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IPeakIdentifierSettingsMSD> {
        private IPeakIdentifierSupplierMSD supplier;

        public PeakIdentifierProcessorSupplier(IPeakIdentifierSupplierMSD supplier, IProcessTypeSupplier parent) {
            super("PeakIdentifierMSD." + supplier.getId(), supplier.getIdentifierName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.MSD});
            this.supplier = supplier;
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IPeakIdentifierSettingsMSD processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
                IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
                if (processSettings instanceof IPeakIdentifierSettingsMSD) {
                    messageConsumer.addMessages(PeakIdentifierMSD.identify(chromatogramSelectionMSD, processSettings, this.supplier.getId(), monitor));
                } else {
                    messageConsumer.addMessages(PeakIdentifierMSD.identify(chromatogramSelectionMSD, this.supplier.getId(), monitor));
                }
            } else {
                messageConsumer.addWarnMessage(this.getName(), "Only MSD chromatogram supported, skipp processing");
            }
            return chromatogramSelection;
        }

        public boolean matchesId(String id) {
            return super.matchesId(id) || this.supplier.getId().equals(id);
        }
    }
}

