/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.core.BatchProcess;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.io.JobWriter;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.BatchProcessJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.Activator;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.internal.runnables.ImportRunnable;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.model.ChromatogramInputEntry;
import org.eclipse.chemclipse.converter.model.IChromatogramInputEntry;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.methods.ProcessMethod;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.processing.ui.E4ProcessSupplierContext;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.BatchJobUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class BatchJobEditor
extends EditorPart
implements IRunnableWithProgress {
    private static final DataType[] DATA_TYPES = new DataType[]{DataType.CSD, DataType.MSD, DataType.WSD};
    private static final Logger logger = Logger.getLogger(BatchJobEditor.class);
    private BatchJobUI batchJobUI;
    private File file;
    private boolean isDirty = false;
    private BatchProcessJob currentJob;
    private E4ProcessSupplierContext supplierContext;

    public void doSave(IProgressMonitor monitor) {
        if (this.file != null) {
            JobWriter writer = new JobWriter();
            try {
                this.currentJob = this.getBatchProcessJob();
                writer.writeBatchProcessJob(this.file, this.currentJob, monitor);
                this.updateDirtyStatus(false);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
            }
            catch (FileIsNotWriteableException e) {
                logger.warn((Object)e);
            }
            catch (IOException e) {
                logger.warn((Object)e);
            }
            catch (XMLStreamException e) {
                logger.warn((Object)e);
            }
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        String fileName = input.getName();
        fileName = fileName.substring(0, fileName.length() - 4);
        this.setPartName(fileName);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)input;
            this.file = fileEditorInput.getFile().getLocation().toFile();
            ImportRunnable runnable = new ImportRunnable(this.file);
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(site.getShell());
            try {
                monitor.run(false, true, (IRunnableWithProgress)runnable);
                this.currentJob = runnable.getBatchProcessJob();
            }
            catch (InvocationTargetException e) {
                throw new PartInitException("The file could't be loaded.", (Throwable)e);
            }
            catch (InterruptedException e) {
                return;
            }
        } else {
            throw new PartInitException("The file could't be loaded.");
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void updateDirtyStatus(boolean dirty) {
        if (dirty && this.getBatchProcessJob().equals((Object)this.currentJob)) {
            dirty = false;
        }
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.supplierContext = (E4ProcessSupplierContext)ContextInjectionFactory.make(E4ProcessSupplierContext.class, (IEclipseContext)ModelSupportAddon.getEclipseContext());
        this.batchJobUI = new BatchJobUI(parent, (ProcessSupplierContext)this.supplierContext, Activator.getDefault().getPreferenceStore(), "filterPathImportRecords", DATA_TYPES, (IRunnableWithProgress)this);
        this.batchJobUI.setModificationHandler(this::updateDirtyStatus);
        if (this.currentJob != null) {
            List chromatogramInputEntries = this.currentJob.getChromatogramInputEntries();
            ArrayList<File> files = new ArrayList<File>();
            for (IChromatogramInputEntry entry : chromatogramInputEntries) {
                files.add(new File(entry.getInputFile()));
            }
            this.batchJobUI.doLoad(files, (IProcessMethod)new ProcessMethod(this.currentJob.getProcessMethod()));
        } else {
            this.batchJobUI.doLoad(Collections.emptyList(), (IProcessMethod)new ProcessMethod());
        }
    }

    public void setFocus() {
        this.batchJobUI.setFocus();
    }

    private BatchProcessJob getBatchProcessJob() {
        BatchProcessJob job = new BatchProcessJob(this.batchJobUI.getMethod().getProcessMethod());
        List entries = job.getChromatogramInputEntries();
        for (File file : this.batchJobUI.getDataList().getFiles()) {
            entries.add(new ChromatogramInputEntry(file.getAbsolutePath()));
        }
        return job;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        BatchProcess batchProcess = new BatchProcess(DATA_TYPES, (ProcessSupplierContext)this.supplierContext);
        IProcessingInfo processingInfo = batchProcess.execute(this.getBatchProcessJob(), monitor);
        ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)processingInfo);
    }
}

