/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.AbstractBaselineDetector;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.settings.IBaselineDetectorSettings;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.core.support.IMarkedWavelengths;
import org.eclipse.chemclipse.wsd.model.xwc.ExtractedSingleWavelengthSignalExtractor;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedSingleWavelengthSignalExtractor;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedSingleWavelengthSignals;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractBaselineSignalDetector
extends AbstractBaselineDetector {
    @Override
    public IProcessingInfo setBaseline(IChromatogramSelection chromatogramSelection, IBaselineDetectorSettings baselineDetectorSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, baselineDetectorSettings, monitor);
        if (!processingInfo.hasErrorMessages()) {
            return this.process(chromatogramSelection, baselineDetectorSettings, monitor);
        }
        return processingInfo;
    }

    @Override
    public IProcessingInfo setBaseline(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, monitor);
        if (!processingInfo.hasErrorMessages()) {
            return this.process(chromatogramSelection, null, monitor);
        }
        return processingInfo;
    }

    private IProcessingInfo process(IChromatogramSelection chromatogramSelection, IBaselineDetectorSettings settings, IProgressMonitor monitor) {
        if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
            return this.process((IChromatogramSelectionMSD)chromatogramSelection, settings, monitor);
        }
        if (chromatogramSelection instanceof IChromatogramSelectionCSD) {
            return this.process((IChromatogramSelectionCSD)chromatogramSelection, settings, monitor);
        }
        if (chromatogramSelection instanceof IChromatogramSelectionWSD) {
            return this.process((IChromatogramSelectionWSD)chromatogramSelection, settings, monitor);
        }
        throw new UnsupportedOperationException("Class " + chromatogramSelection.getClass().getName() + " is not supported");
    }

    private IProcessingInfo process(IChromatogramSelectionCSD chromatogramSelection, IBaselineDetectorSettings settings, IProgressMonitor monitor) {
        IChromatogramCSD chromatogramCSD = chromatogramSelection.getChromatogramCSD();
        TotalScanSignalExtractor totalScanSignalExtractor = new TotalScanSignalExtractor((IChromatogram)chromatogramCSD);
        ITotalScanSignals totalSignals = totalScanSignalExtractor.getTotalScanSignals((IChromatogramSelection)chromatogramSelection, false);
        IProcessingInfo processInfo = this.baselineProcess(totalSignals, settings, monitor);
        if (!processInfo.hasErrorMessages()) {
            this.applyBaseline(totalSignals, chromatogramCSD.getBaselineModel(), monitor);
        }
        return processInfo;
    }

    private IProcessingInfo process(IChromatogramSelectionMSD chromatogramSelection, IBaselineDetectorSettings settings, IProgressMonitor monitor) {
        IChromatogramMSD chromatogramMSD = chromatogramSelection.getChromatogramMSD();
        TotalScanSignalExtractor totalScanSignalExtractor = new TotalScanSignalExtractor((IChromatogram)chromatogramMSD);
        ITotalScanSignals totalSignals = totalScanSignalExtractor.getTotalScanSignals((IChromatogramSelection)chromatogramSelection, true);
        IProcessingInfo processInfo = this.baselineProcess(totalSignals, settings, monitor);
        if (!processInfo.hasErrorMessages()) {
            totalSignals.setNegativeTotalSignalsToZero();
            this.applyBaseline(totalSignals, chromatogramMSD.getBaselineModel(), monitor);
        }
        return processInfo;
    }

    private IProcessingInfo process(IChromatogramSelectionWSD chromatogramSelection, IBaselineDetectorSettings settings, IProgressMonitor monitor) {
        TotalScanSignalExtractor totalScanSignalExtractor;
        ITotalScanSignals iTotalScanSignals;
        IProcessingInfo processInfo;
        IChromatogramWSD chromatogramWSD = chromatogramSelection.getChromatogramWSD();
        ExtractedSingleWavelengthSignalExtractor extractor = new ExtractedSingleWavelengthSignalExtractor(chromatogramWSD, false);
        int startScan = chromatogramWSD.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogramWSD.getScanNumber(chromatogramSelection.getStopRetentionTime());
        IMarkedWavelengths markedWavelenghts = chromatogramSelection.getSelectedWavelengths();
        List extractedSingleWavelengthSignals = extractor.getExtractedWavelengthSignals(startScan, stopScan, markedWavelenghts);
        ProcessingInfo processingInfoTotal = new ProcessingInfo();
        for (IExtractedSingleWavelengthSignals totalSignals2 : extractedSingleWavelengthSignals) {
            IProcessingInfo processingInfo = this.baselineProcess((ITotalScanSignals)totalSignals2, settings, monitor);
            processingInfoTotal.addMessages(processingInfo);
        }
        if (!processingInfoTotal.hasErrorMessages()) {
            SortedMap sortedSignalsMap = IExtractedSingleWavelengthSignalExtractor.sortExtractedSignals((List)extractedSingleWavelengthSignals);
            for (Map.Entry entry : sortedSignalsMap.entrySet()) {
                double wavelength = (Double)entry.getKey();
                IBaselineModel baselineModel = chromatogramWSD.getBaselineModel(wavelength);
                SortedSet signalsOnWavelength = (SortedSet)entry.getValue();
                for (IExtractedSingleWavelengthSignals signals : signalsOnWavelength) {
                    this.applyBaseline((ITotalScanSignals)signals, baselineModel, monitor);
                }
            }
        }
        if (!(processInfo = this.baselineProcess(iTotalScanSignals = (totalScanSignalExtractor = new TotalScanSignalExtractor((IChromatogram)chromatogramWSD)).getTotalScanSignals((IChromatogramSelection)chromatogramSelection, false), settings, monitor)).hasErrorMessages()) {
            this.applyBaseline(iTotalScanSignals, chromatogramWSD.getBaselineModel(), monitor);
        }
        return processingInfoTotal;
    }

    private IProcessingInfo baselineProcess(ITotalScanSignals totalScanSignals, IBaselineDetectorSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        if (chromatogramFilterSettings == null) {
            return this.setBaseline(totalScanSignals, monitor);
        }
        return this.setBaseline(totalScanSignals, chromatogramFilterSettings, monitor);
    }

    protected abstract IProcessingInfo setBaseline(ITotalScanSignals var1, IProgressMonitor var2);

    protected abstract IProcessingInfo setBaseline(ITotalScanSignals var1, IBaselineDetectorSettings var2, IProgressMonitor var3);

    private void applyBaseline(ITotalScanSignals totalIonSignals, IBaselineModel baselineModel, IProgressMonitor monitor) {
        ITotalScanSignal firstTotalSignal = totalIonSignals.getFirstTotalScanSignal();
        ITotalScanSignal lastTotalSignal = totalIonSignals.getLastTotalScanSignal();
        baselineModel.removeBaseline(firstTotalSignal.getRetentionTime(), lastTotalSignal.getRetentionTime());
        int scan = totalIonSignals.getStartScan();
        while (scan < totalIonSignals.getStopScan()) {
            ITotalScanSignal actualTotalIonSignal = totalIonSignals.getTotalScanSignal(scan);
            ITotalScanSignal nextTotalIonSignal = totalIonSignals.getNextTotalScanSignal(scan);
            int startRetentionTime = actualTotalIonSignal.getRetentionTime();
            float startBackgroundAbundance = actualTotalIonSignal.getTotalSignal();
            int stopRetentionTime = nextTotalIonSignal.getRetentionTime();
            float stopBackgroundAbundance = nextTotalIonSignal.getTotalSignal();
            baselineModel.addBaseline(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance, false);
            ++scan;
        }
    }
}

