/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.support;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.ChromatogramIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.ChromatogramIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.processor.BackgroundIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.processor.ChromatogramIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.settings.ChromatogramIntegrationSettings;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.implementation.IntegrationEntry;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramIntegratorSupport {
    public static final String INTEGRATOR_DESCRIPTION = "Integrator Trapezoid";

    public IChromatogramIntegrationResults calculateChromatogramIntegrationResults(IChromatogramSelection chromatogramSelection, ChromatogramIntegrationSettings chromatogramIntegrationSettings, IProgressMonitor monitor) {
        List<IIntegrationEntry> chromatogramIntegrationEntries = this.calculateChromatogramIntegrationEntry(chromatogramSelection, monitor);
        List<IIntegrationEntry> backgroundIntegrationEntries = this.calculateBackgroundIntegrationEntry(chromatogramSelection, monitor);
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        chromatogram.setIntegratedArea(chromatogramIntegrationEntries, backgroundIntegrationEntries, INTEGRATOR_DESCRIPTION);
        double chromatogramArea = this.getArea(chromatogramIntegrationEntries);
        double backgroundArea = this.getArea(backgroundIntegrationEntries);
        ChromatogramIntegrationResults chromatogramIntegrationResults = new ChromatogramIntegrationResults();
        ChromatogramIntegrationResult chromatogramIntegrationResult = new ChromatogramIntegrationResult(chromatogramArea, backgroundArea);
        chromatogramIntegrationResults.add((IChromatogramIntegrationResult)chromatogramIntegrationResult);
        return chromatogramIntegrationResults;
    }

    private List<IIntegrationEntry> calculateChromatogramIntegrationEntry(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        ArrayList<IIntegrationEntry> chromatogramIntegrationEntries = new ArrayList<IIntegrationEntry>();
        ChromatogramIntegrator chromatogramIntegrator = new ChromatogramIntegrator();
        double chromatogramArea = chromatogramIntegrator.integrate(chromatogramSelection);
        IntegrationEntry chromatogramIntegrationEntry = null;
        if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
            chromatogramIntegrationEntry = new IntegrationEntry(0.0, chromatogramArea);
        } else if (chromatogramSelection instanceof IChromatogramSelectionCSD) {
            chromatogramIntegrationEntry = new IntegrationEntry(chromatogramArea);
        }
        if (chromatogramIntegrationEntry != null) {
            chromatogramIntegrationEntries.add((IIntegrationEntry)chromatogramIntegrationEntry);
        }
        return chromatogramIntegrationEntries;
    }

    private List<IIntegrationEntry> calculateBackgroundIntegrationEntry(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        ArrayList<IIntegrationEntry> backgroundIntegrationEntries = new ArrayList<IIntegrationEntry>();
        BackgroundIntegrator backgroundIntegrator = new BackgroundIntegrator();
        double backgroundArea = backgroundIntegrator.integrate(chromatogramSelection);
        IntegrationEntry backgroundIntegrationEntry = null;
        if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
            backgroundIntegrationEntry = new IntegrationEntry(0.0, backgroundArea);
        } else if (chromatogramSelection instanceof IChromatogramSelectionCSD) {
            backgroundIntegrationEntry = new IntegrationEntry(backgroundArea);
        }
        if (backgroundIntegrationEntry != null) {
            backgroundIntegrationEntries.add((IIntegrationEntry)backgroundIntegrationEntry);
        }
        return backgroundIntegrationEntries;
    }

    private double getArea(List<IIntegrationEntry> integrationEntries) {
        double area = 0.0;
        for (IIntegrationEntry integrationEntry : integrationEntries) {
            area += integrationEntry.getIntegratedArea();
        }
        return area;
    }
}

