/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.core.chromatogram;

import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.chromatogram.ChromatogramIntegratorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.chromatogram.ChromatogramIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.chromatogram.IChromatogramIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.chromatogram.IChromatogramIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.chromatogram.IChromatogramIntegrationSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ChromatogramIntegrator {
    private static final Logger logger = Logger.getLogger(ChromatogramIntegrator.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.xxd.integrator.chromatogramIntegratorSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String INTEGRATOR_NAME = "integratorName";
    private static final String INTEGRATOR = "integrator";
    private static final String INTEGRATOR_SETTINGS = "integratorSettings";
    private static final String NO_INTEGRATOR_AVAILABLE = "There is no chromatogram integrator available.";

    private ChromatogramIntegrator() {
    }

    public static <T> IProcessingInfo<T> integrate(IChromatogramSelection<?, ?> chromatogramSelection, IChromatogramIntegrationSettings chromatogramIntegrationSettings, String integratorId, IProgressMonitor monitor) {
        IChromatogramIntegrator<T> integrator = ChromatogramIntegrator.getIntegrator(integratorId);
        IProcessingInfo<T> processingInfo = integrator != null ? integrator.integrate(chromatogramSelection, chromatogramIntegrationSettings, monitor) : ChromatogramIntegrator.getNoIntegratorAvailableProcessingInfo();
        return processingInfo;
    }

    public static <T> IProcessingInfo<T> integrate(IChromatogramSelection<?, ?> chromatogramSelection, String integratorId, IProgressMonitor monitor) {
        IChromatogramIntegrator<T> integrator = ChromatogramIntegrator.getIntegrator(integratorId);
        IProcessingInfo<T> processingInfo = integrator != null ? integrator.integrate(chromatogramSelection, monitor) : ChromatogramIntegrator.getNoIntegratorAvailableProcessingInfo();
        return processingInfo;
    }

    public static IChromatogramIntegratorSupport getChromatogramIntegratorSupport() {
        IConfigurationElement[] extensions;
        ChromatogramIntegratorSupport integratorSupport = new ChromatogramIntegratorSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ChromatogramIntegratorSupplier supplier = new ChromatogramIntegratorSupplier();
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setIntegratorName(element.getAttribute(INTEGRATOR_NAME));
            if (element.getAttribute(INTEGRATOR_SETTINGS) != null) {
                try {
                    IChromatogramIntegrationSettings instance = (IChromatogramIntegrationSettings)element.createExecutableExtension(INTEGRATOR_SETTINGS);
                    supplier.setSettingsClass(instance.getClass());
                }
                catch (CoreException e) {
                    logger.warn((Object)e);
                    supplier.setSettingsClass(null);
                }
            }
            integratorSupport.add(supplier);
            ++n2;
        }
        return integratorSupport;
    }

    private static <T> IChromatogramIntegrator<T> getIntegrator(String integratorId) {
        IConfigurationElement element = ChromatogramIntegrator.getConfigurationElement(integratorId);
        IChromatogramIntegrator instance = null;
        if (element != null) {
            try {
                instance = (IChromatogramIntegrator)element.createExecutableExtension(INTEGRATOR);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String integratorId) {
        IConfigurationElement[] elements;
        if ("".equals(integratorId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(integratorId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static <T> IProcessingInfo<T> getNoIntegratorAvailableProcessingInfo() {
        ProcessingInfo processingInfo = new ProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Chromatogram Integrator", NO_INTEGRATOR_AVAILABLE);
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }
}

