/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.result;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;

public abstract class AbstractPeakIntegrationResults
implements IPeakIntegrationResults {
    private List<IPeakIntegrationResult> peakIntegrationResults = new ArrayList<IPeakIntegrationResult>();

    @Override
    public void add(IPeakIntegrationResult peakIntegrationResult) {
        this.peakIntegrationResults.add(peakIntegrationResult);
    }

    @Override
    public void remove(IPeakIntegrationResult peakIntegrationResult) {
        this.peakIntegrationResults.remove(peakIntegrationResult);
    }

    @Override
    public int size() {
        return this.peakIntegrationResults.size();
    }

    @Override
    public IPeakIntegrationResult getPeakIntegrationResult(int i) {
        if (i >= 0 && i < this.peakIntegrationResults.size()) {
            return this.peakIntegrationResults.get(i);
        }
        return null;
    }

    @Override
    public List<IPeakIntegrationResult> getPeakIntegrationResultList() {
        return this.peakIntegrationResults;
    }

    @Override
    public List<IPeakIntegrationResult> getPeakIntegrationResultList(int ion) {
        ArrayList<IPeakIntegrationResult> results = new ArrayList<IPeakIntegrationResult>();
        for (IPeakIntegrationResult result : this.peakIntegrationResults) {
            Set<Integer> ions = result.getIntegratedIons();
            if (ions.size() != 1 || !ions.contains(ion)) continue;
            results.add(result);
        }
        return results;
    }

    @Override
    public List<IPeakIntegrationResult> getPeakIntegrationResultThatContains(int ion) {
        ArrayList<IPeakIntegrationResult> results = new ArrayList<IPeakIntegrationResult>();
        for (IPeakIntegrationResult result : this.peakIntegrationResults) {
            Set<Integer> ions = result.getIntegratedIons();
            if (!ions.contains(ion)) continue;
            results.add(result);
        }
        return results;
    }

    @Override
    public double getTotalPeakArea() {
        double integratedArea = 0.0;
        for (IPeakIntegrationResult result : this.peakIntegrationResults) {
            integratedArea += result.getIntegratedArea();
        }
        return integratedArea;
    }
}

