/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.provider;

import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Feature;
import org.eclipse.chemclipse.model.statistics.IVariable;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class FeatureEditingSupport
extends EditingSupport {
    private CellEditor cellEditor;
    private final ExtendedTableViewer tableViewer;
    private final String column;

    public FeatureEditingSupport(ExtendedTableViewer tableViewer, String column) {
        super((ColumnViewer)tableViewer);
        this.column = column;
        this.cellEditor = "Use".equals(column) ? new CheckboxCellEditor((Composite)tableViewer.getTable()) : new TextCellEditor((Composite)tableViewer.getTable());
        this.tableViewer = tableViewer;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        block15: {
            if (!(element instanceof Feature)) break block15;
            Feature feature = (Feature)element;
            IVariable variable = feature.getVariable();
            switch (this.column) {
                case "Use": {
                    return variable.isSelected();
                }
                case "Classification": {
                    String classification = variable.getClassification();
                    if (classification == null) {
                        return "";
                    }
                    return classification;
                }
                case "Description": {
                    String description = variable.getDescription();
                    if (description == null) {
                        return "";
                    }
                    return description;
                }
            }
        }
        return false;
    }

    protected void setValue(Object element, Object value) {
        block15: {
            if (!(element instanceof Feature)) break block15;
            Feature feature = (Feature)element;
            IVariable variable = feature.getVariable();
            switch (this.column) {
                case "Use": {
                    variable.setSelected(((Boolean)value).booleanValue());
                    break;
                }
                case "Classification": {
                    String classification = (String)value;
                    if ("".equals(classification)) {
                        variable.setClassification(null);
                        break;
                    }
                    variable.setClassification(classification);
                    break;
                }
                case "Description": {
                    String description = (String)value;
                    if ("".equals(description)) {
                        variable.setDescription(null);
                        break;
                    }
                    variable.setDescription(description);
                }
            }
            this.tableViewer.refresh(element);
        }
    }
}

