/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.support;

import java.util.Iterator;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IDataInputEntry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class InputFilesTable {
    private TableViewer tableViewer;

    public InputFilesTable(Composite composite, Object layoutData) {
        this.createTable(composite, layoutData);
    }

    private void createColumns() {
        String[] titles = new String[]{"Name", "Group", "Filename", "Path"};
        int[] bounds = new int[]{100, 100, 100, 100};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IDataInputEntry inputData = (IDataInputEntry)element;
                return inputData.getName();
            }
        });
        col = this.createTableViewerColumn(titles[1], bounds[1], 1);
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IDataInputEntry input = (IDataInputEntry)cell.getElement();
                String text = input.getGroupName() != null ? input.getGroupName() : "";
                cell.setText(text);
            }
        });
        col.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){
            private TextCellEditor editor;
            {
                this.editor = new TextCellEditor((Composite)InputFilesTable.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return this.editor;
            }

            protected Object getValue(Object element) {
                IDataInputEntry inputData = (IDataInputEntry)element;
                String groupName = inputData.getGroupName();
                if (groupName == null) {
                    return "";
                }
                return groupName;
            }

            protected void setValue(Object element, Object value) {
                IDataInputEntry inputData = (IDataInputEntry)element;
                String groupName = (String)value;
                if (!(groupName = groupName.trim()).isEmpty()) {
                    inputData.setGroupName(groupName);
                } else {
                    inputData.setGroupName(null);
                }
                InputFilesTable.this.update();
            }
        });
        col = this.createTableViewerColumn(titles[2], bounds[2], 2);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IDataInputEntry inputData = (IDataInputEntry)element;
                return inputData.getFileName();
            }
        });
        col = this.createTableViewerColumn(titles[3], bounds[3], 3);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IDataInputEntry inputData = (IDataInputEntry)element;
                return inputData.getInputFile();
            }
        });
    }

    private void createTable(Composite client, Object layoutData) {
        Table table = new Table(client, 67586);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData(layoutData);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createColumns();
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public void removeSelection() {
        Iterator it = this.tableViewer.getStructuredSelection().iterator();
        Object object = this.tableViewer.getInput();
        if (object instanceof List) {
            List inputs = (List)object;
            while (it.hasNext()) {
                inputs.remove(it.next());
            }
        }
        this.update();
    }

    public void setDataInputEntries(List<IDataInputEntry> dataInputEntries) {
        this.tableViewer.setInput(dataInputEntries);
    }

    public void update() {
        this.tableViewer.refresh();
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }
}

