/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Feature;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ISamplesPCA;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISampleData;
import org.eclipse.chemclipse.model.statistics.IVariable;

public class FeatureDataMatrix {
    private List<String> sampleNames = new ArrayList<String>();
    private List<Feature> features = new ArrayList<Feature>();

    public FeatureDataMatrix(ISamplesPCA<? extends IVariable, ? extends ISample> samples) {
        if (samples != null) {
            List variableList = samples.getVariables();
            List sampleList = samples.getSampleList();
            for (ISample sample : sampleList) {
                this.sampleNames.add(sample.getName());
            }
            for (IVariable variable : variableList) {
                this.features.add(new Feature(variable));
            }
            int i = 0;
            while (i < sampleList.size()) {
                ISample sample = (ISample)sampleList.get(i);
                List sampleDataList = sample.getSampleData();
                int j = 0;
                while (j < sampleDataList.size()) {
                    ISampleData sampleData = (ISampleData)sampleDataList.get(j);
                    this.features.get(j).getSampleData().add(sampleData);
                    ++j;
                }
                ++i;
            }
        }
    }

    public String getVariableName() {
        for (Feature feature : this.features) {
            String name = feature.getVariable().getType();
            if ("".equals(name)) continue;
            return name;
        }
        return "--";
    }

    public List<String> getSampleNames() {
        return Collections.unmodifiableList(this.sampleNames);
    }

    public List<Feature> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }
}

