/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.core;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.report.settings.IChromatogramReportSettings;
import org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.core.AbstractReport;
import org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.internal.support.SpecificationValidator;
import org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.io.ReportWriter2;
import org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.settings.ReportSettings1;
import org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.settings.ReportSettings2;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class Report2
extends AbstractReport {
    private static final Logger logger = Logger.getLogger(Report2.class);

    @Override
    public IProcessingInfo<File> report(File file, boolean append, List<IChromatogram<? extends IPeak>> chromatograms, IChromatogramReportSettings settings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(file = SpecificationValidator.validateSpecification(file));
        if (!processingInfo.hasErrorMessages()) {
            if (settings instanceof ReportSettings2) {
                ReportSettings2 reportSettings = (ReportSettings2)settings;
                ReportWriter2 chromatogramReport = new ReportWriter2();
                try {
                    chromatogramReport.generate(file, append, chromatograms, reportSettings, monitor);
                    processingInfo.setProcessingResult((Object)file);
                }
                catch (IOException e) {
                    logger.warn((Object)e);
                    processingInfo.addErrorMessage("ChemClipse Chromatogram Report", "The report couldn't be created. An error occured.");
                }
            } else {
                logger.warn((Object)("The settings are not of type: " + ReportSettings1.class));
            }
        }
        return processingInfo;
    }

    public IProcessingInfo<File> generate(File file, boolean append, IChromatogram<? extends IPeak> chromatogram, IProgressMonitor monitor) {
        List<IChromatogram<? extends IPeak>> chromatograms = this.getChromatogramList(chromatogram);
        ReportSettings2 settings = PreferenceSupplier.getReportSettings2();
        return this.report(file, append, chromatograms, (IChromatogramReportSettings)settings, monitor);
    }

    public IProcessingInfo<File> generate(File file, boolean append, List<IChromatogram<? extends IPeak>> chromatograms, IProgressMonitor monitor) {
        ReportSettings2 settings = PreferenceSupplier.getReportSettings2();
        return this.report(file, append, chromatograms, (IChromatogramReportSettings)settings, monitor);
    }
}

