/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.ui.adapters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import org.eclipse.chemclipse.converter.methods.MetaProcessorSettings;
import org.eclipse.chemclipse.converter.ui.Activator;
import org.eclipse.chemclipse.model.handler.IModificationHandler;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.methods.IProcessEntry;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;
import org.eclipse.chemclipse.ux.extension.xxd.ui.methods.SettingsUIProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.MethodUIConfig;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ExtendedMethodUI;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class MetaProcessorSettingsAdapterFactory
implements IAdapterFactory,
SettingsUIProvider<MetaProcessorSettings> {
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof MetaProcessorSettings && adapterType.isInstance(this)) {
            return adapterType.cast(this);
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{SettingsUIProvider.class};
    }

    public SettingsUIProvider.SettingsUIControl createUI(Composite parent, ProcessorPreferences<MetaProcessorSettings> preferences) throws IOException {
        return new SettingsUIControlImplementation(parent, preferences);
    }

    private final class SettingsUIControlImplementation
    implements SettingsUIProvider.SettingsUIControl,
    IModificationHandler {
        private final MetaProcessorSettings settings;
        private final ExtendedMethodUI methodUI;
        private ProcessorPreferences<MetaProcessorSettings> preferences;
        private List<Listener> listeners = new ArrayList<Listener>();

        public SettingsUIControlImplementation(Composite parent, ProcessorPreferences<MetaProcessorSettings> preferences) throws IOException {
            this.preferences = preferences;
            this.settings = (MetaProcessorSettings)preferences.getSettings();
            this.methodUI = new ExtendedMethodUI(parent, 8, Activator.getProcessSupplierContext(), new BiFunction<IProcessEntry, ProcessSupplierContext, ProcessorPreferences<?>>(){

                @Override
                public ProcessorPreferences<?> apply(IProcessEntry entry, ProcessSupplierContext context) {
                    return SettingsUIControlImplementation.this.settings.getProcessorPreferences(entry, entry.getPreferences(context));
                }
            }, this.settings.getMethod().getDataCategories().toArray(new DataCategory[0]));
            MethodUIConfig config = this.methodUI.getConfig();
            config.setToolbarVisible(false);
            config.setVisibleColumns(new HashSet<String>(Arrays.asList("", "Name", "Description", "Settings")));
            this.methodUI.setInputs(this.settings.getMethod(), null);
            this.methodUI.setModificationHandler((IModificationHandler)this);
        }

        public IStatus validate() {
            return ValidationStatus.ok();
        }

        public void setEnabled(boolean enabled) {
            this.methodUI.setEnabled(enabled);
        }

        public String getSettings() throws IOException {
            String string = this.preferences.getSerialization().toString((Object)this.settings);
            return string;
        }

        public void addChangeListener(Listener listener) {
            this.listeners.add(listener);
            this.setDirty(true);
        }

        public Control getControl() {
            return this.methodUI;
        }

        public void setDirty(boolean dirty) {
            Event event = new Event();
            event.widget = this.methodUI;
            event.display = this.methodUI.getDisplay();
            for (Listener listener : this.listeners) {
                listener.handleEvent(event);
            }
        }
    }
}

