/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.methods;

import java.util.function.BiFunction;
import org.eclipse.chemclipse.converter.methods.MetaProcessorSettings;
import org.eclipse.chemclipse.converter.methods.MethodProcessTypeSupplier;
import org.eclipse.chemclipse.processing.methods.IProcessEntry;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.processing.methods.ProcessEntryContainer;
import org.eclipse.chemclipse.processing.supplier.AbstractProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionConsumer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutor;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;

final class MetaProcessorProcessSupplier
extends AbstractProcessSupplier<MetaProcessorSettings>
implements ProcessExecutor {
    private final IProcessMethod method;

    MetaProcessorProcessSupplier(String id, IProcessMethod method, MethodProcessTypeSupplier parent) {
        super(id, method.getName(), method.getDescription(), method.isFinal() ? null : MetaProcessorSettings.class, (IProcessTypeSupplier)parent, MethodProcessTypeSupplier.getDataTypes(method));
        this.method = method;
    }

    public String getCategory() {
        return this.method.getCategory();
    }

    public IProcessMethod getMethod() {
        return this.method;
    }

    public <X> void execute(ProcessorPreferences<X> preferences, ProcessExecutionContext context) throws Exception {
        Object settings = preferences.getSettings();
        if (settings instanceof MetaProcessorSettings) {
            final MetaProcessorSettings processorSettings = (MetaProcessorSettings)settings;
            ProcessExecutionConsumer callerDelegate = (ProcessExecutionConsumer)context.getContextObject(ProcessExecutionConsumer.class);
            if (callerDelegate != null) {
                ProcessEntryContainer.applyProcessEntries((ProcessEntryContainer)this.method, (ProcessExecutionContext)context, (BiFunction)new BiFunction<IProcessEntry, IProcessSupplier<X>, ProcessorPreferences<X>>(){

                    @Override
                    public ProcessorPreferences<X> apply(IProcessEntry entry, IProcessSupplier<X> supplier) {
                        return processorSettings.getProcessorPreferences(entry, entry.getPreferences(supplier));
                    }
                }, (ProcessExecutionConsumer)callerDelegate);
            }
        }
    }
}

