/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.xy.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.csd.converter.io.AbstractChromatogramCSDWriter;
import org.eclipse.chemclipse.csd.converter.supplier.xy.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramWriter
extends AbstractChromatogramCSDWriter {
    public void writeChromatogram(File file, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        String delimiterFormat = PreferenceSupplier.getDelimiterFormat();
        String retentionTimeFormat = PreferenceSupplier.getRetentionTimeFormat();
        Throwable throwable = null;
        Object var7_8 = null;
        try (PrintWriter printWriter = new PrintWriter(file);){
            for (IScan scan : chromatogram.getScans()) {
                int retentionTime = scan.getRetentionTime();
                String x = retentionTimeFormat.equals("Minutes") ? Double.toString((double)retentionTime / 60000.0) : (retentionTimeFormat.equals("Seconds") ? Double.toString((double)retentionTime / 1000.0) : Integer.toString(retentionTime));
                printWriter.println(String.valueOf(x) + delimiterFormat + scan.getTotalSignal());
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

