/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.classifier.supplier.molpeak.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import javax.inject.Named;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.ui.handlers.IdentifySelectedPeakHandler;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.ui.runnables.MassSpectrumIdentifierRunnable;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class IdentifySelectedMassSpectrumHandler
implements EventHandler {
    private static final Logger logger = Logger.getLogger(IdentifySelectedPeakHandler.class);
    private static IChromatogramSelectionMSD chromatogramSelection;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        if (chromatogramSelection != null) {
            Display display = Display.getCurrent();
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Start the base peak mass spectrum identification.");
            MassSpectrumIdentifierRunnable runnable = new MassSpectrumIdentifierRunnable(chromatogramSelection);
            this.runOperation(display, runnable);
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Done: Mass spectrum identified");
        }
    }

    private void runOperation(Display display, IRunnableWithProgress runnable) {
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(display.getActiveShell());
        try {
            monitor.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
    }

    public void handleEvent(Event event) {
        chromatogramSelection = event.getTopic().equals("chromatogram/msd/update/chromatogramselection") ? (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection") : null;
    }
}

