/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.massbank.converter;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.chemclipse.converter.core.AbstractMagicNumberMatcher;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;

public class MagicNumberMatcher
extends AbstractMagicNumberMatcher
implements IMagicNumberMatcher {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkFileFormat(File file) {
        if (!file.getName().toLowerCase().endsWith(".zip")) return this.checkFileExtension(file, ".txt");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile zipFile = new ZipFile(file);){
                ZipEntry entry;
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                do {
                    if (!entries.hasMoreElements()) {
                        return this.checkFileExtension(file, ".txt");
                    }
                    entry = entries.nextElement();
                    if (!entry.getName().startsWith("MassBank-data-")) continue;
                    return true;
                } while (!entry.getName().endsWith("List_of_Contributors_Prefixes_and_Projects.md"));
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
    }
}

