/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.identifier.supplier.nist.internal.results;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.internal.results.Hit;

public class Compound {
    private List<Hit> hits = new ArrayList<Hit>();
    private String identifier = "";
    private String compoundInLibraryFactor = "";

    public String getIdentfier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        if (identifier != null) {
            this.identifier = identifier;
        }
    }

    public String getCompoundInLibraryFactor() {
        return this.compoundInLibraryFactor;
    }

    public void setCompoundInLibraryFactor(String compoundInLibraryFactor) {
        if (compoundInLibraryFactor != null) {
            this.compoundInLibraryFactor = compoundInLibraryFactor;
        }
    }

    public void add(Hit hit) {
        this.hits.add(hit);
    }

    public void remove(Hit hit) {
        this.hits.remove(hit);
    }

    public List<Hit> getHits() {
        return this.hits;
    }

    public Hit getHit(int index) {
        if (--index >= 0 && index < this.hits.size()) {
            return this.hits.get(index);
        }
        return null;
    }

    public int size() {
        return this.hits.size();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Compound otherCompound = (Compound)other;
        return this.size() == otherCompound.size() && this.hashCode() == otherCompound.hashCode();
    }

    public int hashCode() {
        int hashCode = 0;
        int size = this.hits.size();
        int i = 0;
        while (i < size) {
            hashCode = this.hits.get(i).hashCode() / size;
            ++i;
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("size=" + this.hits.size());
        builder.append(",");
        int i = 0;
        while (i < this.hits.size()) {
            builder.append("hit=" + this.hits.get(i));
            builder.append(",");
            ++i;
        }
        builder.append("]");
        return builder.toString();
    }
}

