/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.identifier.supplier.nist.runtime;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.runtime.IExtendedRuntimeSupport;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.runtime.INistSupport;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.runtime.NistSupport;
import org.eclipse.chemclipse.support.runtime.AbstractLinuxWineSupport;

public class LinuxWineSupport
extends AbstractLinuxWineSupport
implements IExtendedRuntimeSupport {
    private final INistSupport nistSupport = new NistSupport(this);

    public LinuxWineSupport(File applicationFolder, String parameter) throws FileNotFoundException {
        super(PreferenceSupplier.getNistExecutable(applicationFolder).getAbsolutePath(), parameter);
    }

    public int getSleepMillisecondsBeforeExecuteRunCommand() {
        return 4000;
    }

    public boolean isValidApplicationExecutable() {
        return this.nistSupport.validateExecutable();
    }

    @Override
    public INistSupport getNistSupport() {
        return this.nistSupport;
    }

    public Process executeKillCommand() throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(this.getKillCommand());
        return process;
    }

    public Process executeOpenCommand() throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(this.getOpenCommand());
        return process;
    }

    private String getKillCommand() {
        String command = "";
        if (this.isValidApplicationExecutable()) {
            StringBuilder builder = new StringBuilder();
            builder.append("pkill -f");
            builder.append(" ");
            builder.append("nist");
            command = builder.toString();
        }
        return command;
    }

    private String getOpenCommand() {
        StringBuilder builder = new StringBuilder();
        builder.append("env WINEPREFIX=");
        builder.append(this.getWineEnvironment());
        builder.append(" ");
        builder.append("wine start");
        builder.append(" ");
        builder.append(this.getWineApplication().replace("$.exe", ".exe"));
        return builder.toString();
    }
}

