/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.notifier.MassSpectrumSelectionUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassSpectrumIonsListUI;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class MassSpectrumEditListUI
extends Composite {
    private static final Logger logger = Logger.getLogger(MassSpectrumEditListUI.class);
    private static final String ACTION_INITIALIZE = "ACTION_INITIALIZE";
    private static final String ACTION_CANCEL = "ACTION_CANCEL";
    private static final String ACTION_ADD = "ACTION_ADD";
    private static final String ACTION_DELETE = "ACTION_DELETE";
    private static final String ACTION_SELECT = "ACTION_SELECT";
    private MassSpectrumIonsListUI massSpectrumIonsListUI;
    private Button buttonCancel;
    private Button buttonDelete;
    private Button buttonAdd;
    private Text textMz;
    private Text textIntensity;
    private Button buttonIonAdd;
    private IScanMSD massSpectrum;

    public MassSpectrumEditListUI(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void update(IScanMSD massSpectrum, boolean forceReload) {
        this.massSpectrum = massSpectrum;
        if (massSpectrum != null) {
            this.massSpectrumIonsListUI.setInput(massSpectrum);
        } else {
            this.massSpectrumIonsListUI.setInput(null);
        }
    }

    private void initialize() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(7, false));
        this.createButtonField(composite);
        this.createTableField(composite);
        this.enableButtonFields(ACTION_INITIALIZE);
    }

    private void createButtonField(Composite composite) {
        Label labelMz = new Label(composite, 0);
        labelMz.setText("m/z");
        this.textMz = new Text(composite, 2048);
        this.textMz.setText("");
        this.textMz.setLayoutData((Object)new GridData(768));
        Label labelIntensity = new Label(composite, 0);
        labelIntensity.setText("abundance");
        this.textIntensity = new Text(composite, 2048);
        this.textIntensity.setText("");
        this.textIntensity.setLayoutData((Object)new GridData(768));
        this.buttonIonAdd = new Button(composite, 8);
        this.buttonIonAdd.setText("Add");
        this.buttonIonAdd.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute.gif", "16x16"));
        this.buttonIonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                if (MassSpectrumEditListUI.this.massSpectrum == null) {
                    MessageBox messageBox = new MessageBox(shell, 40);
                    messageBox.setText("Add ion");
                    messageBox.setMessage("No mass spectrum has been selected.");
                    messageBox.open();
                } else {
                    try {
                        double mz = Double.parseDouble(MassSpectrumEditListUI.this.textMz.getText().trim());
                        float intensity = Float.parseFloat(MassSpectrumEditListUI.this.textIntensity.getText().trim());
                        Ion ion = new Ion(mz, intensity);
                        if (MassSpectrumEditListUI.this.massSpectrum.getIons().contains(ion)) {
                            MessageBox messageBox = new MessageBox(shell, 296);
                            messageBox.setText("Add ion");
                            messageBox.setMessage("The ion exists already.");
                            messageBox.open();
                        } else {
                            MassSpectrumEditListUI.this.massSpectrum.addIon((IIon)ion);
                            MassSpectrumEditListUI.this.textMz.setText("");
                            MassSpectrumEditListUI.this.textIntensity.setText("");
                            MassSpectrumSelectionUpdateNotifier.fireUpdateChange((IScanMSD)MassSpectrumEditListUI.this.massSpectrum, (boolean)true);
                            MassSpectrumEditListUI.this.enableButtonFields(MassSpectrumEditListUI.ACTION_INITIALIZE);
                        }
                    }
                    catch (Exception e1) {
                        logger.warn((Object)e1);
                        MessageBox messageBox = new MessageBox(shell, 40);
                        messageBox.setText("Add ion");
                        messageBox.setMessage("Please check the m/z and abundance values.");
                        messageBox.open();
                    }
                }
            }
        });
        Composite compositeButtons = new Composite(composite, 0);
        compositeButtons.setLayout((Layout)new GridLayout(3, true));
        GridData gridDataComposite = new GridData();
        gridDataComposite.horizontalAlignment = 131072;
        compositeButtons.setLayoutData((Object)gridDataComposite);
        this.buttonCancel = new Button(compositeButtons, 8);
        this.buttonCancel.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/cancel.gif", "16x16"));
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassSpectrumEditListUI.this.enableButtonFields(MassSpectrumEditListUI.ACTION_CANCEL);
            }
        });
        this.buttonDelete = new Button(compositeButtons, 8);
        this.buttonDelete.setEnabled(false);
        this.buttonDelete.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Table table;
                int index;
                if (MassSpectrumEditListUI.this.massSpectrum != null && (index = (table = MassSpectrumEditListUI.this.massSpectrumIonsListUI.getTable()).getSelectionIndex()) >= 0) {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 296);
                    messageBox.setText("Delete ion(s)?");
                    messageBox.setMessage("Would you like to delete the ion(s)?");
                    if (messageBox.open() == 32) {
                        TableItem[] tableItems;
                        MassSpectrumEditListUI.this.enableButtonFields(MassSpectrumEditListUI.ACTION_DELETE);
                        TableItem[] tableItemArray = tableItems = table.getSelection();
                        int n = tableItems.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem tableItem = tableItemArray[n2];
                            Object object = tableItem.getData();
                            if (object instanceof IIon) {
                                IIon ion = (IIon)object;
                                MassSpectrumEditListUI.this.massSpectrum.removeIon(ion);
                            }
                            ++n2;
                        }
                        MassSpectrumEditListUI.this.massSpectrumIonsListUI.update(MassSpectrumEditListUI.this.massSpectrum, true);
                    }
                }
            }
        });
        this.buttonAdd = new Button(compositeButtons, 8);
        this.buttonAdd.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassSpectrumEditListUI.this.enableButtonFields(MassSpectrumEditListUI.ACTION_ADD);
            }
        });
    }

    private void createTableField(Composite composite) {
        Composite compositeTable = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 7;
        compositeTable.setLayoutData((Object)gridData);
        compositeTable.setLayout((Layout)new FillLayout());
        this.massSpectrumIonsListUI = new MassSpectrumIonsListUI(compositeTable, 68354);
        this.massSpectrumIonsListUI.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassSpectrumEditListUI.this.enableButtonFields(MassSpectrumEditListUI.ACTION_SELECT);
            }
        });
    }

    private void enableButtonFields(String action) {
        this.enableFields(false);
        switch (action) {
            case "ACTION_INITIALIZE": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_CANCEL": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_ADD": {
                this.buttonCancel.setEnabled(true);
                this.textMz.setEnabled(true);
                this.textIntensity.setEnabled(true);
                this.buttonIonAdd.setEnabled(true);
                break;
            }
            case "ACTION_DELETE": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_SELECT": {
                this.buttonAdd.setEnabled(true);
                if (this.massSpectrumIonsListUI.getTable().getSelectionIndex() >= 0) {
                    this.buttonDelete.setEnabled(true);
                    break;
                }
                this.buttonDelete.setEnabled(false);
            }
        }
    }

    private void enableFields(boolean enabled) {
        this.buttonCancel.setEnabled(enabled);
        this.buttonDelete.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
        this.textMz.setEnabled(enabled);
        this.textIntensity.setEnabled(enabled);
        this.buttonIonAdd.setEnabled(enabled);
    }
}

