/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.ui.internal.provider;

import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.ui.Activator;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ProcessingInfoLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof IProcessingMessage) {
                Image image;
                IProcessingMessage message = (IProcessingMessage)element;
                switch (message.getMessageType()) {
                    case ERROR: {
                        image = this.getImage(element, "ICON_ERROR");
                        break;
                    }
                    case WARN: {
                        image = this.getImage(element, "ICON_WARN");
                        break;
                    }
                    case INFO: {
                        image = this.getImage(element, "INFO_VALID");
                        break;
                    }
                    default: {
                        image = this.getImage(element, "ICON_UNKNOWN");
                    }
                }
                return image;
            }
            return null;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof IProcessingMessage) {
            IProcessingMessage message = (IProcessingMessage)element;
            switch (columnIndex) {
                case 0: {
                    text = message.getMessageType().toString();
                    break;
                }
                case 1: {
                    text = message.getDescription();
                    break;
                }
                case 2: {
                    text = message.getMessage();
                    break;
                }
                case 3: {
                    text = message.getDate().toString();
                    break;
                }
                case 4: {
                    text = message.getProposedSolution();
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element, String key) {
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        if (imageRegistry != null) {
            return imageRegistry.get(key);
        }
        return null;
    }
}

