/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.methods;

import java.util.Iterator;
import java.util.function.BiFunction;
import org.eclipse.chemclipse.processing.methods.IProcessEntry;
import org.eclipse.chemclipse.processing.methods.SubProcessExecutionConsumer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionConsumer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;

public interface ProcessEntryContainer
extends Iterable<IProcessEntry> {
    public String getName();

    default public String getDescription() {
        return "";
    }

    public int getNumberOfEntries();

    default public boolean entriesEquals(ProcessEntryContainer other) {
        Iterator thisEntries = this.iterator();
        if (other == null) {
            return !thisEntries.hasNext();
        }
        Iterator otherEntries = other.iterator();
        while (thisEntries.hasNext() && otherEntries.hasNext()) {
            IProcessEntry otherEntry;
            IProcessEntry thisEntry = (IProcessEntry)thisEntries.next();
            if (thisEntry.contentEquals(otherEntry = (IProcessEntry)otherEntries.next())) continue;
            return false;
        }
        return !otherEntries.hasNext() && !thisEntries.hasNext();
    }

    public static <X, T> T applyProcessEntries(ProcessEntryContainer container, ProcessExecutionContext context, ProcessExecutionConsumer<T> consumer) {
        return ProcessEntryContainer.applyProcessEntries(container, context, new BiFunction<IProcessEntry, IProcessSupplier<X>, ProcessorPreferences<X>>(){

            @Override
            public ProcessorPreferences<X> apply(IProcessEntry processEntry, IProcessSupplier<X> processSupplier) {
                return processEntry.getPreferences(processSupplier);
            }
        }, consumer);
    }

    public static <X, T> T applyProcessEntries(ProcessEntryContainer container, ProcessExecutionContext context, final BiFunction<IProcessEntry, IProcessSupplier<X>, ProcessorPreferences<X>> preferenceSupplier, ProcessExecutionConsumer<T> consumer) {
        context.setWorkRemaining(container.getNumberOfEntries());
        for (final IProcessEntry processEntry : container) {
            IProcessSupplier processor = context.getSupplier(processEntry.getProcessorId());
            if (processor == null) {
                context.addWarnMessage(processEntry.getName(), "processor not found, will be skipped");
                continue;
            }
            try {
                ProcessorPreferences<X> processorPreferences = preferenceSupplier.apply(processEntry, processor);
                context.setContextObject(IProcessEntry.class, processEntry);
                context.setContextObject(IProcessSupplier.class, processor);
                context.setContextObject(ProcessExecutionConsumer.class, consumer);
                context.setContextObject(ProcessorPreferences.class, processorPreferences);
                ProcessExecutionContext entryContext = context.split(processor.getContext());
                try {
                    if (processEntry.getNumberOfEntries() > 0) {
                        IProcessSupplier.applyProcessor(processorPreferences, new SubProcessExecutionConsumer<T>(consumer, new SubProcessExecutionConsumer.SubProcess<T>(){

                            @Override
                            public <SubX> void execute(ProcessorPreferences<SubX> preferences, ProcessExecutionConsumer<T> parent, ProcessExecutionContext subcontext) {
                                ProcessEntryContainer.applyProcessEntries(processEntry, subcontext, preferenceSupplier, parent);
                            }
                        }), entryContext);
                        continue;
                    }
                    IProcessSupplier.applyProcessor(processorPreferences, consumer, entryContext);
                }
                finally {
                    context.setContextObject(IProcessSupplier.class, null);
                    context.setContextObject(IProcessEntry.class, null);
                    context.setContextObject(ProcessExecutionConsumer.class, null);
                    context.setContextObject(ProcessorPreferences.class, null);
                }
            }
            catch (RuntimeException e) {
                context.addErrorMessage(processEntry.getName(), "internal error", e);
            }
        }
        return consumer.getResult();
    }
}

