/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.supplier;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.chemclipse.support.settings.parser.SettingsClassParser;
import org.eclipse.chemclipse.support.settings.parser.SettingsParser;

public abstract class AbstractProcessSupplier<SettingsClass>
implements IProcessSupplier<SettingsClass> {
    private final String id;
    private final String name;
    private final String description;
    private final Class<SettingsClass> settingsClass;
    private final Set<DataCategory> dataTypes;
    private final IProcessTypeSupplier parent;
    private SettingsClassParser<SettingsClass> classParser;
    private String category;

    public AbstractProcessSupplier(String id, String name, String description, Class<SettingsClass> settingsClass, IProcessTypeSupplier parent, DataCategory ... dataTypes) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.settingsClass = settingsClass;
        this.parent = parent;
        this.dataTypes = dataTypes.length == 0 ? EnumSet.of(DataCategory.AUTO_DETECT) : Collections.unmodifiableSet(EnumSet.copyOf(Arrays.asList(dataTypes)));
    }

    @Override
    public String getCategory() {
        if (this.category != null) {
            return this.category;
        }
        return IProcessSupplier.super.getCategory();
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Class<SettingsClass> getSettingsClass() {
        return this.settingsClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProcessSupplier other = (AbstractProcessSupplier)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public Set<DataCategory> getSupportedDataTypes() {
        return this.dataTypes;
    }

    public String toString() {
        return "ProcessorSupplier [id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", settingsClass=" + this.settingsClass + "]";
    }

    @Override
    public IProcessTypeSupplier getTypeSupplier() {
        return this.parent;
    }

    @Override
    public SettingsParser<SettingsClass> getSettingsParser() {
        if (this.classParser == null) {
            this.classParser = new SettingsClassParser(this.getSettingsClass(), (Object)this);
        }
        return this.classParser;
    }
}

