/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.swt;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.ux.extension.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.ux.extension.ui.provider.DataExplorerContentProvider;
import org.eclipse.chemclipse.ux.extension.ui.provider.ISupplierFileEditorSupport;
import org.eclipse.chemclipse.ux.extension.ui.swt.DataExplorerTreeUI;
import org.eclipse.chemclipse.ux.extension.ui.swt.MultiDataExplorerTreeUI;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

public class DataExplorerUI
extends MultiDataExplorerTreeUI {
    private final IEventBroker eventBroker;

    public DataExplorerUI(Composite parent, IEventBroker eventBroker, IPreferenceStore preferenceStore) {
        super(parent, preferenceStore);
        this.eventBroker = eventBroker;
    }

    @Override
    protected void initTabComponent(Composite parent, DataExplorerTreeUI treeUI) {
        super.initTabComponent(parent, treeUI);
        this.createContextMenu(treeUI);
        this.addBatchOpenButton(parent, treeUI);
    }

    @Override
    protected void handleDoubleClick(File file, DataExplorerTreeUI treeUI) {
        this.openEditor(file, treeUI);
    }

    @Override
    protected void handleSelection(File[] files, DataExplorerTreeUI treeUI) {
        if (files.length > 0) {
            this.openOverview(files[0], treeUI);
        }
    }

    private void createContextMenu(final DataExplorerTreeUI treeUI) {
        final TreeViewer treeViewer = treeUI.getTreeViewer();
        final MenuManager contextMenu = new MenuManager("#ViewerMenu");
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                final Object[] selection = treeViewer.getStructuredSelection().toArray();
                final HashMap<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>> converterSupplier = new HashMap<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>>();
                TreeSet<ISupplier> supplierSet = new TreeSet<ISupplier>(new Comparator<ISupplier>(){

                    @Override
                    public int compare(ISupplier o1, ISupplier o2) {
                        return o1.getId().compareTo(o2.getId());
                    }
                });
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof File) {
                        File file = (File)object;
                        Map<ISupplierFileIdentifier, Collection<ISupplier>> map = DataExplorerUI.this.getIdentifierSupplier().apply(file);
                        converterSupplier.put(file, map);
                        for (Collection<ISupplier> s : map.values()) {
                            supplierSet.addAll(s);
                        }
                    }
                    ++n2;
                }
                for (final ISupplier activeFileSupplier : supplierSet) {
                    contextMenu.add((IAction)new Action("Open as: " + activeFileSupplier.getFilterName()){

                        public void run() {
                            Object[] objectArray = selection;
                            int n = selection.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object object = objectArray[n2];
                                if (object instanceof File) {
                                    File file = (File)object;
                                    Map map = (Map)converterSupplier.get(file);
                                    block1: for (Map.Entry entry : map.entrySet()) {
                                        ISupplierFileIdentifier identifier = (ISupplierFileIdentifier)entry.getKey();
                                        if (!(identifier instanceof ISupplierFileEditorSupport)) continue;
                                        for (ISupplier supplier : (Collection)entry.getValue()) {
                                            if (!activeFileSupplier.getId().equals(supplier.getId())) continue;
                                            DataExplorerUI.this.openEditorWithSupplier(file, (ISupplierFileEditorSupport)identifier, supplier);
                                            break block1;
                                        }
                                    }
                                }
                                ++n2;
                            }
                        }

                        public String getToolTipText() {
                            return activeFileSupplier.getDescription();
                        }
                    });
                }
                if (selection.length == 1 && selection[0] instanceof File && ((File)selection[0]).isDirectory()) {
                    contextMenu.add((IAction)new Action("Open all contained measurements in this folder"){

                        public void run() {
                            DataExplorerUI.this.openRecurse((File)selection[0], treeUI);
                        }
                    });
                }
            }
        });
        Menu menu = contextMenu.createContextMenu(treeViewer.getControl());
        treeViewer.getControl().setMenu(menu);
    }

    private boolean openRecurse(File file, DataExplorerTreeUI treeUI) {
        boolean opened = false;
        File[] listFiles = file.listFiles();
        if (listFiles != null) {
            File f;
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                f = fileArray[n2];
                opened |= this.openEditor(f, treeUI);
                ++n2;
            }
            if (!opened) {
                fileArray = listFiles;
                n = listFiles.length;
                n2 = 0;
                while (n2 < n) {
                    f = fileArray[n2];
                    if (f.isDirectory()) {
                        opened |= this.openRecurse(f, treeUI);
                    }
                    ++n2;
                }
            }
        }
        return opened;
    }

    private void addBatchOpenButton(Composite parent, final DataExplorerTreeUI treeUI) {
        Button button = new Button(parent, 8);
        button.setText("Open Selected Measurements");
        button.setToolTipText("Try to open all selected files. Handle with care.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/import.png", "16x16"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITreeSelection structuredSelection = treeUI.getTreeViewer().getStructuredSelection();
                for (final Object object : structuredSelection) {
                    if (!(object instanceof File)) continue;
                    e.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            File file = (File)object;
                            DataExplorerUI.this.openEditor(file, treeUI);
                        }
                    });
                }
            }
        });
    }

    private void openOverview(File file, DataExplorerTreeUI treeUI) {
        if (file != null) {
            DataExplorerContentProvider contentProvider = (DataExplorerContentProvider)treeUI.getTreeViewer().getContentProvider();
            if (file.isDirectory()) {
                contentProvider.refresh(file);
            }
            Set<ISupplierFileIdentifier> identifiers = this.getIdentifierSupplier().apply(file).keySet();
            for (ISupplierFileIdentifier identifier : identifiers) {
                if (!(identifier instanceof ISupplierFileEditorSupport)) continue;
                ISupplierFileEditorSupport fileEditorSupport = (ISupplierFileEditorSupport)identifier;
                fileEditorSupport.openOverview(file);
                return;
            }
            if (this.eventBroker != null) {
                this.eventBroker.post("chromatogram/xxd/update/none", null);
            }
        }
    }

    private boolean openEditor(File file, DataExplorerTreeUI treeUI) {
        boolean success = false;
        if (file != null) {
            boolean openFirstDataMatchOnly = PreferenceSupplier.isOpenFirstDataMatchOnly();
            Map<ISupplierFileIdentifier, Collection<ISupplier>> identifiers = this.getIdentifierSupplier().apply(file);
            for (Map.Entry<ISupplierFileIdentifier, Collection<ISupplier>> entry : identifiers.entrySet()) {
                ISupplierFileIdentifier identifier = entry.getKey();
                if (!(identifier instanceof ISupplierFileEditorSupport)) continue;
                for (ISupplier converter : entry.getValue()) {
                    if (!(success |= this.openEditorWithSupplier(file, (ISupplierFileEditorSupport)identifier, converter)) || !openFirstDataMatchOnly) continue;
                    return true;
                }
            }
        }
        return success;
    }

    private boolean openEditorWithSupplier(File file, ISupplierFileEditorSupport identifier, ISupplier converter) {
        this.saveLastDirectoryPath();
        return identifier.openEditor(file, converter);
    }
}

