/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.model.comparator.PeakRetentionTimeComparator;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.ChromatogramChart;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.charts.TargetReferenceLabelMarker;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.DisplayType;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.PreferenceStoreTargetDisplaySettings;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.SignalTargetReference;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.TargetDisplaySettings;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramChartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.PeakChartSupport;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;

public class ChromatogramPeakChart
extends ChromatogramChart {
    private static final String SERIES_ID_CHROMATOGRAM = "Chromatogram";
    private static final String SERIES_ID_BASELINE = "Baseline";
    private static final String SERIES_ID_PEAKS_NORMAL = "Peaks Normal";
    private static final String SERIES_ID_PEAKS_SELECTED_MARKER = "Peaks Selected Marker";
    private static final String SERIES_ID_PEAKS_SELECTED_SHAPE = "Peaks Selected Shape";
    private static final String SERIES_ID_PEAKS_SELECTED_BACKGROUND = "Peaks Selected Background";
    private final PeakRetentionTimeComparator peakRetentionTimeComparator = new PeakRetentionTimeComparator(SortOrder.ASC);
    private final PeakChartSupport peakChartSupport = new PeakChartSupport();
    private final ChromatogramChartSupport chromatogramChartSupport = new ChromatogramChartSupport();
    private final Map<String, ICustomPaintListener> peakLabelMarkerMap = new HashMap<String, ICustomPaintListener>();
    private final Set<String> selectedPeakIds = new HashSet<String>();
    private final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();

    public ChromatogramPeakChart() {
        this.init();
    }

    public ChromatogramPeakChart(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public void updateChromatogram(IChromatogramSelection chromatogramSelection) {
        this.clearSelectedPeakSeries();
        this.clearPeakLabelMarker();
        if (chromatogramSelection == null) {
            this.deleteSeries(SERIES_ID_CHROMATOGRAM);
            this.deleteSeries(SERIES_ID_BASELINE);
            this.deleteSeries(SERIES_ID_PEAKS_NORMAL);
        } else {
            List peaks = chromatogramSelection.getChromatogram().getPeaks((IRetentionTimeRange)chromatogramSelection);
            ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
            this.addChromatogramData(chromatogramSelection, lineSeriesDataList);
            this.addBaselineData(chromatogramSelection, lineSeriesDataList);
            this.addPeakData(peaks, lineSeriesDataList);
            this.addLineSeriesData(lineSeriesDataList);
        }
    }

    public void updatePeaks(List<IPeak> selectedPeaks) {
        this.clearSelectedPeakSeries();
        if (selectedPeaks != null && selectedPeaks.size() > 0) {
            int index = 1;
            ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
            for (IPeak peak : selectedPeaks) {
                this.addSelectedPeak(peak, lineSeriesDataList, index++);
            }
            this.addLineSeriesData(lineSeriesDataList);
        }
    }

    private void init() {
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setCreateMenu(true);
        chartSettings.getRangeRestriction().setRestrictZoom(true);
        this.applySettings(chartSettings);
    }

    private void addLineSeriesData(List<ILineSeriesData> lineSeriesDataList) {
        String compressionType = this.preferenceStore.getString("chromatogramChartCompressionType");
        int compressionToLength = this.chromatogramChartSupport.getCompressionLength(compressionType, lineSeriesDataList.size());
        this.addSeriesData(lineSeriesDataList, compressionToLength);
    }

    private void addChromatogramData(IChromatogramSelection chromatogramSelection, List<ILineSeriesData> lineSeriesDataList) {
        Color color = Colors.getColor((String)this.preferenceStore.getString("colorChromatogram"));
        boolean enableChromatogramArea = this.preferenceStore.getBoolean("enableChromatogramArea");
        ILineSeriesData lineSeriesData = this.chromatogramChartSupport.getLineSeriesData(chromatogramSelection, SERIES_ID_CHROMATOGRAM, DisplayType.TIC, color, false);
        lineSeriesData.getSettings().setEnableArea(enableChromatogramArea);
        lineSeriesDataList.add(lineSeriesData);
    }

    private void addBaselineData(IChromatogramSelection chromatogramSelection, List<ILineSeriesData> lineSeriesDataList) {
        boolean showChromatogramBaseline = this.preferenceStore.getBoolean("showChromatogramBaseline");
        if (chromatogramSelection != null && showChromatogramBaseline) {
            Color color = Colors.getColor((String)this.preferenceStore.getString("colorChromatogramBaseline"));
            boolean enableBaselineArea = this.preferenceStore.getBoolean("enableBaselineArea");
            ILineSeriesData lineSeriesData = null;
            lineSeriesData = this.chromatogramChartSupport.getLineSeriesDataBaseline(chromatogramSelection, SERIES_ID_BASELINE, DisplayType.TIC, color, false);
            lineSeriesData.getSettings().setEnableArea(enableBaselineArea);
            lineSeriesDataList.add(lineSeriesData);
        }
    }

    private void addPeakData(List<IPeak> peaks, List<ILineSeriesData> lineSeriesDataList) {
        int symbolSize = this.preferenceStore.getInt("chromatogramPeakLabelSymbolSize");
        this.addPeaks(lineSeriesDataList, peaks, ILineSeries.PlotSymbolType.INVERTED_TRIANGLE, symbolSize, Colors.DARK_GRAY, SERIES_ID_PEAKS_NORMAL, true);
    }

    private void addPeaks(List<ILineSeriesData> lineSeriesDataList, List<IPeak> peaks, ILineSeries.PlotSymbolType plotSymbolType, int symbolSize, Color symbolColor, String seriesId, boolean addLabelMarker) {
        if (peaks.size() > 0) {
            Collections.sort(peaks, this.peakRetentionTimeComparator);
            ILineSeriesData lineSeriesData = this.peakChartSupport.getPeaks(peaks, true, false, symbolColor, seriesId);
            ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
            lineSeriesSettings.setEnableArea(false);
            lineSeriesSettings.setLineStyle(LineStyle.NONE);
            lineSeriesSettings.setSymbolType(plotSymbolType);
            lineSeriesSettings.setSymbolSize(symbolSize);
            lineSeriesSettings.setSymbolColor(symbolColor);
            lineSeriesDataList.add(lineSeriesData);
            if (addLabelMarker) {
                this.removeIdentificationLabelMarker(this.peakLabelMarkerMap, seriesId);
                TargetDisplaySettings settings = PreferenceStoreTargetDisplaySettings.getSettings(this.preferenceStore);
                if (settings.isShowPeakLabels()) {
                    BaseChart baseChart = this.getBaseChart();
                    IPlotArea plotArea = baseChart.getPlotArea();
                    TargetReferenceLabelMarker peakLabelMarker = new TargetReferenceLabelMarker(baseChart, SignalTargetReference.getPeakReferences(peaks), settings, symbolSize * 2, this.preferenceStore);
                    plotArea.addCustomPaintListener((ICustomPaintListener)peakLabelMarker);
                    this.peakLabelMarkerMap.put(seriesId, (ICustomPaintListener)peakLabelMarker);
                }
            }
        }
    }

    private void addSelectedPeak(IPeak peak, List<ILineSeriesData> lineSeriesDataList, int index) {
        if (peak != null) {
            boolean mirrored = false;
            Color colorPeak = Colors.getColor((String)this.preferenceStore.getString("colorChromatogramSelectedPeak"));
            int symbolSize = this.preferenceStore.getInt("chromatogramPeakLabelSymbolSize");
            ILineSeries.PlotSymbolType symbolTypePeakMarker = ILineSeries.PlotSymbolType.valueOf((String)this.preferenceStore.getString("chromatogramSelectedPeakMarkerType"));
            int scanMarkerSize = this.preferenceStore.getInt("showChromatogramSelectedPeakScanMarkerSize");
            ILineSeries.PlotSymbolType symbolTypeScanMarker = ILineSeries.PlotSymbolType.valueOf((String)this.preferenceStore.getString("showChromatogramSelectedPeakScanMarkerType"));
            String peakMarkerId = this.getSelectedPeakSerieId(SERIES_ID_PEAKS_SELECTED_MARKER, index);
            ArrayList<IPeak> peaks = new ArrayList<IPeak>();
            peaks.add(peak);
            this.addPeaks(lineSeriesDataList, peaks, symbolTypePeakMarker, symbolSize, colorPeak, peakMarkerId, false);
            this.selectedPeakIds.add(peakMarkerId);
            String peakShapeId = this.getSelectedPeakSerieId(SERIES_ID_PEAKS_SELECTED_SHAPE, index);
            ILineSeriesData lineSeriesData = this.peakChartSupport.getPeak(peak, true, mirrored, colorPeak, peakShapeId);
            ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
            lineSeriesSettings.setSymbolType(symbolTypeScanMarker);
            lineSeriesSettings.setSymbolColor(colorPeak);
            lineSeriesSettings.setSymbolSize(scanMarkerSize);
            lineSeriesDataList.add(lineSeriesData);
            this.selectedPeakIds.add(peakShapeId);
            String peakBackgroundId = this.getSelectedPeakSerieId(SERIES_ID_PEAKS_SELECTED_BACKGROUND, index);
            Color colorBackground = Colors.getColor((String)this.preferenceStore.getString("colorPeakBackground"));
            lineSeriesData = this.peakChartSupport.getPeakBackground(peak, mirrored, colorBackground, peakBackgroundId);
            lineSeriesDataList.add(lineSeriesData);
            this.selectedPeakIds.add(peakBackgroundId);
        }
    }

    private void removeIdentificationLabelMarker(Map<String, ? extends ICustomPaintListener> markerMap, String seriesId) {
        IPlotArea plotArea = this.getBaseChart().getPlotArea();
        ICustomPaintListener labelMarker = markerMap.get(seriesId);
        if (labelMarker != null) {
            plotArea.removeCustomPaintListener(labelMarker);
        }
    }

    private String getSelectedPeakSerieId(String id, int index) {
        return String.valueOf(id) + " (" + index + ")";
    }

    private void clearSelectedPeakSeries() {
        for (String id : this.selectedPeakIds) {
            this.deleteSeries(id);
        }
        this.selectedPeakIds.clear();
    }

    private void clearPeakLabelMarker() {
        Set<String> seriesIds = this.peakLabelMarkerMap.keySet();
        for (String seriesId : seriesIds) {
            this.removeIdentificationLabelMarker(this.peakLabelMarkerMap, seriesId);
        }
        this.peakLabelMarkerMap.clear();
    }
}

