/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.fieldeditors;

import java.io.File;
import java.util.HashSet;
import org.eclipse.chemclipse.swt.ui.components.ISearchListener;
import org.eclipse.chemclipse.swt.ui.components.SearchSupportUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.NamedTraceInputValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.NamedTracesListUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.traces.NamedTrace;
import org.eclipse.chemclipse.ux.extension.xxd.ui.traces.NamedTraces;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NamedTracesFieldEditor
extends FieldEditor {
    private static final int NUMBER_COLUMNS = 2;
    private static final String FILTER_EXTENSION = "*.txt";
    private static final String FILTER_NAME = "Named Traces (*.txt)";
    private static final String FILE_NAME = "NamedTraces.txt";
    private Composite composite;
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private NamedTraces namedTraces = new NamedTraces();
    private NamedTracesListUI namedTracesListUI;

    public NamedTracesFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        this.composite.setLayoutData((Object)gridData);
        this.createLabelSection(this.composite);
        this.createSearchSection(this.composite);
        this.createTableSection(this.composite);
        this.createButtonGroup(this.composite);
    }

    private void createSearchSection(Composite parent) {
        SearchSupportUI searchSupportUI = new SearchSupportUI(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        searchSupportUI.setLayoutData((Object)gridData);
        searchSupportUI.setSearchListener(new ISearchListener(){

            public void performSearch(String searchText, boolean caseSensitive) {
                NamedTracesFieldEditor.this.namedTracesListUI.setSearchText(searchText, caseSensitive);
            }
        });
    }

    private void createLabelSection(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText("");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    private void createTableSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)gridData);
        this.namedTracesListUI = new NamedTracesListUI(composite, 68354);
        this.setTableViewerInput();
    }

    private void createButtonGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        this.setButtonLayoutData(this.createButtonAdd(composite));
        this.setButtonLayoutData(this.createButtonEdit(composite));
        this.setButtonLayoutData(this.createButtonRemove(composite));
        this.setButtonLayoutData(this.createButtonRemoveAll(composite));
        this.setButtonLayoutData(this.createButtonImport(composite));
        this.setButtonLayoutData(this.createButtonExport(composite));
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Add");
        button.setToolTipText("Add a named trace.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(e.display.getActiveShell(), "Named Trace", "Create a new named trace.", "Hydrocarbons | 57 71 85", (IInputValidator)new NamedTraceInputValidator(NamedTracesFieldEditor.this.namedTraces.keySet()));
                if (dialog.open() == 0) {
                    String item = dialog.getValue();
                    NamedTrace namedTrace = NamedTracesFieldEditor.this.namedTraces.extractNamedTrace(item);
                    if (namedTrace != null) {
                        NamedTracesFieldEditor.this.namedTraces.add(namedTrace);
                        NamedTracesFieldEditor.this.setTableViewerInput();
                    }
                }
            }
        });
        return button;
    }

    private Button createButtonEdit(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Edit");
        button.setToolTipText("Edit the selected named trace.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection = (IStructuredSelection)NamedTracesFieldEditor.this.namedTracesListUI.getSelection();
                Object object = structuredSelection.getFirstElement();
                if (object instanceof NamedTrace) {
                    HashSet<String> keySetEdit = new HashSet<String>();
                    keySetEdit.addAll(NamedTracesFieldEditor.this.namedTraces.keySet());
                    NamedTrace namedTrace = (NamedTrace)object;
                    keySetEdit.remove(namedTrace.getIdentifier());
                    InputDialog dialog = new InputDialog(e.display.getActiveShell(), "Named Trace", "Edit the selected named trace.", NamedTracesFieldEditor.this.namedTraces.extractNamedTrace(namedTrace), (IInputValidator)new NamedTraceInputValidator(keySetEdit));
                    if (dialog.open() == 0) {
                        String item = dialog.getValue();
                        NamedTrace namedTraceNew = NamedTracesFieldEditor.this.namedTraces.extractNamedTrace(item);
                        if (namedTraceNew != null) {
                            NamedTracesFieldEditor.this.namedTraces.remove(namedTrace);
                            NamedTracesFieldEditor.this.namedTraces.add(namedTraceNew);
                            NamedTracesFieldEditor.this.setTableViewerInput();
                        }
                    }
                }
            }
        });
        return button;
    }

    private Button createButtonRemove(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Remove");
        button.setToolTipText("Remove the selected named trace(s).");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)"Named Trace(s)", (String)"Do you want to delete the selected named trace(s)?")) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)NamedTracesFieldEditor.this.namedTracesListUI.getSelection();
                    Object[] objectArray = structuredSelection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (object instanceof NamedTrace) {
                            NamedTracesFieldEditor.this.namedTraces.remove(((NamedTrace)object).getIdentifier());
                        }
                        ++n2;
                    }
                    NamedTracesFieldEditor.this.setTableViewerInput();
                }
            }
        });
        return button;
    }

    private Button createButtonRemoveAll(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Remove All");
        button.setToolTipText("Remove all named trace(s).");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)"Named Trace(s)", (String)"Do you want to delete all named trace(s)?")) {
                    NamedTracesFieldEditor.this.namedTraces.clear();
                    NamedTracesFieldEditor.this.setTableViewerInput();
                }
            }
        });
        return button;
    }

    private Button createButtonImport(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Import");
        button.setToolTipText("Import a named trace list.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.widget.getDisplay().getActiveShell(), 8);
                fileDialog.setText("Named Trace List");
                fileDialog.setFilterExtensions(new String[]{NamedTracesFieldEditor.FILTER_EXTENSION});
                fileDialog.setFilterNames(new String[]{NamedTracesFieldEditor.FILTER_NAME});
                fileDialog.setFilterPath(NamedTracesFieldEditor.this.preferenceStore.getString("namedTracesTemplateFolder"));
                String pathname = fileDialog.open();
                if (pathname != null) {
                    File file = new File(pathname);
                    String path = file.getParentFile().getAbsolutePath();
                    NamedTracesFieldEditor.this.preferenceStore.putValue("namedTracesTemplateFolder", path);
                    NamedTracesFieldEditor.this.namedTraces.importItems(file);
                    NamedTracesFieldEditor.this.setTableViewerInput();
                }
            }
        });
        return button;
    }

    private Button createButtonExport(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setText("Export");
        button.setToolTipText("Export the named trace list.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.widget.getDisplay().getActiveShell(), 8192);
                fileDialog.setOverwrite(true);
                fileDialog.setText("Named Trace List");
                fileDialog.setFilterExtensions(new String[]{NamedTracesFieldEditor.FILTER_EXTENSION});
                fileDialog.setFilterNames(new String[]{NamedTracesFieldEditor.FILTER_NAME});
                fileDialog.setFileName(NamedTracesFieldEditor.FILE_NAME);
                fileDialog.setFilterPath(NamedTracesFieldEditor.this.preferenceStore.getString("namedTracesTemplateFolder"));
                String pathname = fileDialog.open();
                if (pathname != null) {
                    File file = new File(pathname);
                    String path = file.getParentFile().getAbsolutePath();
                    NamedTracesFieldEditor.this.preferenceStore.putValue("namedTracesTemplateFolder", path);
                    if (NamedTracesFieldEditor.this.namedTraces.exportItems(file)) {
                        MessageDialog.openInformation((Shell)button.getShell(), (String)"Named Trace List", (String)"The named trace list has been exported successfully.");
                    } else {
                        MessageDialog.openWarning((Shell)button.getShell(), (String)"Named Trace List", (String)"Something went wrong to export the named trace list.");
                    }
                }
            }
        });
        return button;
    }

    private void setTableViewerInput() {
        this.namedTracesListUI.setInput(this.namedTraces.values());
    }

    protected void doLoad() {
        String entries = this.getPreferenceStore().getString(this.getPreferenceName());
        this.namedTraces.load(entries);
        this.setTableViewerInput();
    }

    protected void doLoadDefault() {
        String entries = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.namedTraces.loadDefault(entries);
        this.setTableViewerInput();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.namedTraces.save());
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected void adjustForNumColumns(int numColumns) {
        if (numColumns >= 2) {
            GridData gridData = (GridData)this.composite.getLayoutData();
            gridData.horizontalSpan = numColumns - 1;
            gridData.grabExcessHorizontalSpace = true;
        }
    }
}

