/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.quantitation.IQuantitationPeak;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.PeakDataSupport;
import org.eclipse.swt.graphics.Image;

public class QuantPeaksLabelProvider
extends AbstractChemClipseLabelProvider {
    public static final String CONCENTRATION = "Concentration";
    public static final String CONCENTRATION_UNIT = "Unit";
    private PeakDataSupport peakDataSupport = new PeakDataSupport();
    public static final String[] TITLES = new String[]{"Concentration", "Unit", "Type"};
    public static final int[] BOUNDS = new int[]{100, 100, 100};

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IQuantitationPeak) {
            IQuantitationPeak entry = (IQuantitationPeak)element;
            switch (columnIndex) {
                case 0: {
                    text = decimalFormat.format(entry.getConcentration());
                    break;
                }
                case 1: {
                    text = entry.getConcentrationUnit();
                    break;
                }
                case 2: {
                    text = this.peakDataSupport.getType(entry.getReferencePeak());
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/quantifySelectedPeak.gif", "16x16");
    }
}

