/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.xir.converter.core.ScanConverterXIR;
import org.eclipse.chemclipse.xir.model.core.IScanXIR;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ScanXIRImportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(ScanXIRImportRunnable.class);
    private File file;
    private IScanXIR scanXIR = null;

    public ScanXIRImportRunnable(File file) {
        this.file = file;
    }

    public IScanXIR getScanXIR() {
        return this.scanXIR;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask("Import Scan", -1);
                IProcessingInfo processingInfo = ScanConverterXIR.convert((File)this.file, (IProgressMonitor)monitor);
                this.scanXIR = (IScanXIR)processingInfo.getProcessingResult();
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

