/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.Arrays;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.util.QuantReferencesListUtil;
import org.eclipse.chemclipse.support.validators.QuantReferenceValidator;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageQuantitation;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.PeakDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.QuantReferencesListUI;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ExtendedPeakQuantReferencesUI {
    private Composite toolbarInfo;
    private Label labelInfo;
    private Composite toolbarModify;
    private Label labelInputErrors;
    private Combo comboQuantReferences;
    private Button buttonAddReference;
    private Button buttonDeleteReference;
    private QuantReferencesListUI quantReferencesListUI;
    private QuantReferencesListUtil quantReferencesUtil = new QuantReferencesListUtil();
    private QuantReferenceValidator validator;
    private ControlDecoration controlDecoration;
    private IPeak peak;
    private PeakDataSupport peakDataSupport = new PeakDataSupport();

    @Inject
    public ExtendedPeakQuantReferencesUI(Composite parent) {
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        this.updatePeak();
    }

    public void update(IPeak peak) {
        this.peak = peak;
        this.updatePeak();
    }

    private void updatePeak() {
        this.updateReferences();
        this.updateLabel();
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfo = this.createToolbarInfo(parent);
        this.toolbarModify = this.createToolbarModify(parent);
        this.quantReferencesListUI = this.createTable(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarModify, (boolean)false);
        this.quantReferencesListUI.setEditEnabled(false);
        this.clearLabelInputErrors();
        this.applySettings();
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.createButtonToggleToolbarInfo(composite);
        this.createButtonToggleToolbarModify(composite);
        this.createButtonToggleEditModus(composite);
        this.createSettingsButton(composite);
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfo = new Label(composite, 0);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Composite createToolbarModify(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        int columns = 3;
        composite.setLayout((Layout)new GridLayout(columns, false));
        this.labelInputErrors = this.createLabel(composite, columns);
        this.comboQuantReferences = this.createComboQuantReferences(composite);
        this.buttonAddReference = this.createButtonAdd(composite);
        this.buttonDeleteReference = this.createButtonDelete(composite);
        return composite;
    }

    private Label createLabel(Composite parent, int horizontalSpan) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Combo createComboQuantReferences(Composite parent) {
        final Combo combo = new Combo(parent, 0);
        combo.setText("");
        combo.setToolTipText("Select a quantitation reference or type in a new reference name.");
        combo.setLayoutData((Object)new GridData(768));
        this.validator = new QuantReferenceValidator();
        this.controlDecoration = new ControlDecoration((Control)combo, 16512);
        combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ExtendedPeakQuantReferencesUI.this.validate((IValidator)ExtendedPeakQuantReferencesUI.this.validator, ExtendedPeakQuantReferencesUI.this.controlDecoration, combo);
                if (e.keyCode == 10 || e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ExtendedPeakQuantReferencesUI.this.addReference(e.display.getActiveShell());
                }
            }
        });
        return combo;
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Add the quantitation reference.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedPeakQuantReferencesUI.this.addReference(e.display.getActiveShell());
            }
        });
        return button;
    }

    private Button createButtonDelete(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Delete the selected quantitation reference(s).");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedPeakQuantReferencesUI.this.deleteReferences(e.display.getActiveShell());
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedPeakQuantReferencesUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarModify(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle modify toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedPeakQuantReferencesUI.this.toolbarModify);
                if (visible) {
                    ExtendedPeakQuantReferencesUI.this.setComboQuantReferenceItems();
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editActive.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleEditModus(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Enable/disable to edit the table.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean editEnabled = !ExtendedPeakQuantReferencesUI.this.quantReferencesListUI.isEditEnabled();
                ExtendedPeakQuantReferencesUI.this.quantReferencesListUI.setEditEnabled(editEnabled);
                button.setImage(ApplicationImageFactory.getInstance().getImage(editEnabled ? "org.eclipse.chemclipse.rcp.ui.icons/editEntryActive.gif" : "org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
                ExtendedPeakQuantReferencesUI.this.updateLabel();
            }
        });
        return button;
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageQuantitation preferencePage = new PreferencePageQuantitation();
                preferencePage.setTitle("Quantitiation");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePage));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedPeakQuantReferencesUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
    }

    private QuantReferencesListUI createTable(Composite parent) {
        QuantReferencesListUI listUI = new QuantReferencesListUI(parent, 68354);
        Table table = listUI.getTable();
        table.setLayoutData((Object)new GridData(1808));
        return listUI;
    }

    private void applySettings() {
        this.setComboQuantReferenceItems();
    }

    private void addReference(Shell shell) {
        boolean isInputValid = this.validate((IValidator)this.validator, this.controlDecoration, this.comboQuantReferences);
        if (isInputValid) {
            this.setReference(this.validator);
        } else {
            MessageDialog.openError((Shell)shell, (String)"Add Quantitation Reference", (String)"The given quantitation reference is invalid.");
        }
    }

    private void deleteReference(String quantitationReference) {
        if (this.peak != null) {
            this.peak.removeQuantitationReference(quantitationReference);
            this.updateReferences();
        }
    }

    private void deleteReferences(Shell shell) {
        MessageBox messageBox = new MessageBox(shell, 196);
        messageBox.setText("Delete Quantitation Reference(s)");
        messageBox.setMessage("Would you like to delete the selected quantitation(s)?");
        if (messageBox.open() == 64) {
            for (Object object : this.quantReferencesListUI.getStructuredSelection()) {
                if (!(object instanceof String)) continue;
                this.deleteReference((String)object);
            }
            this.updateReferences();
        }
    }

    private void setReference(QuantReferenceValidator validator) {
        if (this.peak != null) {
            this.peak.addQuantitationReference(validator.getName());
        }
        this.comboQuantReferences.setText("");
        this.updateReferences();
    }

    private void updateReferences() {
        this.updateLabel();
        this.updateWidgets();
        if (this.peak != null) {
            this.quantReferencesListUI.setInput(this.peak.getQuantitationReferences());
        } else {
            this.quantReferencesListUI.clear();
        }
    }

    private void setComboQuantReferenceItems() {
        Object[] items;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        boolean useTargetList = preferenceStore.getBoolean("useQuantitationReferenceList");
        if (useTargetList) {
            items = this.quantReferencesUtil.parseString(preferenceStore.getString("quantitationReferenceList"));
            Arrays.sort(items);
        } else {
            items = new String[]{};
        }
        this.comboQuantReferences.setItems((String[])items);
    }

    private void updateLabel() {
        this.labelInfo.setText(this.peakDataSupport.getPeakLabel(this.peak));
        String editInformation = this.quantReferencesListUI.isEditEnabled() ? "Edit is enabled." : "Edit is disabled.";
        this.labelInfo.setText(String.valueOf(this.labelInfo.getText()) + " - " + editInformation);
    }

    private void updateWidgets() {
        boolean enabled = this.peak != null;
        this.comboQuantReferences.setEnabled(enabled);
        this.buttonAddReference.setEnabled(enabled);
        this.buttonDeleteReference.setEnabled(enabled);
    }

    private boolean validate(IValidator validator, ControlDecoration controlDecoration, Combo combo) {
        IStatus status = validator.validate((Object)combo.getText());
        if (status.isOK()) {
            controlDecoration.hide();
            this.clearLabelInputErrors();
            return true;
        }
        this.setLabelInputError(status.getMessage());
        controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        controlDecoration.showHoverText("Input Error");
        controlDecoration.show();
        return false;
    }

    private void clearLabelInputErrors() {
        this.labelInputErrors.setText("Example: Styrene");
        this.labelInputErrors.setBackground(null);
    }

    private void setLabelInputError(String message) {
        this.labelInputErrors.setText(message);
        this.labelInputErrors.setBackground(Colors.YELLOW);
    }
}

