/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.model.quantitation.IQuantitationSignal;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.events.IKeyEventProcessor;
import org.eclipse.chemclipse.support.ui.menu.ITableMenuEntry;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.support.ui.swt.ITableSettings;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.QuantitationSignalValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePagePeaksAxes;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.QuantSignalsListUI;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExtendedQuantSignalsListUI
extends Composite {
    private static final String MENU_CATEGORY = "Signals";
    private IQuantitationCompound quantitationCompound;
    private Composite toolbarInfo;
    private Label labelInfo;
    private Composite toolbarModify;
    private Label labelInputErrors;
    private Text textSignal;
    private Button buttonAdd;
    private Button buttonDelete;
    private QuantSignalsListUI quantSignalsListUI;
    private QuantitationSignalValidator validator = new QuantitationSignalValidator();
    private ControlDecoration controlDecoration;

    public ExtendedQuantSignalsListUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void update(IQuantitationCompound quantitationCompound) {
        this.quantitationCompound = quantitationCompound;
        this.updateInput();
        this.updateWidgets();
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(composite);
        this.toolbarInfo = this.createToolbarInfo(composite);
        this.toolbarModify = this.createToolbarModify(composite);
        this.quantSignalsListUI = this.createTable(composite);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarModify, (boolean)false);
        this.quantSignalsListUI.setEditEnabled(false);
        this.clearLabelInputErrors();
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createButtonToggleToolbarModify(composite);
        this.createButtonToggleEditModus(composite);
        this.createSettingsButton(composite);
    }

    private Button createButtonToggleToolbarModify(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle modify toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedQuantSignalsListUI.this.toolbarModify);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editActive.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleEditModus(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Enable/disable to edit the table.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean editEnabled = !ExtendedQuantSignalsListUI.this.quantSignalsListUI.isEditEnabled();
                ExtendedQuantSignalsListUI.this.quantSignalsListUI.setEditEnabled(editEnabled);
                button.setImage(ApplicationImageFactory.getInstance().getImage(editEnabled ? "org.eclipse.chemclipse.rcp.ui.icons/editEntryActive.gif" : "org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
                ExtendedQuantSignalsListUI.this.updateInput();
            }
        });
        return button;
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePagePeaksAxes()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedQuantSignalsListUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfo = new Label(composite, 0);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Composite createToolbarModify(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        int columns = 3;
        composite.setLayout((Layout)new GridLayout(columns, false));
        this.labelInputErrors = this.createLabel(composite, columns);
        this.textSignal = this.createTextSignal(composite);
        this.buttonAdd = this.createButtonAdd(composite);
        this.buttonDelete = this.createButtonDelete(composite);
        return composite;
    }

    private Label createLabel(Composite parent, int horizontalSpan) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Text createTextSignal(Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("Type in a new signal.");
        text.setLayoutData((Object)new GridData(768));
        this.controlDecoration = new ControlDecoration((Control)text, 16512);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ExtendedQuantSignalsListUI.this.validate(ExtendedQuantSignalsListUI.this.validator, ExtendedQuantSignalsListUI.this.controlDecoration, text);
                if (e.keyCode == 10 || e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ExtendedQuantSignalsListUI.this.addSignal(e.display.getActiveShell());
                }
            }
        });
        return text;
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Add a new signal.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedQuantSignalsListUI.this.addSignal(e.display.getActiveShell());
            }
        });
        return button;
    }

    private Button createButtonDelete(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Delete the selected signal(s).");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedQuantSignalsListUI.this.deleteSignals(e.display.getActiveShell());
            }
        });
        return button;
    }

    private QuantSignalsListUI createTable(Composite parent) {
        QuantSignalsListUI listUI = new QuantSignalsListUI(parent, 68354);
        listUI.getTable().setLayoutData((Object)new GridData(1808));
        Shell shell = listUI.getTable().getShell();
        ITableSettings tableSettings = listUI.getTableSettings();
        this.addDeleteMenuEntry(shell, tableSettings);
        this.addKeyEventProcessors(shell, tableSettings);
        listUI.applySettings(tableSettings);
        return listUI;
    }

    private void addDeleteMenuEntry(final Shell shell, ITableSettings tableSettings) {
        tableSettings.addMenuEntry(new ITableMenuEntry(){

            public String getName() {
                return "Delete Signal(s)";
            }

            public String getCategory() {
                return ExtendedQuantSignalsListUI.MENU_CATEGORY;
            }

            public void execute(ExtendedTableViewer extendedTableViewer) {
                ExtendedQuantSignalsListUI.this.deleteSignals(shell);
            }
        });
    }

    private void addKeyEventProcessors(final Shell shell, ITableSettings tableSettings) {
        tableSettings.addKeyEventProcessor(new IKeyEventProcessor(){

            public void handleEvent(ExtendedTableViewer extendedTableViewer, KeyEvent e) {
                if (e.keyCode == 127) {
                    ExtendedQuantSignalsListUI.this.deleteSignals(shell);
                }
            }
        });
    }

    private void deleteSignals(Shell shell) {
        MessageBox messageBox = new MessageBox(shell, 196);
        messageBox.setText("Delete Signal(s)");
        messageBox.setMessage("Would you like to delete the selected signal(s)?");
        if (messageBox.open() == 64) {
            for (Object object : this.quantSignalsListUI.getStructuredSelection()) {
                if (!(object instanceof IQuantitationSignal)) continue;
                this.quantitationCompound.getQuantitationSignals().remove((Object)((IQuantitationSignal)object));
            }
            this.updateInput();
        }
    }

    private void addSignal(Shell shell) {
        boolean isInputValid = this.validate(this.validator, this.controlDecoration, this.textSignal);
        if (isInputValid) {
            this.setSignal(this.validator);
        } else {
            MessageDialog.openError((Shell)shell, (String)"Add Signal", (String)"The given signal is invalid.");
        }
    }

    private void setSignal(QuantitationSignalValidator validator) {
        IQuantitationSignal quantitationSignal;
        if (this.quantitationCompound != null && (quantitationSignal = validator.getQuantitationSignal()) != null) {
            this.quantitationCompound.getQuantitationSignals().add((Object)quantitationSignal);
            this.textSignal.setText("");
            this.updateInput();
        }
    }

    private void applySettings() {
        this.updateInput();
    }

    private void updateInput() {
        if (this.quantitationCompound != null) {
            String editInformation = this.quantSignalsListUI.isEditEnabled() ? "(Edit is enabled)" : "(Edit is disabled)";
            this.labelInfo.setText("Quantitation Compound: " + this.quantitationCompound.getName() + " " + editInformation);
            this.quantSignalsListUI.setInput(this.quantitationCompound.getQuantitationSignals());
        } else {
            this.labelInfo.setText("");
            this.quantSignalsListUI.clear();
        }
    }

    private boolean validate(IValidator validator, ControlDecoration controlDecoration, Text text) {
        IStatus status = validator.validate((Object)text.getText());
        if (status.isOK()) {
            controlDecoration.hide();
            this.clearLabelInputErrors();
            return true;
        }
        this.setLabelInputError(status.getMessage());
        controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        controlDecoration.showHoverText("Input Error");
        controlDecoration.show();
        return false;
    }

    private void clearLabelInputErrors() {
        this.labelInputErrors.setText("Example: TIC | 100.0 | 0.0 | true");
        this.labelInputErrors.setBackground(null);
    }

    private void setLabelInputError(String message) {
        this.labelInputErrors.setText(message);
        this.labelInputErrors.setBackground(Colors.YELLOW);
    }

    private void updateWidgets() {
        boolean enabled = this.quantitationCompound != null;
        this.textSignal.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
        this.buttonDelete.setEnabled(enabled);
    }
}

