/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.wizards;

import java.util.ArrayList;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.DataCategoryGroup;
import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.chemclipse.support.ui.wizards.SinglePageWizard;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DataTypeTypeSelectionWizard {
    private static final String PREFIX = "DataTypeTypeSelectionWizard.";
    private static final DataCategoryGroup[] GROUPS = DataCategoryGroup.defaultGroups();

    public static DataCategoryGroup open(Shell shell, String description, IPreferenceStore preferenceStore) {
        preferenceStore.setDefault(DataTypeTypeSelectionWizard.groupPreferenceKey(GROUPS[0]), true);
        DataCategoryGroup[] dataCategoryGroupArray = GROUPS;
        int n = GROUPS.length;
        int n2 = 0;
        while (n2 < n) {
            DataCategoryGroup group = dataCategoryGroupArray[n2];
            for (DataCategory category : group.getDataCategories()) {
                preferenceStore.setDefault(DataTypeTypeSelectionWizard.categoryPreferenceKey(group, category), true);
            }
            ++n2;
        }
        SelectionPage page = new SelectionPage(preferenceStore);
        page.setDescription(description);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)new SinglePageWizard("Select Data Categories", (WizardPage)page));
        wizardDialog.setPageSize(200, 150);
        wizardDialog.create();
        if (wizardDialog.open() == 0) {
            return page.group;
        }
        return null;
    }

    private static String categoryPreferenceKey(DataCategoryGroup group, DataCategory category) {
        return PREFIX + group.getName() + "." + category.name();
    }

    private static String groupPreferenceKey(DataCategoryGroup group) {
        return PREFIX + group.getName();
    }

    private static final class SelectionPage
    extends WizardPage {
        private DataCategoryGroup group;
        private final IPreferenceStore preferenceStore;

        protected SelectionPage(IPreferenceStore preferenceStore) {
            super(SelectionPage.class.getName());
            this.preferenceStore = preferenceStore;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            DataCategoryGroup[] dataCategoryGroupArray = GROUPS;
            int n = dataCategoryGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataCategoryGroup group = dataCategoryGroupArray[n2];
                final String preferenceKey = DataTypeTypeSelectionWizard.groupPreferenceKey(group);
                final Button radiobutton = ControlBuilder.radiobutton((Composite)composite, (String)group.getName(), (boolean)this.preferenceStore.getBoolean(preferenceKey));
                radiobutton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        preferenceStore.setValue(preferenceKey, radiobutton.getSelection());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Button[] checkBoxes = this.createButtons(composite, group);
                this.setupListener(radiobutton, checkBoxes, group.getName());
                ++n2;
            }
            this.setControl((Control)composite);
        }

        private void setupListener(final Button button, final Button[] checkBoxes, final String groupName) {
            SelectionListener listener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selection = button.getSelection();
                    if (selection) {
                        ArrayList<DataCategory> selectedCategories = new ArrayList<DataCategory>();
                        Button[] buttonArray = checkBoxes;
                        int n = checkBoxes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Button checkBox = buttonArray[n2];
                            DataCategory data = (DataCategory)checkBox.getData();
                            if (checkBox.getSelection()) {
                                selectedCategories.add(data);
                            }
                            checkBox.setEnabled(true);
                            ++n2;
                        }
                        group = new DataCategoryGroup(groupName, selectedCategories);
                    } else {
                        Button[] buttonArray = checkBoxes;
                        int n = checkBoxes.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Button checkBox = buttonArray[n3];
                            checkBox.setEnabled(false);
                            ++n3;
                        }
                    }
                    this.setPageComplete(group != null && !group.getDataCategories().isEmpty());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
            button.addSelectionListener(listener);
            Button[] buttonArray = checkBoxes;
            int n = checkBoxes.length;
            int n2 = 0;
            while (n2 < n) {
                Button checkBox = buttonArray[n2];
                checkBox.addSelectionListener(listener);
                ++n2;
            }
            listener.widgetSelected(null);
        }

        private Button[] createButtons(Composite parent, DataCategoryGroup group) {
            DataCategory[] dataCategories = group.getDataCategories().toArray(new DataCategory[0]);
            Composite container = ControlBuilder.createContainer((Composite)parent);
            ControlBuilder.gridData((Control)container).horizontalIndent = 20;
            Button[] buttons = new Button[dataCategories.length];
            int i = 0;
            while (i < buttons.length) {
                DataCategory category = dataCategories[i];
                final String preferenceKey = DataTypeTypeSelectionWizard.categoryPreferenceKey(group, category);
                final Button button = ControlBuilder.checkbox((Composite)container, (String)dataCategories[i].getLabel(), (boolean)this.preferenceStore.getBoolean(preferenceKey));
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        preferenceStore.setValue(preferenceKey, button.getSelection());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                button.setData((Object)category);
                buttons[i] = button;
                ++i;
            }
            return buttons;
        }
    }
}

