/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IMethod;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.support.history.EditInformation;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io.AbstractChromatogramReader;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.io.IChromatogramWSDZipReader;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.model.chromatogram.VendorChromatogram;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.model.chromatogram.VendorScan;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.model.chromatogram.VendorScanSignal;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.BaselineElement;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.IBaselineElement;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReader_1006
extends AbstractChromatogramReader
implements IChromatogramWSDZipReader {
    public IChromatogramWSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramWSD chromatogram = null;
        try (ZipFile zipFile = new ZipFile(file);){
            if (this.isValidFileFormat(zipFile)) {
                chromatogram = this.readFromZipFile(zipFile, "", file, monitor);
            }
        }
        return chromatogram;
    }

    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramOverview chromatogramOverview = null;
        try (ZipFile zipFile = new ZipFile(file);){
            if (this.isValidFileFormat(zipFile)) {
                chromatogramOverview = this.readOverviewFromZipFile(zipFile, "", monitor);
            }
        }
        return chromatogramOverview;
    }

    @Override
    public IChromatogramWSD read(ZipInputStream zipInputStream, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        return this.readZipData(zipInputStream, directoryPrefix, null, monitor);
    }

    @Override
    public IChromatogramWSD read(ZipFile zipFile, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        return this.readFromZipFile(zipFile, directoryPrefix, null, monitor);
    }

    private IChromatogramWSD readFromZipFile(ZipFile zipFile, String directoryPrefix, File file, IProgressMonitor monitor) throws IOException {
        return this.readZipData(zipFile, directoryPrefix, file, monitor);
    }

    private IChromatogramOverview readOverviewFromZipFile(ZipFile zipFile, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, String.valueOf(directoryPrefix) + "WSD/OVERVIEW/TIC");
        VendorChromatogram chromatogram = new VendorChromatogram();
        this.readScansOverview(dataInputStream, chromatogram, monitor);
        dataInputStream.close();
        return chromatogram;
    }

    private IChromatogramWSD readZipData(Object object, String directoryPrefix, File file, IProgressMonitor monitor) throws IOException {
        boolean closeStream;
        if (object instanceof ZipFile) {
            closeStream = true;
        } else if (object instanceof ZipInputStream) {
            closeStream = false;
        } else {
            return null;
        }
        VendorChromatogram chromatogram = null;
        chromatogram = new VendorChromatogram();
        this.readMethod(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/SYSTEM_SETTINGS"), closeStream, chromatogram, monitor);
        this.readScans(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/SCANS"), closeStream, chromatogram, monitor);
        this.readBaselines(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/BASELINE"), closeStream, chromatogram, monitor);
        this.readHistory(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/HISTORY"), closeStream, chromatogram, monitor);
        this.readMiscellaneous(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/MISC"), closeStream, chromatogram, monitor);
        this.setAdditionalInformation(file, chromatogram, monitor);
        return chromatogram;
    }

    private void readScansOverview(DataInputStream dataInputStream, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        int scans = dataInputStream.readInt();
        int scan = 1;
        while (scan <= scans) {
            VendorScan scanObject = new VendorScan();
            int scanSignals = dataInputStream.readInt();
            int scanSignal = 0;
            while (scanSignal < scanSignals) {
                VendorScanSignal scanSignalObject = new VendorScanSignal();
                int wavelength = dataInputStream.readInt();
                float abundance = dataInputStream.readFloat();
                scanSignalObject.setWavelength(wavelength);
                scanSignalObject.setAbundance(abundance);
                scanObject.addScanSignal(scanSignalObject);
                ++scanSignal;
            }
            int retentionTime = dataInputStream.readInt();
            float retentionIndex = dataInputStream.readFloat();
            float totalSignal = dataInputStream.readFloat();
            int timeSegmentId = dataInputStream.readInt();
            int cycleNumber = dataInputStream.readInt();
            scanObject.setRetentionTime(retentionTime);
            scanObject.setRetentionIndex(retentionIndex);
            scanObject.setTimeSegmentId(timeSegmentId);
            scanObject.setCycleNumber(cycleNumber);
            scanObject.adjustTotalSignal(totalSignal);
            chromatogram.addScan((IScan)scanObject);
            ++scan;
        }
    }

    private void readMethod(DataInputStream dataInputStream, boolean closeStream, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        IMethod method = chromatogram.getMethod();
        method.setInstrumentName(this.readString(dataInputStream));
        method.setIonSource(this.readString(dataInputStream));
        method.setSamplingRate(dataInputStream.readDouble());
        method.setSolventDelay(dataInputStream.readInt());
        method.setSourceHeater(dataInputStream.readDouble());
        method.setStopMode(this.readString(dataInputStream));
        method.setStopTime(dataInputStream.readInt());
        method.setTimeFilterPeakWidth(dataInputStream.readInt());
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private void readScans(DataInputStream dataInputStream, boolean closeStream, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        int scans = dataInputStream.readInt();
        int scan = 1;
        while (scan <= scans) {
            VendorScan scanWSD = new VendorScan();
            int scanSignals = dataInputStream.readInt();
            int scanSignal = 0;
            while (scanSignal < scanSignals) {
                VendorScanSignal scanSignalObject = new VendorScanSignal();
                int wavelength = dataInputStream.readInt();
                float abundance = dataInputStream.readFloat();
                scanSignalObject.setWavelength(wavelength);
                scanSignalObject.setAbundance(abundance);
                scanWSD.addScanSignal(scanSignalObject);
                ++scanSignal;
            }
            int retentionTime = dataInputStream.readInt();
            int retentionTimeColumn1 = dataInputStream.readInt();
            int retentionTimeColumn2 = dataInputStream.readInt();
            float retentionIndex = dataInputStream.readFloat();
            if (dataInputStream.readBoolean()) {
                int size = dataInputStream.readInt();
                int i = 0;
                while (i < size) {
                    RetentionIndexType retentionIndexType = RetentionIndexType.valueOf((String)this.readString(dataInputStream));
                    float retentionIndexAdditional = dataInputStream.readFloat();
                    scanWSD.setRetentionIndex(retentionIndexType, retentionIndexAdditional);
                    ++i;
                }
            }
            float totalSignal = dataInputStream.readFloat();
            int timeSegmentId = dataInputStream.readInt();
            int cycleNumber = dataInputStream.readInt();
            scanWSD.setRetentionTime(retentionTime);
            scanWSD.setRetentionTimeColumn1(retentionTimeColumn1);
            scanWSD.setRetentionTimeColumn2(retentionTimeColumn2);
            scanWSD.setRetentionIndex(retentionIndex);
            scanWSD.setTimeSegmentId(timeSegmentId);
            scanWSD.setCycleNumber(cycleNumber);
            scanWSD.adjustTotalSignal(totalSignal);
            chromatogram.addScan((IScan)scanWSD);
            ++scan;
        }
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private void readBaselines(DataInputStream dataInputStream, boolean closeStream, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        int scans = dataInputStream.readInt();
        ArrayList<BaselineElement> baselineElements = new ArrayList<BaselineElement>();
        int scan = 1;
        while (scan <= scans) {
            int retentionTime = dataInputStream.readInt();
            float backgroundAbundance = dataInputStream.readFloat();
            BaselineElement baselineElement = new BaselineElement(retentionTime, backgroundAbundance);
            baselineElements.add(baselineElement);
            ++scan;
        }
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        int index = 0;
        while (index < scans - 1) {
            IBaselineElement baselineElement = (IBaselineElement)baselineElements.get(index);
            IBaselineElement baselineElementNext = (IBaselineElement)baselineElements.get(index + 1);
            int startRetentionTime = baselineElement.getRetentionTime();
            float startBackgroundAbundance = baselineElement.getBackgroundAbundance();
            int stopRetentionTime = baselineElementNext.getRetentionTime();
            float stopBackgroundAbundance = baselineElementNext.getBackgroundAbundance();
            baselineModel.addBaseline(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance, false);
            ++index;
        }
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private void readHistory(DataInputStream dataInputStream, boolean closeStream, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        IEditHistory editHistory = chromatogram.getEditHistory();
        int numEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numEntries) {
            long time = dataInputStream.readLong();
            String description = this.readString(dataInputStream);
            Date date = new Date(time);
            EditInformation editInformation = new EditInformation(date, description);
            editHistory.add((Object)editInformation);
            ++i;
        }
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private void readMiscellaneous(DataInputStream dataInputStream, boolean closeStream, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        long time = dataInputStream.readLong();
        String miscInfo = this.readString(dataInputStream);
        String miscInfoSeparated = this.readString(dataInputStream);
        String dataName = this.readString(dataInputStream);
        String operator = this.readString(dataInputStream);
        Date date = new Date(time);
        chromatogram.setDate(date);
        chromatogram.setMiscInfo(miscInfo);
        chromatogram.setMiscInfoSeparated(miscInfoSeparated);
        chromatogram.setDataName(dataName);
        chromatogram.setOperator(operator);
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private boolean isValidFileFormat(ZipFile zipFile) throws IOException {
        boolean isValid = false;
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "VERSION");
        String version = this.readString(dataInputStream);
        if (version.equals("1.0.0.6")) {
            isValid = true;
        }
        dataInputStream.close();
        return isValid;
    }

    private void setAdditionalInformation(File file, IChromatogramWSD chromatogram, IProgressMonitor monitor) {
        int startRetentionTime;
        chromatogram.setConverterId("org.eclipse.chemclipse.xxd.converter.supplier.chemclipse");
        chromatogram.setFile(file);
        int scanDelay = startRetentionTime = chromatogram.getStartRetentionTime();
        chromatogram.setScanDelay(scanDelay);
        int endRetentionTime = chromatogram.getStopRetentionTime();
        int scanInterval = endRetentionTime / chromatogram.getNumberOfScans();
        chromatogram.setScanInterval(scanInterval);
    }
}

