/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.process.support;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.wsd.converter.chromatogram.ChromatogramConverterWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.ChromatogramSelectionWSD;
import org.eclipse.chemclipse.xxd.process.files.SupplierFileIdentifier;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramTypeSupport {
    private static final Logger logger = Logger.getLogger(ChromatogramTypeSupport.class);
    private static final String DESCRIPTION = "Chromatogram Type Support";
    private final List<ISupplierFileIdentifier> supplierEditorSupportList = new ArrayList<ISupplierFileIdentifier>();

    @Deprecated
    public ChromatogramTypeSupport() {
        this(new DataType[]{DataType.CSD, DataType.MSD, DataType.WSD});
    }

    public ChromatogramTypeSupport(DataType[] dataTypes) {
        DataType[] dataTypeArray = dataTypes;
        int n = dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DataType dataType = dataTypeArray[n2];
            this.supplierEditorSupportList.add(new SupplierFileIdentifier(dataType));
            ++n2;
        }
    }

    public IProcessingInfo<IChromatogramSelection<?, ?>> getChromatogramSelection(String pathChromatogram, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        File file = new File(pathChromatogram);
        DataType dataType = this.detectDataType(file);
        if (dataType != null) {
            ChromatogramSelectionMSD chromatogramSelection = null;
            boolean fireUpdate = false;
            switch (dataType) {
                case MSD_NOMINAL: 
                case MSD_TANDEM: 
                case MSD_HIGHRES: 
                case MSD: {
                    IProcessingInfo processingInfoMSD = ChromatogramConverterMSD.getInstance().convert(file, monitor);
                    IChromatogramMSD chromatogramMSD = (IChromatogramMSD)processingInfoMSD.getProcessingResult();
                    chromatogramSelection = new ChromatogramSelectionMSD(chromatogramMSD, fireUpdate);
                    break;
                }
                case CSD: {
                    IProcessingInfo processingInfoCSD = ChromatogramConverterCSD.getInstance().convert(file, monitor);
                    IChromatogramCSD chromatogramCSD = (IChromatogramCSD)processingInfoCSD.getProcessingResult();
                    chromatogramSelection = new ChromatogramSelectionCSD(chromatogramCSD, fireUpdate);
                    break;
                }
                case WSD: {
                    IProcessingInfo processingInfoWSD = ChromatogramConverterWSD.getInstance().convert(file, monitor);
                    IChromatogramWSD chromatogramWSD = (IChromatogramWSD)processingInfoWSD.getProcessingResult();
                    chromatogramSelection = new ChromatogramSelectionWSD(chromatogramWSD, fireUpdate);
                }
            }
            if (chromatogramSelection != null) {
                processingInfo.setProcessingResult(chromatogramSelection);
            } else {
                String message = "Chromatogram Selection is null: " + file + " " + dataType;
                processingInfo.addErrorMessage(DESCRIPTION, message);
                logger.warn((Object)message);
            }
        } else {
            String message = "Could not detect data type of file: " + file;
            processingInfo.addErrorMessage(DESCRIPTION, message);
            logger.warn((Object)message);
        }
        return processingInfo;
    }

    public DataType detectDataType(File file) {
        DataType dataType;
        String type = "";
        if (file.exists()) {
            for (ISupplierFileIdentifier supplierFileIdentifier : this.supplierEditorSupportList) {
                if (!this.isSupplierFile(supplierFileIdentifier, file)) continue;
                type = supplierFileIdentifier.getType();
                break;
            }
        }
        switch (type) {
            case "MSD": {
                dataType = DataType.MSD;
                break;
            }
            case "CSD": {
                dataType = DataType.CSD;
                break;
            }
            case "WSD": {
                dataType = DataType.WSD;
                break;
            }
            default: {
                dataType = null;
            }
        }
        return dataType;
    }

    public boolean isSupplierFile(ISupplierFileIdentifier supplierFileIdentifier, File file) {
        return supplierFileIdentifier.isSupplierFile(file) && supplierFileIdentifier.isMatchMagicNumber(file);
    }
}

