/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.metadata.generation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLTypes;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.NumericType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCursorType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.SizedType;

public class Util {
    public static final String ARRAY_STR = "ARRAY";
    public static final String BIGINT_STR = "BIGINT";
    public static final String BINARY_STR = "BINARY";
    public static final String BLOB_STR = "BLOB";
    public static final String BOOLEAN_STR = "BOOLEAN";
    public static final String CHAR_STR = "CHAR";
    public static final String CLOB_STR = "CLOB";
    public static final String DATE_STR = "DATE";
    public static final String DECIMAL_STR = "DECIMAL";
    public static final String DOUBLE_STR = "DOUBLE";
    public static final String FLOAT_STR = "FLOAT";
    public static final String INTEGER_STR = "INTEGER";
    public static final String LONG_STR = "LONG";
    public static final String LONGRAW_STR = "LONG RAW";
    public static final String LONGVARBINARY_STR = "LONGVARBINARY";
    public static final String NCHAR_STR = "NCHAR";
    public static final String NCLOB_STR = "NCLOB";
    public static final String NUMBER_STR = "NUMBER";
    public static final String NUMERIC_STR = "NUMERIC";
    public static final String NVARCHAR_STR = "NVARCHAR";
    public static final String NVARCHAR2_STR = "NVARCHAR2";
    public static final String OTHER_STR = "OTHER";
    public static final String RAW_STR = "RAW";
    public static final String REAL_STR = "REAL";
    public static final String ROWID_STR = "ROWID";
    public static final String ROWTYPE_STR = "%ROWTYPE";
    public static final String SMALLINT_STR = "SMALLINT";
    public static final String STRUCT_STR = "STRUCT";
    public static final String TIME_STR = "TIME";
    public static final String TIMESTAMP_STR = "TIMESTAMP";
    public static final String TINYINT_STR = "TINYINT";
    public static final String UROWID_STR = "UROWID";
    public static final String VARBINARY_STR = "VARBINARY";
    public static final String VARCHAR_STR = "VARCHAR";
    public static final String VARCHAR2_STR = "VARCHAR2";
    public static final String BINARY_INTEGER_STR = "BINARY_INTEGER";
    public static final String PLS_INTEGER_STR = "PLS_INTEGER";
    public static final String NATURAL_STR = "NATURAL";
    public static final String POSITIVE_STR = "POSITIVE";
    public static final String SIGNTYPE_STR = "SIGNTYPE";
    public static final String BINARY_INTEGER_TYPE_STR = "BinaryInteger";
    public static final String PLS_BOOLEAN_TYPE_STR = "PLSQLBoolean";
    public static final String PLS_INTEGER_TYPE_STR = "PLSQLInteger";
    public static final String NATURAL_TYPE_STR = "Natural";
    public static final String POSITIVE_TYPE_STR = "Positive";
    public static final String SIGNTYPE_TYPE_STR = "SignType";
    public static final String SYS_XMLTYPE_STR = "SYS.XMLTYPE";
    public static final String XMLTYPE_STR = "XMLTYPE";
    public static final String _TYPE_STR = "_TYPE";
    public static final String COMMA = ",";
    public static final String SINGLE_SPACE = " ";
    public static final String COMMA_SPACE_STR = ", ";
    public static final String ALL_QUERYNAME = "findAll";
    public static final String PK_QUERYNAME = "findByPrimaryKey";
    public static final String CREATE_OPERATION_NAME = "create";
    public static final String UPDATE_OPERATION_NAME = "update";
    public static final String REMOVE_OPERATION_NAME = "delete";
    public static final String OPEN_BRACKET = "(";
    public static final String CLOSE_BRACKET = ")";
    public static final String TYPE_STR = "Type";
    public static final String SELECT_FROM_STR = "SELECT * FROM ";
    public static final String WHERE_STR = " WHERE ";
    public static final String AND_STR = " AND ";
    public static final String SET_STR = " SET ";
    public static final String VALUES_STR = " VALUES ";
    public static final String UPDATE_STR = "UPDATE ";
    public static final String INSERT_STR = "INSERT INTO ";
    public static final String DELETE_STR = "DELETE FROM ";
    public static final String EQUALS_BINDING1_STR = " = ?1";
    public static final String EQUALS_BINDING_STR = " = ?";
    public static final String QUESTION_STR = "?";
    public static final String ARRAY_CLS_STR = "java.sql.Array";
    public static final String NCLOB_CLS_STR = "java.sql.NClob";
    public static final String OPAQUE_CLS_STR = "java.sql.Struct";
    public static final String ROWID_CLS_STR = "java.sql.RowId";
    public static final String STRUCT_CLS_STR = "oracle.sql.OPAQUE";
    public static final String ORACLE_TIMESTAMP_CLS_STR = "oracle.sql.TIMESTAMP";
    static final String ARRAYLIST_CLS_STR = "java.util.ArrayList";
    static final String IN_STR = "IN";
    static final String INOUT_STR = "IN_OUT";
    static final String OUT_STR = "OUT";
    static final String OUT_CURSOR_STR = "OUT_CURSOR";
    static final String CURSOR_STR = "CURSOR";
    static final String RESULT_STR = "RESULT";
    public static final String DOT = ".";
    public static final String PERCENT = "%";
    public static final String UNDERSCORE = "_";
    public static final String ITEMS_FLD_STR = "items";
    public static final String ITEMS_COL_STR = "ITEMS";
    public static final int OPAQUE = 2007;

    public static String getUnqualifiedEntityName(String tableName) {
        String first = tableName.substring(0, 1).toUpperCase();
        String rest = tableName.toLowerCase().substring(1);
        return first.concat(rest);
    }

    public static String getEntityName(String tableName, String packageName) {
        String entityName = Util.getUnqualifiedEntityName(tableName);
        return packageName == null ? entityName : String.valueOf(packageName) + DOT + entityName;
    }

    public static String getJDBCTypeName(String typeName) {
        return Util.getJDBCTypeNameFromType(Util.getJDBCTypeFromTypeName(typeName));
    }

    public static int getJDBCTypeFromTypeName(String typeName) {
        if (typeName.equals(NUMERIC_STR)) {
            return 2;
        }
        if (typeName.equals(VARCHAR_STR) || typeName.equals(VARCHAR2_STR)) {
            return 12;
        }
        if (typeName.equals(NVARCHAR_STR) || typeName.equals(NVARCHAR2_STR)) {
            return -9;
        }
        if (typeName.equals(DATE_STR)) {
            return 91;
        }
        if (typeName.equals(TIME_STR)) {
            return 92;
        }
        if (typeName.equals(TIMESTAMP_STR)) {
            return 93;
        }
        if (typeName.equals(DECIMAL_STR)) {
            return 3;
        }
        if (typeName.equals(INTEGER_STR)) {
            return 4;
        }
        if (typeName.equals(CHAR_STR)) {
            return 1;
        }
        if (typeName.equals(NCHAR_STR)) {
            return -15;
        }
        if (typeName.equals(FLOAT_STR)) {
            return 6;
        }
        if (typeName.equals(REAL_STR)) {
            return 7;
        }
        if (typeName.equals(DOUBLE_STR)) {
            return 8;
        }
        if (typeName.equals(BINARY_STR)) {
            return -2;
        }
        if (typeName.equals(BLOB_STR)) {
            return 2004;
        }
        if (typeName.equals(CLOB_STR) || typeName.equals(LONG_STR)) {
            return 2005;
        }
        if (typeName.equals(NCLOB_STR)) {
            return 2011;
        }
        if (typeName.equals(RAW_STR) || typeName.equals(LONGRAW_STR)) {
            return -4;
        }
        if (typeName.equals(ROWID_STR)) {
            return 12;
        }
        if (typeName.equals(UROWID_STR)) {
            return 12;
        }
        if (typeName.equals(BIGINT_STR)) {
            return -5;
        }
        if (typeName.equals(STRUCT_STR)) {
            return 2002;
        }
        if (typeName.equals(ARRAY_STR)) {
            return 2003;
        }
        if (typeName.equals(ROWID_STR)) {
            return -8;
        }
        if (typeName.equalsIgnoreCase(XMLTYPE_STR) || typeName.equalsIgnoreCase(SYS_XMLTYPE_STR)) {
            return 12;
        }
        if (typeName.equals(BOOLEAN_STR) || typeName.equals(INTEGER_STR) || typeName.equals(SMALLINT_STR) || typeName.equals(TINYINT_STR)) {
            return 4;
        }
        return 1111;
    }

    public static String getJDBCTypeNameFromType(int jdbcType) {
        String typeName = null;
        switch (jdbcType) {
            case 2: {
                typeName = NUMERIC_STR;
                break;
            }
            case 12: {
                typeName = VARCHAR_STR;
                break;
            }
            case -9: {
                typeName = NVARCHAR_STR;
                break;
            }
            case 3: {
                typeName = DECIMAL_STR;
                break;
            }
            case 1: {
                typeName = CHAR_STR;
                break;
            }
            case -15: {
                typeName = NCHAR_STR;
                break;
            }
            case 6: {
                typeName = FLOAT_STR;
                break;
            }
            case 7: {
                typeName = REAL_STR;
                break;
            }
            case 8: {
                typeName = DOUBLE_STR;
                break;
            }
            case -2: {
                typeName = BINARY_STR;
                break;
            }
            case 2004: {
                typeName = BLOB_STR;
                break;
            }
            case 2005: {
                typeName = CLOB_STR;
                break;
            }
            case 2011: {
                typeName = NCLOB_STR;
                break;
            }
            case -3: {
                typeName = LONGVARBINARY_STR;
                break;
            }
            case -4: {
                typeName = LONGVARBINARY_STR;
                break;
            }
            case 91: {
                typeName = DATE_STR;
                break;
            }
            case 92: {
                typeName = TIME_STR;
                break;
            }
            case 93: {
                typeName = TIMESTAMP_STR;
                break;
            }
            case -5: {
                typeName = BIGINT_STR;
                break;
            }
            case 2003: {
                typeName = ARRAY_STR;
                break;
            }
            case 2002: {
                typeName = STRUCT_STR;
                break;
            }
            case -8: {
                typeName = ROWID_STR;
                break;
            }
            default: {
                typeName = OTHER_STR;
            }
        }
        return typeName;
    }

    public static String getClassNameFromJDBCTypeName(String typeName, DatabasePlatform databasePlatform) {
        return Util.getClassFromJDBCTypeName(typeName, databasePlatform).getName();
    }

    public static Class<?> getClassFromJDBCTypeName(String typeName, DatabasePlatform databasePlatform) {
        Class clz = (Class)databasePlatform.getClassTypes().get(typeName);
        if (clz == null) {
            return ClassConstants.Object_Class;
        }
        return clz;
    }

    protected static String processTypeName(String typeName) {
        if (Util.getJDBCTypeFromTypeName(typeName) != 1111) {
            if (typeName.equals(XMLTYPE_STR)) {
                typeName = OraclePLSQLTypes.XMLType.name();
            } else {
                if (typeName.equals(VARCHAR2_STR)) {
                    typeName = VARCHAR_STR;
                }
                if (!typeName.equals(BOOLEAN_STR)) {
                    typeName = typeName.concat(_TYPE_STR);
                }
            }
        } else {
            String oPLSQLTypeName = Util.getOraclePLSQLTypeForName(typeName);
            if (oPLSQLTypeName != null) {
                typeName = oPLSQLTypeName;
            }
        }
        return typeName;
    }

    public static String getGeneratedJavaClassName(String name) {
        int dotIdx = name.lastIndexOf(DOT);
        if (dotIdx == -1) {
            return Util.getGeneratedJavaClassName(name, null);
        }
        String packageName = name.substring(0, dotIdx).toLowerCase();
        String typeName = name.substring(dotIdx + 1);
        String first = typeName.substring(0, 1).toUpperCase();
        String rest = typeName.toLowerCase().substring(1);
        return String.valueOf(packageName) + DOT + first + rest;
    }

    public static String getGeneratedJavaClassName(String name, String packageName) {
        String first = name.substring(0, 1).toUpperCase();
        String rest = name.toLowerCase().substring(1);
        return packageName == null || packageName.length() == 0 ? String.valueOf(first) + rest : String.valueOf(packageName.toLowerCase()) + DOT + first + rest;
    }

    public static String getQualifiedTypeName(DatabaseType dbType) {
        if (dbType.isPLSQLType()) {
            String packageName = ((PLSQLType)dbType).getParentType().getPackageName();
            return packageName != null ? String.valueOf(packageName) + DOT + dbType.getTypeName() : dbType.getTypeName();
        }
        if (dbType.isPLSQLCursorType()) {
            PLSQLCursorType cursor = (PLSQLCursorType)dbType;
            return String.valueOf(cursor.getParentType().getPackageName()) + DOT + cursor.getCursorName();
        }
        return dbType.getTypeName();
    }

    public static String getQualifiedCompatibleTypeName(DatabaseType dbType) {
        String packageName = null;
        if (dbType.isPLSQLType()) {
            PLSQLType plsqlType = (PLSQLType)dbType;
            packageName = plsqlType.getParentType().getPackageName();
        }
        return packageName != null ? String.valueOf(packageName) + UNDERSCORE + dbType.getTypeName() : dbType.getTypeName();
    }

    public static boolean isArgPLSQLScalar(String argTypeName) {
        return argTypeName.equals(BOOLEAN_STR) || argTypeName.equals(PLS_INTEGER_STR) || argTypeName.equals(BINARY_INTEGER_STR) || argTypeName.equals(NATURAL_STR) || argTypeName.equals(POSITIVE_STR) || argTypeName.equals(SIGNTYPE_STR);
    }

    public static String getOraclePLSQLTypeForName(String typeName) {
        if (typeName.equals(BINARY_INTEGER_STR)) {
            return BINARY_INTEGER_TYPE_STR;
        }
        if (typeName.equals(BOOLEAN_STR)) {
            return PLS_BOOLEAN_TYPE_STR;
        }
        if (typeName.equals(PLS_INTEGER_STR)) {
            return PLS_INTEGER_TYPE_STR;
        }
        if (typeName.equals(NATURAL_STR)) {
            return NATURAL_TYPE_STR;
        }
        if (typeName.equals(POSITIVE_STR)) {
            return POSITIVE_TYPE_STR;
        }
        if (typeName.equals(SIGNTYPE_STR)) {
            return SIGNTYPE_TYPE_STR;
        }
        return null;
    }

    protected static String getAttributeTypeNameForFieldType(FieldType fldType, DatabasePlatform dbPlatform) {
        SizedType sizedType;
        String typeName = Util.getJDBCTypeName(fldType.getTypeName());
        String attributeType = CHAR_STR.equalsIgnoreCase(typeName) && fldType.getEnclosedType().isSizedType() ? ((sizedType = (SizedType)fldType.getEnclosedType()).getSize() == 1L ? ClassConstants.CHAR.getName() : ClassConstants.STRING.getName()) : Util.getClassNameFromJDBCTypeName(typeName.toUpperCase(), dbPlatform);
        if (attributeType.contains(ORACLE_TIMESTAMP_CLS_STR)) {
            attributeType = ClassConstants.TIMESTAMP.getName();
        } else if (attributeType.contains(ClassConstants.ABYTE.getName())) {
            attributeType = ClassConstants.APBYTE.getName();
        }
        return attributeType;
    }

    protected static String getTypeNameForDatabaseType(DatabaseType dataType) {
        NumericType numericDataType;
        String typeName = dataType.getTypeName();
        if (dataType.isNumericType() && (numericDataType = (NumericType)dataType).getScale() > 0L) {
            typeName = DECIMAL_STR;
        }
        return typeName;
    }

    protected static void handleOverloading(List<ProcedureType> procedures) {
        HashMap<String, ArrayList<ProcedureType>> overloadMap = new HashMap<String, ArrayList<ProcedureType>>();
        for (ProcedureType procedure : procedures) {
            String procedureName = procedure.getProcedureName();
            ArrayList<ProcedureType> multipleProcedures = (ArrayList<ProcedureType>)overloadMap.get(procedureName);
            if (multipleProcedures == null) {
                multipleProcedures = new ArrayList<ProcedureType>();
                overloadMap.put(procedureName, multipleProcedures);
            }
            multipleProcedures.add(procedure);
        }
        for (List procs : overloadMap.values()) {
            if (procs.size() <= 1) continue;
            int i = 0;
            int len = procs.size();
            while (i < len) {
                ((ProcedureType)procs.get(i)).setOverload(i);
                ++i;
            }
        }
    }
}

