/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ICustomSelectionHandler;
import org.eclipse.swtchart.extensions.core.MappingsDialog;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.internal.marker.EmbeddedLegend;
import org.eclipse.swtchart.extensions.internal.support.PositionValidator;
import org.eclipse.swtchart.extensions.internal.support.SeriesMapper;
import org.eclipse.swtchart.extensions.preferences.PreferencePage;

public class ExtendedLegendUI
extends Composite {
    private ScrollableChart scrollableChart;
    private Text textX;
    private Text textY;
    private SeriesListUI seriesListUI;
    private EmbeddedLegend embeddedLegend;
    private boolean capturePosition = false;
    private List<Control> controls = new ArrayList<Control>();
    private IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();

    public ExtendedLegendUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setScrollableChart(ScrollableChart scrollableChart) {
        this.scrollableChart = scrollableChart;
        this.seriesListUI.setScrollableChart(scrollableChart);
        this.createEmbeddedLegend();
    }

    public void setInput(Object input) {
        if (input instanceof ISeries[] && this.scrollableChart != null) {
            ISeries[] seriesArray = (ISeries[])input;
            BaseChart baseChart = this.scrollableChart.getBaseChart();
            SeriesMapper seriesMapper = new SeriesMapper(baseChart);
            seriesMapper.adjustSettings(seriesArray);
        }
        this.seriesListUI.setInput(input);
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(this);
        this.seriesListUI = this.createListSection(this);
        this.updateControls();
        this.applySettings();
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(10, false));
        this.add((Control)this.createButtonMove(composite, "arrowLeft.gif", "Move Legend Left"));
        this.add((Control)this.createButtonMove(composite, "arrowUp.gif", "Move Legend Up"));
        this.add((Control)this.createButtonMove(composite, "arrowDown.gif", "Move Legend Down"));
        this.add((Control)this.createButtonMove(composite, "arrowRight.gif", "Move Legend Right"));
        this.textX = this.createTextPositionX(composite);
        this.add((Control)this.textX);
        this.textY = this.createTextPositionY(composite);
        this.add((Control)this.textY);
        this.add((Control)this.createButtonSetPosition(composite));
        this.createButtonToggleLegend(composite);
        this.createButtonMappings(composite);
        this.createButtonSettings(composite);
    }

    private void add(Control control) {
        this.controls.add(control);
    }

    private Button createButtonMove(Composite parent, final String icon, String tooltip) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText(tooltip);
        button.setImage(ResourceSupport.getImage(icon));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block16: {
                    if (ExtendedLegendUI.this.embeddedLegend == null) break block16;
                    int moveX = ExtendedLegendUI.this.preferenceStore != null ? ExtendedLegendUI.this.preferenceStore.getInt("moveLegendX") : 10;
                    int moveY = ExtendedLegendUI.this.preferenceStore != null ? ExtendedLegendUI.this.preferenceStore.getInt("moveLegendY") : 5;
                    int x = ExtendedLegendUI.this.embeddedLegend.getX();
                    int y = ExtendedLegendUI.this.embeddedLegend.getY();
                    switch (icon) {
                        case "arrowLeft.gif": {
                            x -= moveX;
                            break;
                        }
                        case "arrowUp.gif": {
                            y -= moveY;
                            break;
                        }
                        case "arrowDown.gif": {
                            y += moveY;
                            break;
                        }
                        case "arrowRight.gif": {
                            x += moveX;
                        }
                    }
                    ExtendedLegendUI.this.updateLegendPosition(x, y, true);
                }
            }
        });
        return button;
    }

    private Text createTextPositionX(Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("Legend Position X");
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 80;
        text.setLayoutData((Object)gridData);
        final PositionValidator validator = new PositionValidator();
        final ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (ExtendedLegendUI.this.validate(validator, controlDecoration, text) && ExtendedLegendUI.this.preferenceStore != null) {
                    ExtendedLegendUI.this.preferenceStore.setValue("legendPositionX", validator.getPosition());
                    ExtendedLegendUI.this.updateLegendPosition(true);
                }
            }
        });
        return text;
    }

    private Text createTextPositionY(Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("Legend Position Y");
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 80;
        text.setLayoutData((Object)gridData);
        final PositionValidator validator = new PositionValidator();
        final ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (ExtendedLegendUI.this.validate(validator, controlDecoration, text) && ExtendedLegendUI.this.preferenceStore != null) {
                    ExtendedLegendUI.this.preferenceStore.setValue("legendPositionY", validator.getPosition());
                    ExtendedLegendUI.this.updateLegendPosition(true);
                }
            }
        });
        return text;
    }

    private Button createButtonSetPosition(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Set the position of the legend.");
        button.setImage(ResourceSupport.getImage("position.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedLegendUI.this.capturePosition = MessageDialog.openConfirm((Shell)e.display.getActiveShell(), (String)"Legend Position", (String)"Set the position manually by using left mouse button double-click in the chart.");
            }
        });
        return button;
    }

    private Button createButtonToggleLegend(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the visibility of the embedded legend.");
        button.setImage(ResourceSupport.getImage("legend.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedLegendUI.this.embeddedLegend != null) {
                    boolean draw = ExtendedLegendUI.this.embeddedLegend.isDraw();
                    ExtendedLegendUI.this.embeddedLegend.setDraw(!draw);
                    if (ExtendedLegendUI.this.scrollableChart != null) {
                        ExtendedLegendUI.this.scrollableChart.redraw();
                    }
                    ExtendedLegendUI.this.updateControls();
                }
            }
        });
        return button;
    }

    private Button createButtonMappings(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Displays the mappings.");
        button.setImage(ResourceSupport.getImage("mappings.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingsDialog mappingsDialog = new MappingsDialog(e.display.getActiveShell());
                mappingsDialog.open();
            }
        });
        return button;
    }

    private Button createButtonSettings(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Open the settings page.");
        button.setImage(ResourceSupport.getImage("preferences.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePage()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedLegendUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
        return button;
    }

    private void applySettings() {
        this.updateLegendPosition(true);
    }

    private SeriesListUI createListSection(Composite parent) {
        SeriesListUI seriesListUI = new SeriesListUI(parent, 68354);
        Table table = seriesListUI.getTable();
        table.setLayoutData((Object)new GridData(1808));
        return seriesListUI;
    }

    private void createEmbeddedLegend() {
        if (this.scrollableChart != null) {
            BaseChart baseChart = this.scrollableChart.getBaseChart();
            this.embeddedLegend = new EmbeddedLegend(baseChart);
            this.embeddedLegend.setDraw(false);
            this.updateLegendPosition(false);
            baseChart.getPlotArea().addCustomPaintListener((ICustomPaintListener)this.embeddedLegend);
            baseChart.addCustomPointSelectionHandler(new ICustomSelectionHandler(){

                @Override
                public void handleUserSelection(Event event) {
                    if (ExtendedLegendUI.this.embeddedLegend.isDraw() && ExtendedLegendUI.this.capturePosition) {
                        ExtendedLegendUI.this.updateLegendPosition(event.x, event.y, true);
                        ExtendedLegendUI.this.updateControls();
                        ExtendedLegendUI.this.capturePosition = false;
                    }
                }
            });
        }
        this.updateControls();
    }

    private void updateLegendPosition(boolean redraw) {
        if (this.preferenceStore != null) {
            this.updateLegendPosition(this.preferenceStore.getInt("legendPositionX"), this.preferenceStore.getInt("legendPositionY"), redraw);
        }
    }

    private void updateLegendPosition(int x, int y, boolean redraw) {
        if (this.embeddedLegend != null) {
            this.embeddedLegend.setX(x);
            this.embeddedLegend.setY(y);
            if (this.preferenceStore != null) {
                this.preferenceStore.setValue("legendPositionX", x);
                this.preferenceStore.setValue("legendPositionY", y);
            }
            this.textX.setText(Integer.toString(this.embeddedLegend.getX()));
            this.textY.setText(Integer.toString(this.embeddedLegend.getY()));
            if (this.scrollableChart != null && redraw) {
                this.scrollableChart.redraw();
            }
        }
    }

    private void updateControls() {
        if (this.embeddedLegend != null) {
            boolean enabled = this.embeddedLegend.isDraw();
            for (Control control : this.controls) {
                control.setEnabled(enabled);
            }
        }
    }

    private boolean validate(IValidator validator, ControlDecoration controlDecoration, Text text) {
        IStatus status = validator.validate((Object)text.getText().trim());
        if (status.isOK()) {
            controlDecoration.hide();
            return true;
        }
        controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        controlDecoration.showHoverText(status.getMessage());
        controlDecoration.show();
        return false;
    }
}

