/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableLongStack;
import org.eclipse.collections.api.stack.primitive.LongStack;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedLongProcedure;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.LongStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableLongArrayStack
implements ImmutableLongStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final LongArrayList delegate;

    private ImmutableLongArrayStack(long[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = new LongArrayList(newElements);
    }

    private ImmutableLongArrayStack(LongArrayList newElements) {
        this.checkOptimizedSize(newElements.size());
        this.delegate = newElements;
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use LongStacks.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableLongArrayStack newStack(LongIterable iterable) {
        return new ImmutableLongArrayStack(iterable.toArray());
    }

    public static ImmutableLongArrayStack newStackWith(long ... elements) {
        long[] newArray = new long[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableLongArrayStack(newArray);
    }

    public static ImmutableLongArrayStack newStackFromTopToBottom(long ... items) {
        return new ImmutableLongArrayStack(LongArrayList.newListWith(items).reverseThis());
    }

    public static ImmutableLongArrayStack newStackFromTopToBottom(LongIterable items) {
        return new ImmutableLongArrayStack(LongArrayList.newList(items).reverseThis());
    }

    public ImmutableLongStack push(long item) {
        LongArrayList newDelegate = LongArrayList.newList(this.delegate);
        newDelegate.add(item);
        return new ImmutableLongArrayStack(newDelegate);
    }

    public ImmutableLongStack pop() {
        LongArrayList newDelegate = LongArrayList.newList(this.delegate);
        newDelegate.removeAtIndex(this.delegate.size() - 1);
        return LongStacks.immutable.with(newDelegate.toArray());
    }

    public ImmutableLongStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        this.checkSizeLessThanCount(count);
        LongArrayList newDelegate = LongArrayList.newList(this.delegate);
        while (count > 0) {
            newDelegate.removeAtIndex(newDelegate.size() - 1);
            --count;
        }
        return LongStacks.immutable.with(newDelegate.toArray());
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public long peek() {
        return this.delegate.getLast();
    }

    public LongList peek(int count) {
        this.checkNegativeCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new LongArrayList();
        }
        LongArrayList subList = new LongArrayList(count);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    public long peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    public LongIterator longIterator() {
        return new UnmodifiableLongIterator(this.delegate.asReversed().longIterator());
    }

    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    public void each(LongProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    public int count(LongPredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    public ImmutableLongStack select(LongPredicate predicate) {
        return LongStacks.immutable.withAllReversed((LongIterable)this.delegate.asReversed().select(predicate));
    }

    public ImmutableLongStack reject(LongPredicate predicate) {
        return LongStacks.immutable.withAllReversed((LongIterable)this.delegate.asReversed().reject(predicate));
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableStack<V> collect(LongToObjectFunction<? extends V> function) {
        return Stacks.immutable.withAllReversed((Iterable)this.delegate.asReversed().collect(function));
    }

    public long sum() {
        return this.delegate.sum();
    }

    public long max() {
        return this.delegate.max();
    }

    public long maxIfEmpty(long defaultValue) {
        return this.max();
    }

    public long min() {
        return this.delegate.min();
    }

    public long minIfEmpty(long defaultValue) {
        return this.min();
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public long[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableLongList toSortedList() {
        return LongArrayList.newList((LongIterable)this).sortThis();
    }

    public long[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    public boolean contains(long value) {
        return this.delegate.asReversed().contains(value);
    }

    public boolean containsAll(long ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public boolean containsAll(LongIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public MutableLongList toList() {
        return LongArrayList.newList((LongIterable)this);
    }

    public MutableLongSet toSet() {
        return LongHashSet.newSet((LongIterable)this);
    }

    public MutableLongBag toBag() {
        return LongHashBag.newBag((LongIterable)this);
    }

    public <V> V injectInto(V injectedValue, ObjectLongToObjectFunction<? super V, ? extends V> function) {
        return this.delegate.toReversed().injectInto(injectedValue, function);
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public ImmutableLongStack toImmutable() {
        return this;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof LongStack)) {
            return false;
        }
        LongStack stack = (LongStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        LazyLongIterable iterable = this.delegate.asReversed();
        LongIterator iterator = iterable.longIterator();
        while (iterator.hasNext()) {
            long item = iterator.next();
            hashCode = 31 * hashCode + (int)(item ^ item >>> 32);
        }
        return hashCode;
    }

    public String toString() {
        return this.delegate.asReversed().toString();
    }

    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    private void checkSizeLessThanCount(int count) {
        if (this.delegate.size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.delegate.size());
        }
    }

    private Object writeReplace() {
        return new ImmutableLongStackSerializationProxy((LongStack)this);
    }

    private static class ImmutableLongStackSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private LongStack stack;

        public ImmutableLongStackSerializationProxy() {
        }

        protected ImmutableLongStackSerializationProxy(LongStack stack) {
            this.stack = stack;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.stack.size());
            try {
                this.stack.forEach((LongProcedure)new CheckedLongProcedure(){

                    public void safeValue(long item) throws IOException {
                        out.writeLong(item);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            LongArrayList deserializedDelegate = new LongArrayList(size);
            for (int i = 0; i < size; ++i) {
                deserializedDelegate.add(in.readLong());
            }
            this.stack = ImmutableLongArrayStack.newStackFromTopToBottom(deserializedDelegate);
        }

        protected Object readResolve() {
            return this.stack;
        }
    }
}

