/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.jet.JETAttributeItem;
import org.eclipse.emf.codegen.jet.JETAttributeListItem;
import org.eclipse.emf.codegen.jet.JETCharDataGenerator;
import org.eclipse.emf.codegen.jet.JETCommentItem;
import org.eclipse.emf.codegen.jet.JETCompilationUnit;
import org.eclipse.emf.codegen.jet.JETConstantDataGenerator;
import org.eclipse.emf.codegen.jet.JETCoreElement;
import org.eclipse.emf.codegen.jet.JETDirectiveItem;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETExpressionGenerator;
import org.eclipse.emf.codegen.jet.JETExpressionItem;
import org.eclipse.emf.codegen.jet.JETExtendedConstantDataGenerator;
import org.eclipse.emf.codegen.jet.JETGenerator;
import org.eclipse.emf.codegen.jet.JETItem;
import org.eclipse.emf.codegen.jet.JETLiteralItem;
import org.eclipse.emf.codegen.jet.JETMark;
import org.eclipse.emf.codegen.jet.JETNature;
import org.eclipse.emf.codegen.jet.JETParseEventListener;
import org.eclipse.emf.codegen.jet.JETParser;
import org.eclipse.emf.codegen.jet.JETProblemListener;
import org.eclipse.emf.codegen.jet.JETReader;
import org.eclipse.emf.codegen.jet.JETScriptletGenerator;
import org.eclipse.emf.codegen.jet.JETScriptletItem;
import org.eclipse.emf.codegen.jet.JETSkeleton;
import org.eclipse.emf.codegen.jet.JETSubItem;
import org.eclipse.emf.codegen.jet.JETTokenItem;
import org.eclipse.emf.codegen.jet.JETValueItem;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JETCompiler
implements JETParseEventListener,
JETParseEventListener.CommentListener {
    private static final Pattern LINE_PATTERN = Pattern.compile("([^\n\r]*)\r?\n");
    protected static final char[] NULL_CHAR_ARRAY = new char[0];
    protected String[] templateURIPath;
    protected String templateURI;
    protected JETParser parser;
    protected JETSkeleton skeleton;
    protected JETReader reader;
    protected PrintWriter writer;
    protected List<JETGenerator> generators = new ArrayList<JETGenerator>(100);
    protected List<JETConstantDataGenerator> constants = new ArrayList<JETConstantDataGenerator>(100);
    protected Map<char[], JETConstantDataGenerator> constantDictionary = new AbstractMap<char[], JETConstantDataGenerator>(){
        private final Map<String, JETConstantDataGenerator> delegate = new HashMap<String, JETConstantDataGenerator>(100, 100.0f);

        @Override
        public JETConstantDataGenerator put(char[] key, JETConstantDataGenerator value) {
            return this.delegate.put(new String(key), value);
        }

        @Override
        public JETConstantDataGenerator get(Object key) {
            return this.delegate.get(key instanceof char[] ? new String((char[])key) : key);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Set<Map.Entry<char[], JETConstantDataGenerator>> entrySet() {
            return new AbstractSet<Map.Entry<char[], JETConstantDataGenerator>>(){

                @Override
                public Iterator<Map.Entry<char[], JETConstantDataGenerator>> iterator() {
                    return new Iterator<Map.Entry<char[], JETConstantDataGenerator>>(){
                        private final Iterator<Map.Entry<String, JETConstantDataGenerator>> delegateIterator;
                        {
                            this.delegateIterator = delegate.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.delegateIterator.hasNext();
                        }

                        @Override
                        public void remove() {
                            this.delegateIterator.remove();
                        }

                        @Override
                        public Map.Entry<char[], JETConstantDataGenerator> next() {
                            final Map.Entry<String, JETConstantDataGenerator> next = this.delegateIterator.next();
                            return new Map.Entry<char[], JETConstantDataGenerator>(){

                                @Override
                                public char[] getKey() {
                                    return ((String)next.getKey()).toCharArray();
                                }

                                @Override
                                public JETConstantDataGenerator getValue() {
                                    return (JETConstantDataGenerator)next.getValue();
                                }

                                @Override
                                public JETConstantDataGenerator setValue(JETConstantDataGenerator value) {
                                    return next.setValue(value);
                                }

                                @Override
                                public boolean equals(Object obj) {
                                    if (obj instanceof Map.Entry) {
                                        String otherKeyValue;
                                        char[] key = this.getKey();
                                        String keyValue = key == null ? null : new String(key);
                                        Map.Entry entry = (Map.Entry)obj;
                                        Object otherKey = entry.getKey();
                                        String string = otherKeyValue = otherKey instanceof char[] ? new String((char[])otherKey) : null;
                                        return (keyValue == null ? otherKeyValue == null : keyValue.equals(otherKeyValue)) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
                                    }
                                    return false;
                                }

                                @Override
                                public int hashCode() {
                                    return next.hashCode();
                                }
                            };
                        }
                    };
                }

                @Override
                public int size() {
                    return delegate.size();
                }
            };
        }
    };
    protected long constantCount = 0L;
    protected boolean fNoNewLineForScriptlets = true;
    protected boolean fUseStaticFinalConstants = true;
    protected boolean useMinimizedConstants;
    protected final Map<String, String> constantSubstitutitons = new HashMap<String, String>();
    protected char[] fSavedLine;
    protected JETLiteralItem savedLineLiteralItem;
    protected int sectionDepth;
    protected boolean skipping;
    protected Stack<SkipSection> skipSections = new Stack();
    protected static final String CONSTANT_PREFIX = "TEXT_";
    protected JETInputStreamHandler inputStreamHandler;
    protected final List<JETItem> jetItems = new ArrayList<JETItem>();
    protected JETLiteralItem currentLiteralItem;
    protected JETProblemListener problemListener;
    protected JETMark pageStart;

    public JETCompiler(String templateURI) throws JETException {
        this(templateURI, "UTF8");
    }

    public JETCompiler(String templateURI, String encoding) throws JETException {
        this(templateURI, JETCompiler.openStream(templateURI, null), encoding);
    }

    public JETCompiler(String templateURI, InputStream inputStream, String encoding) throws JETException {
        this.templateURI = templateURI;
        this.reader = new JETReader(templateURI, inputStream, encoding);
        this.problemListener = new JETProblemListener();
    }

    public JETCompiler(String[] templateURIPath, String relativeTemplateURI) throws JETException {
        this(templateURIPath, relativeTemplateURI, "UTF8");
    }

    public JETCompiler(String[] templateURIPath, String relativeTemplateURI, String encoding) throws JETException {
        this(templateURIPath, relativeTemplateURI, encoding, null, new JETProblemListener());
    }

    public JETCompiler(String[] templateURIPath, String relativeTemplateURI, String encoding, JETInputStreamHandler inputStreamHandler, JETProblemListener problemListener) throws JETException {
        this.templateURIPath = templateURIPath;
        this.templateURI = relativeTemplateURI;
        String[] actualTemplateURI = JETCompiler.findLocation(templateURIPath, 0, relativeTemplateURI);
        this.inputStreamHandler = inputStreamHandler;
        this.reader = new JETReader(actualTemplateURI[1], relativeTemplateURI, JETCompiler.openStream(actualTemplateURI[0], inputStreamHandler), encoding, problemListener);
        this.problemListener = problemListener;
    }

    public String getLineSeparator() {
        if (this.reader != null) {
            char[] stream = this.reader.current.stream;
            int i = 0;
            while (i < stream.length) {
                if (stream[i] == '\n') {
                    if (i == 0 || stream[i - 1] != '\r') {
                        return new String("\n");
                    }
                    return new String("\r\n");
                }
                ++i;
            }
        }
        return System.getProperty("line.separator");
    }

    public String getResolvedTemplateURI() {
        return this.reader.getFile(0);
    }

    @Override
    public void handleDirective(String directive, JETMark start, JETMark stop, Map<String, String> attributes) throws JETException {
        SkipSection skipSection;
        JETDirectiveItem jetDirectiveItem = (JETDirectiveItem)this.reader.popItem();
        this.jetItems.add(jetDirectiveItem);
        HashMap<String, JETAttributeItem> duplicates = new HashMap<String, JETAttributeItem>();
        HashSet<JETAttributeItem> reportedProblems = new HashSet<JETAttributeItem>();
        for (JETAttributeItem jetAttributeItem : jetDirectiveItem.getAttributes().getAttributes()) {
            JETAttributeItem otherJETAttributeItem = duplicates.put(jetAttributeItem.getNameToken().getToken(), jetAttributeItem);
            if (otherJETAttributeItem == null) continue;
            reportedProblems.add(otherJETAttributeItem);
            reportedProblems.add(jetAttributeItem);
        }
        for (JETAttributeItem jetAttributeItem : reportedProblems) {
            this.problemListener.handleProblem(jetAttributeItem.getStart(), jetAttributeItem.getStop(), 2, null, "jet.error.bad.attribute.duplicate", jetAttributeItem.getNameToken().getToken(), jetAttributeItem.getStart().format("jet.mark.file.line.column"));
        }
        if (directive.equals("include")) {
            block55: {
                String fileURI = attributes.get("file");
                if (fileURI != null) {
                    String string = start.getFile();
                    Object resolvedFileURI = JETCompiler.resolveLocation(this.templateURIPath, string, fileURI);
                    if (resolvedFileURI[0].equals(string)) {
                        String baseURI;
                        boolean loop = true;
                        if (this.templateURIPath != null && (baseURI = start.getBaseURI()) != null) {
                            int i = 0;
                            while (i < this.templateURIPath.length) {
                                if (baseURI.equals(this.templateURIPath[i])) {
                                    resolvedFileURI = JETCompiler.resolveLocation(this.templateURIPath, i + 1, string, fileURI);
                                    loop = false;
                                }
                                ++i;
                            }
                        }
                        if (loop) {
                            return;
                        }
                    }
                    jetDirectiveItem.setData("include", resolvedFileURI[1]);
                    try {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(JETCompiler.openStream(resolvedFileURI[1], this.inputStreamHandler));
                        this.reader.stackStream((String)resolvedFileURI[2], (String)resolvedFileURI[0], bufferedInputStream, null);
                        JETMark includeStart = this.reader.mark();
                        jetDirectiveItem.setData("include-file-id", includeStart.getFileId());
                        jetDirectiveItem.setData("include-start", new JETItem(includeStart, includeStart));
                        jetDirectiveItem.setData("include-success", Boolean.TRUE);
                        jetDirectiveItem.setSkipped(this.skipping);
                        if ("alternative".equals(attributes.get("fail"))) {
                            this.skipSections.push(new SkipSection(this.sectionDepth + 1, !this.skipping, jetDirectiveItem));
                        }
                        if (this.fSavedLine != null) {
                            return;
                        }
                        break block55;
                    }
                    catch (JETException exception) {
                        jetDirectiveItem.setData("include-success", Boolean.FALSE);
                        String failType = attributes.get("fail");
                        if ("alternative".equals(failType)) {
                            this.skipSections.push(new SkipSection(this.sectionDepth + 1, false, jetDirectiveItem));
                        } else if (!"silent".equals(failType)) {
                            this.problemListener.handleProblem(start, stop, 4, null, "jet.error.file.cannot.read", resolvedFileURI[1], start.format("jet.mark.file.line.column"));
                        }
                        break block55;
                    }
                }
                this.problemListener.handleProblem(start, stop, 4, null, "jet.error.missing.attribute", "file", start.format("jet.mark.file.line.column"));
            }
            for (Map.Entry entry : attributes.entrySet()) {
                String key = (String)entry.getKey();
                JETTokenItem attribute = jetDirectiveItem.getAttribute(key).getNameToken();
                if (key.equals("file") || key.equals("fail")) continue;
                this.problemListener.handleProblem(attribute.getStart(), attribute.getStop(), 2, null, "jet.error.bad.attribute", key, attribute.getStart().format("jet.mark.file.line.column"));
            }
        } else if (directive.equals("start")) {
            ++this.sectionDepth;
            SkipSection skipSection2 = skipSection = this.skipSections.isEmpty() ? null : this.skipSections.peek();
            if (skipSection == null || skipSection.depth != this.sectionDepth) {
                this.problemListener.handleProblem(start, stop, 4, null, "jet.error.section.noinclude", start.format("jet.mark.file.line.column"));
                --this.sectionDepth;
            } else {
                if (skipSection.skip) {
                    this.skipping = true;
                    jetDirectiveItem.setSkipped(true);
                } else {
                    jetDirectiveItem.setSkipped(this.skipping);
                }
                skipSection.jetDirectiveItem.setData("section-start", jetDirectiveItem);
                jetDirectiveItem.setData("section-owner", skipSection.jetDirectiveItem);
            }
            for (Map.Entry entry : attributes.entrySet()) {
                String key = (String)entry.getKey();
                JETTokenItem attribute = jetDirectiveItem.getAttribute(key).getNameToken();
                this.problemListener.handleProblem(attribute.getStart(), attribute.getStop(), 2, null, "jet.error.bad.attribute", key, attribute.getStart().format("jet.mark.file.line.column"));
            }
        } else if (directive.equals("end")) {
            if (this.sectionDepth == 0) {
                this.problemListener.handleProblem(start, stop, 4, null, "jet.error.unmatched.directive", "start", "end", start.format("jet.mark.file.line.column"));
            } else {
                --this.sectionDepth;
                skipSection = this.skipSections.pop();
                if (skipSection.skip) {
                    jetDirectiveItem.setSkipped(true);
                    this.skipping = false;
                } else {
                    jetDirectiveItem.setSkipped(this.skipping);
                }
                skipSection.jetDirectiveItem.setData("section-end", jetDirectiveItem);
                JETDirectiveItem jETDirectiveItem = (JETDirectiveItem)skipSection.jetDirectiveItem.getData("section-start");
                jETDirectiveItem.setData("section-other-end", jetDirectiveItem);
                jetDirectiveItem.setData("section-other-end", jETDirectiveItem);
                jetDirectiveItem.setData("section-owner", skipSection.jetDirectiveItem);
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    String key = entry.getKey();
                    JETTokenItem attribute = jetDirectiveItem.getAttribute(key).getNameToken();
                    this.problemListener.handleProblem(attribute.getStart(), attribute.getStop(), 2, null, "jet.error.bad.attribute", key, attribute.getStart().format("jet.mark.file.line.column"));
                }
            }
        } else if (directive.equals("jet")) {
            if (this.skeleton != null) {
                jetDirectiveItem.setData("skeleton", this.skeleton);
                jetDirectiveItem.setData("duplicate-jet-directive", Boolean.TRUE);
                jetDirectiveItem.setSkipped(true);
            } else {
                String lineSeparator = this.getLineSeparator();
                String string = attributes.get("builder");
                this.skeleton = new JETSkeleton(lineSeparator, string);
                String skeletonURI = attributes.get("skeleton");
                if (skeletonURI != null) {
                    JETTokenItem skeletonItem = jetDirectiveItem.getAttribute("skeleton").getValueToken();
                    try {
                        String skeletonLocation = JETCompiler.resolveLocation(this.templateURIPath, this.templateURI, skeletonURI)[1];
                        jetDirectiveItem.setData("resolved-skeleton", skeletonLocation);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(JETCompiler.openStream(skeletonLocation, this.inputStreamHandler));
                        byte[] input = new byte[bufferedInputStream.available()];
                        bufferedInputStream.read(input);
                        bufferedInputStream.close();
                        String skeletonEncoding = attributes.get("skeletonEncoding");
                        this.skeleton.setCompilationUnitContents(skeletonEncoding == null ? new String(input) : new String(input, skeletonEncoding));
                        if (!this.skeleton.isWellFormed()) {
                            this.problemListener.handleProblem(skeletonItem.getStart(), skeletonItem.getStop(), 4, null, "jet.error.jet.skeleton", skeletonItem.getStart().format("jet.mark.file.line.column"));
                            this.skeleton = new JETSkeleton(lineSeparator, string);
                        }
                    }
                    catch (IOException exception) {
                        this.problemListener.handleProblem(skeletonItem.getStart(), skeletonItem.getStop(), 4, null, "jet.error.jet.skeleton", skeletonItem.getStart().format("jet.mark.file.line.column"));
                    }
                    catch (JETException exception) {
                        this.problemListener.handleProblem(skeletonItem.getStart(), skeletonItem.getStop(), 4, (Throwable)((Object)exception), "jet.error.jet.skeleton", skeletonItem.getStart().format("jet.mark.file.line.column"));
                    }
                }
                jetDirectiveItem.setData("skeleton", this.skeleton);
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    JETValueItem valueItem;
                    JETAttributeItem attribute;
                    Diagnostic diagnostic;
                    String name;
                    String key = entry.getKey();
                    if (key.equals("skeleton")) continue;
                    if (key.equals("package")) {
                        name = entry.getValue();
                        diagnostic = CodeGenUtil.validatePackageName(name, this.reader.getResolvedURI(0));
                        if (diagnostic.getSeverity() != 0) {
                            attribute = jetDirectiveItem.getAttribute("package");
                            valueItem = attribute.getValueToken().getValueItem();
                            this.problemListener.handleProblem(valueItem.getStart(), valueItem.getStop(), diagnostic.getSeverity(), null, "jet.error.bad.attribute.value", "package", valueItem.getText(), diagnostic.getMessage(), valueItem.getStart().format("jet.mark.file.line.column"));
                            StringBuilder validQualifiedName = new StringBuilder();
                            String[] stringArray = name.split("\\.");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String component = stringArray[n2];
                                String validJavaIdentifier = CodeGenUtil.validJavaIdentifier(component);
                                if (validJavaIdentifier.length() == 0 || validJavaIdentifier.equals("_")) {
                                    validJavaIdentifier = "__";
                                }
                                if (validQualifiedName.length() != 0) {
                                    validQualifiedName.append('.');
                                }
                                validQualifiedName.append(validJavaIdentifier);
                                ++n2;
                            }
                            name = validQualifiedName.toString();
                        }
                        this.skeleton.setPackageName(name);
                        continue;
                    }
                    if (key.equals("imports")) {
                        this.skeleton.addImports(entry.getValue());
                        continue;
                    }
                    if (key.equals("class")) {
                        name = entry.getValue();
                        diagnostic = CodeGenUtil.validateClassName(name, this.reader.getResolvedURI(0));
                        if (diagnostic.getSeverity() != 0) {
                            attribute = jetDirectiveItem.getAttribute("class");
                            valueItem = attribute.getValueToken().getValueItem();
                            this.problemListener.handleProblem(valueItem.getStart(), valueItem.getStop(), diagnostic.getSeverity(), null, "jet.error.bad.attribute.value", "class", valueItem.getText(), diagnostic.getMessage(), valueItem.getStart().format("jet.mark.file.line.column"));
                            name = CodeGenUtil.validJavaIdentifier(name);
                            if (name.length() == 0 || name.equals("_")) {
                                name = "__";
                            }
                        }
                        this.skeleton.setClassName(name);
                        continue;
                    }
                    if (key.equals("nlString")) {
                        this.skeleton.setNLString(entry.getValue());
                        continue;
                    }
                    if (key.equals("startTag")) {
                        this.parser.setStartTag(entry.getValue());
                        continue;
                    }
                    if (key.equals("minimize")) {
                        if (!this.constants.isEmpty()) continue;
                        this.useMinimizedConstants = "true".equals(entry.getValue());
                        continue;
                    }
                    if (key.equals("endTag")) {
                        this.parser.setEndTag(entry.getValue());
                        continue;
                    }
                    if (key.equals("builder")) {
                        if (JETSkeleton.getBuilderName(entry.getValue()) != null) continue;
                        JETValueItem valueItem2 = jetDirectiveItem.getAttribute(key).getValueToken().getValueItem();
                        this.problemListener.handleProblem(valueItem2.getStart(), valueItem2.getStop(), 4, null, "jet.error.jet.builder", valueItem2.getStart().format("jet.mark.file.line.column"));
                        continue;
                    }
                    if (key.equals("version")) continue;
                    JETTokenItem attribute2 = jetDirectiveItem.getAttribute(key).getNameToken();
                    this.problemListener.handleProblem(attribute2.getStart(), attribute2.getStop(), 2, null, "jet.error.bad.attribute", key, attribute2.getStart().format("jet.mark.file.line.column"));
                }
                this.handleNewSkeleton();
            }
        }
        this.fSavedLine = null;
    }

    protected void handleNewSkeleton() {
    }

    @Override
    public void handleComment(JETMark start, JETMark stop) throws JETException {
        JETCommentItem jetCommentItem = new JETCommentItem(start, stop);
        this.jetItems.add(jetCommentItem);
        if (this.skipping) {
            jetCommentItem.setSkipped(true);
        } else {
            this.fSavedLine = null;
        }
    }

    @Override
    public void handleExpression(JETMark start, JETMark stop, Map<String, String> attributes) throws JETException {
        JETExpressionItem jetExpressionItem = new JETExpressionItem(start, stop);
        this.jetItems.add(jetExpressionItem);
        if (this.skipping) {
            jetExpressionItem.setSkipped(true);
        } else {
            JETExpressionGenerator gen = new JETExpressionGenerator(this.reader.getChars(start, stop), start, stop, jetExpressionItem);
            this.addGenerator(gen);
        }
    }

    @Override
    public void handleScriptlet(JETMark start, JETMark stop, Map<String, String> attributes) throws JETException {
        JETScriptletItem jetScriptletItem = new JETScriptletItem(start, stop);
        this.jetItems.add(jetScriptletItem);
        if (this.skipping) {
            jetScriptletItem.setSkipped(true);
        } else {
            this.fSavedLine = null;
            JETScriptletGenerator gen = new JETScriptletGenerator(this.reader.getChars(start, stop), start, stop, jetScriptletItem);
            this.addGenerator(gen);
        }
    }

    @Override
    public void handleCharData(char[] chars) throws JETException {
        this.currentLiteralItem = (JETLiteralItem)this.reader.popItem();
        List<JETLiteralItem> explode = this.currentLiteralItem.explode();
        this.jetItems.addAll(explode);
        if (this.skipping) {
            this.currentLiteralItem.setSkipped(true);
        } else {
            if (this.fSavedLine != null) {
                JETLiteralItem oldCurrentLiteralItem = this.currentLiteralItem;
                this.currentLiteralItem = this.savedLineLiteralItem;
                this.addCharDataGenerator(this.fSavedLine);
                this.currentLiteralItem = oldCurrentLiteralItem;
                this.fSavedLine = null;
                this.savedLineLiteralItem = null;
            }
            if (this.fNoNewLineForScriptlets) {
                char[] strippedChars = this.stripLastNewLineWithBlanks(chars);
                if (strippedChars.length > 0) {
                    this.addCharDataGenerator(strippedChars);
                }
            } else {
                this.addCharDataGenerator(chars);
            }
        }
    }

    public void addGenerator(JETGenerator gen) throws JETException {
        if (this.fSavedLine != null) {
            this.addCharDataGenerator(this.fSavedLine);
            this.fSavedLine = null;
        }
        this.generators.add(gen);
    }

    public void addCharDataGenerator(char[] chars) throws JETException {
        block11: {
            if (chars.length <= 500) break block11;
            int nl = 0;
            int lf = 0;
            int start = 0;
            int i = 0;
            while (i < chars.length) {
                block12: {
                    switch (chars[i]) {
                        case '\n': {
                            ++nl;
                            break;
                        }
                        case '\r': {
                            ++lf;
                            break;
                        }
                        default: {
                            break block12;
                        }
                    }
                    if (lf > 400 || nl > 400) {
                        ++i;
                        block8: while (i < chars.length) {
                            switch (chars[i]) {
                                case '\n': 
                                case '\r': {
                                    break;
                                }
                                default: {
                                    int size = i - start;
                                    char[] block = new char[size];
                                    System.arraycopy(chars, start, block, 0, size);
                                    this.doAddCharDataGenerator(block);
                                    start = i;
                                    nl = 0;
                                    lf = 0;
                                    break block8;
                                }
                            }
                            ++i;
                        }
                    }
                }
                ++i;
            }
            if (start != 0) {
                int size = chars.length - start;
                char[] block = new char[size];
                System.arraycopy(chars, start, block, 0, size);
                this.doAddCharDataGenerator(block);
                return;
            }
        }
        this.doAddCharDataGenerator(chars);
    }

    public void doAddCharDataGenerator(char[] chars) throws JETException {
        if (this.fUseStaticFinalConstants) {
            JETConstantDataGenerator generator = this.constantDictionary.get(chars);
            if (generator == null) {
                if (this.constantCount == 0L) {
                    chars = this.stripFirstNewLineWithBlanks(chars);
                }
                ++this.constantCount;
                String label = CONSTANT_PREFIX + this.constantCount;
                generator = this.useMinimizedConstants ? new JETExtendedConstantDataGenerator(chars, label, this.constantSubstitutitons) : new JETConstantDataGenerator(chars, label);
                generator.setLiteralItem(this.currentLiteralItem);
                this.constantDictionary.put(chars, generator);
                this.constants.add(generator);
            } else {
                generator.copy().setLiteralItem(this.currentLiteralItem);
            }
            this.generators.add(generator);
        } else {
            JETCharDataGenerator generator = new JETCharDataGenerator(chars);
            generator.setLiteralItem(this.currentLiteralItem);
            this.generators.add(generator);
        }
    }

    protected char[] stripFirstNewLineWithBlanks(char[] chars) {
        if (chars.length >= 2 && (chars[0] == '\n' && chars[1] == '\r' || chars[0] == '\r' && chars[1] == '\n')) {
            chars = new String(chars, 2, chars.length - 2).toCharArray();
        } else if (chars.length >= 1 && (chars[0] == '\n' || chars[0] == '\r')) {
            chars = new String(chars, 1, chars.length - 1).toCharArray();
        }
        return chars;
    }

    protected char[] stripLastNewLineWithBlanks(char[] chars) {
        int i = chars.length - 1;
        while (i > 0 && chars[i] == ' ') {
            --i;
        }
        if (chars[i] == '\n') {
            if (i > 0 && chars[i - 1] == '\r') {
                --i;
            }
            this.fSavedLine = new String(chars, i, chars.length - i).toCharArray();
            List<JETLiteralItem> explode = this.currentLiteralItem.explode();
            this.savedLineLiteralItem = explode.get(explode.size() - 1);
            if (i == 0) {
                return NULL_CHAR_ARRAY;
            }
            chars = new String(chars, 0, i).toCharArray();
            return chars;
        }
        return chars;
    }

    @Override
    public void beginPageProcessing() {
        this.pageStart = this.reader.mark();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void endPageProcessing() throws JETException {
        String subComment;
        String header;
        String comment;
        int length;
        JETItem jetItem;
        if (this.sectionDepth > 0) {
            SkipSection skipSection = this.skipSections.peek();
            JETDirectiveItem include = skipSection.jetDirectiveItem;
            JETDirectiveItem startItem = (JETDirectiveItem)include.getData("section-start");
            this.problemListener.handleProblem(startItem.getStart(), startItem.getStop(), 4, null, "jet.error.unmatched.directive", "end", "start", startItem.getStart().format("jet.mark.file.line.column"));
        }
        if (this.skeleton == null) {
            if (this.inputStreamHandler instanceof JETCompilerResultMonitor) {
                URI uri = URI.createURI((String)this.templateURI);
                String fileExtension = uri.fileExtension();
                if (fileExtension == null || !fileExtension.endsWith("jet")) {
                    this.problemListener.handleProblem(this.pageStart, this.pageStart, 2, null, "jet.error.not.a.template", this.pageStart.format("jet.mark.file.line.column"));
                } else {
                    this.problemListener.handleProblem(this.pageStart, this.pageStart, 4, null, "jet.error.missing.jet.directive", this.pageStart.format("jet.mark.file.line.column"));
                }
                this.skeleton = new JETSkeleton(this.getLineSeparator(), null);
                String fileName = uri.trimFileExtension().lastSegment();
                String fakeClassName = "__";
                if (fileName != null) {
                    fakeClassName = CodeGenUtil.validJavaIdentifier(fileName);
                }
                fakeClassName = fakeClassName.length() == 0 || fakeClassName.equals("_") ? "__" : CodeGenUtil.capName(fakeClassName);
                this.skeleton.setClassName(fakeClassName);
                JETSubItem nameItem = new JETSubItem(this.pageStart, this.pageStart){

                    public String getText() {
                        return "jet";
                    }
                };
                JETAttributeListItem attributeList = new JETAttributeListItem(this.pageStart, this.pageStart, Collections.<JETAttributeItem>emptyList());
                JETDirectiveItem fakeJETDirective = new JETDirectiveItem(this.pageStart, this.pageStart, nameItem, attributeList);
                fakeJETDirective.setData("missing-jet-directive", Boolean.TRUE);
                fakeJETDirective.setData("skeleton", this.skeleton);
                this.jetItems.add(fakeJETDirective);
            } else {
                this.problemListener.handleProblem(this.pageStart, this.pageStart, 8, null, "jet.error.missing.jet.directive", this.pageStart.format("jet.mark.file.line.column"));
            }
        }
        if (this.fSavedLine != null) {
            this.addCharDataGenerator(this.fSavedLine);
        }
        if ((jetItem = this.jetItems.get(0)) instanceof JETCommentItem && (length = (comment = jetItem.getText()).length()) > 4 && comment.charAt(0) == '-' && (comment.charAt(1) == '\r' || comment.charAt(1) == '\n') && comment.charAt(length - 1) == '-' && comment.charAt(length - 2) == '\n' && (header = (subComment = comment.substring(2, length - 2).trim())).length() != 0) {
            JETCommentItem jetCommentItem = (JETCommentItem)jetItem;
            Matcher matcher = LINE_PATTERN.matcher(comment);
            matcher.find(subComment.charAt(0) == '\n' ? 4 : 3);
            do {
                jetCommentItem.addLineItem(matcher.start(1), matcher.end(1));
            } while (matcher.find());
            this.skeleton.setHeader(header);
        }
        ArrayList<String> generatedConstants = new ArrayList<String>(this.constants.size());
        String builderName = this.skeleton.getBuilderName();
        if (this.useMinimizedConstants) {
            final TreeSet newLines = new TreeSet();
            final TreeSet literals = new TreeSet();
            JETExtendedConstantDataGenerator.Analzyer analyzer = new JETExtendedConstantDataGenerator.Analzyer(){

                public void handleNewLine(String newLine) {
                    newLines.add(newLine);
                }

                public void handleLiteral(String literal) {
                    literals.add(literal);
                }
            };
            List<JETConstantDataGenerator> extendedConstantDataGenerators = this.constants;
            for (JETExtendedConstantDataGenerator jETExtendedConstantDataGenerator : extendedConstantDataGenerators) {
                jETExtendedConstantDataGenerator.analyze(analyzer);
            }
            boolean bl = false;
            if (!literals.isEmpty()) {
                Iterator iterator = literals.iterator();
                while (iterator.hasNext()) {
                    void var8_15;
                    String literal = (String)iterator.next();
                    String string = "_" + (int)(++var8_15);
                    this.constantSubstitutitons.put(literal, string);
                    generatedConstants.add(JETConstantDataGenerator.generateConstant(true, string, String.valueOf('\"') + literal + '\"'));
                }
            }
            newLines.remove("\n");
            this.constantSubstitutitons.put("\n", "NL");
            if (!newLines.isEmpty()) {
                int nlCount = 0;
                for (String newLine : newLines) {
                    String label = "NL_" + ++nlCount;
                    this.constantSubstitutitons.put(newLine, label);
                    generatedConstants.add(new JETConstantDataGenerator(newLine.toCharArray(), label).generateConstant());
                }
            }
            final ArrayList mappings = new ArrayList();
            JETExtendedConstantDataGenerator.Analzyer countingAnalyzer = new JETExtendedConstantDataGenerator.Analzyer(){

                public void handleNewLine(String newLine) {
                    mappings.add(newLine);
                }

                public void handleLiteral(String literal) {
                    mappings.add(literal);
                }
            };
            for (JETExtendedConstantDataGenerator jETExtendedConstantDataGenerator : extendedConstantDataGenerators) {
                void var8_16;
                mappings.clear();
                jETExtendedConstantDataGenerator.analyze(countingAnalyzer);
                if (mappings.size() == 1) {
                    jETExtendedConstantDataGenerator.setLabel(this.constantSubstitutitons.get(mappings.get(0)));
                    continue;
                }
                String label = "_" + (int)(++var8_16);
                jETExtendedConstantDataGenerator.setLabel(label);
                generatedConstants.add(jETExtendedConstantDataGenerator.generateConstant());
            }
        } else {
            for (JETConstantDataGenerator jetConstantDataGenerator : this.constants) {
                generatedConstants.add(jetConstantDataGenerator.generateConstant());
            }
        }
        this.skeleton.setConstants(generatedConstants);
        ArrayList<String> generatedBody = new ArrayList<String>(this.generators.size());
        for (JETGenerator jetGenerator : this.generators) {
            if (jetGenerator instanceof JETGenerator.BuilderSensitive) {
                ((JETGenerator.BuilderSensitive)((Object)jetGenerator)).setBuilderName(builderName);
            }
            generatedBody.add(jetGenerator.generate());
        }
        this.skeleton.setBody(generatedBody);
        String compilationUnitContents = this.skeleton.getCompilationUnitContents();
        this.writer.print(compilationUnitContents);
        if (this.inputStreamHandler instanceof JETCompilerResultMonitor) {
            ((JETCompilerResultMonitor)((Object)this.inputStreamHandler)).setResult(this.getResult());
        }
    }

    public JETCompilationUnit getResult() {
        ArrayList<String> templateURIs = new ArrayList<String>(this.reader.resolvedURIs);
        return this.skeleton.getCompilerResult(templateURIs, this.generators, this.jetItems, this.problemListener.getProblems());
    }

    public void parse() throws JETException {
        JETParser.Directive directive = new JETParser.Directive();
        directive.getDirectives().add("jet");
        directive.getDirectives().add("include");
        directive.getDirectives().add("start");
        directive.getDirectives().add("end");
        JETCoreElement[] coreElements = new JETCoreElement[]{directive, new JETParser.QuoteEscape(), new JETParser.Comment(), new JETParser.Expression(), new JETParser.Scriptlet()};
        this.parse(coreElements, null);
    }

    protected void parse(JETCoreElement[] coreElements, Class<?>[] accept) throws JETException {
        this.parser = new JETParser(this.reader, this, coreElements, this.problemListener);
        this.beginPageProcessing();
        this.parser.parse(null, accept);
    }

    public void generate(OutputStream oStream) throws JETException {
        this.writer = new PrintWriter(oStream);
        this.endPageProcessing();
        this.writer.close();
    }

    public void generate(Writer writer) throws JETException {
        this.writer = new PrintWriter(writer);
        this.endPageProcessing();
        this.writer.close();
    }

    public JETSkeleton getSkeleton() {
        return this.skeleton;
    }

    protected static String[] resolveLocation(String[] templateURIPath, String baseLocationURI, String locationURI) {
        return JETCompiler.resolveLocation(templateURIPath, 0, baseLocationURI, locationURI);
    }

    protected static String[] resolveLocation(String[] templateURIPath, int start, String baseLocationURI, String locationURI) {
        String[] stringArray = new String[3];
        stringArray[0] = locationURI;
        stringArray[1] = locationURI;
        String[] result = stringArray;
        URI uri = URI.createURI((String)locationURI);
        try {
            new URL(locationURI);
            uri = JETCompiler.resolve(uri);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uri.isRelative() && uri.hasRelativePath()) {
            String resolvedLocation = "";
            int index = baseLocationURI.lastIndexOf("/");
            if (index != -1) {
                resolvedLocation = baseLocationURI.substring(0, index + 1);
            }
            result[0] = resolvedLocation = JETCompiler.resolve(resolvedLocation, uri.toString());
            if (templateURIPath != null) {
                String[] location = JETCompiler.findLocation(templateURIPath, start, resolvedLocation);
                resolvedLocation = location[0];
                result[2] = location[1];
            }
            if (resolvedLocation != null) {
                result[1] = resolvedLocation;
            }
        }
        return result;
    }

    public static String[] findLocation(String[] locationURIPath, int start, String relativeLocationURI) {
        return JETCompiler.findLocation(locationURIPath, start, relativeLocationURI, null);
    }

    public static String[] findLocation(String[] locationURIPath, int start, String relativeLocationURI, JETInputStreamHandler inputStreamHandler) {
        String[] result = new String[2];
        int i = start;
        while (i < locationURIPath.length) {
            result[0] = locationURIPath[i];
            result[1] = locationURIPath[i];
            if (result[0] != null) {
                try {
                    if (!result[0].endsWith("/")) {
                        result[0] = String.valueOf(result[0]) + "/";
                    }
                    result[0] = JETCompiler.resolve(result[0], relativeLocationURI);
                    InputStream inputStream = JETCompiler.openStream(result[0], inputStreamHandler);
                    inputStream.close();
                    break;
                }
                catch (JETException exception) {
                    result[0] = null;
                }
                catch (IOException exception) {
                    result[0] = null;
                }
            }
            ++i;
        }
        return result;
    }

    private static String resolve(String base, String relativePath) {
        while (relativePath.startsWith("./")) {
            relativePath = relativePath.substring(2);
        }
        while (relativePath.startsWith("../")) {
            int index = base.lastIndexOf(47, base.length() - 2);
            if (index == -1) {
                base = "";
                relativePath = relativePath.substring(3);
                break;
            }
            base = base.substring(0, index);
            relativePath = relativePath.substring(3);
        }
        return String.valueOf(base) + relativePath;
    }

    public static String find(String[] locationURIPath, String relativeLocationURI) {
        return JETCompiler.findLocation(locationURIPath, 0, relativeLocationURI)[0];
    }

    public static InputStream openStream(String locationURI) throws JETException {
        return JETCompiler.openStream(locationURI, null);
    }

    public static InputStream openStream(String locationURI, JETInputStreamHandler inputStreamHandler) throws JETException {
        if (inputStreamHandler != null) {
            return inputStreamHandler.openInputStream(locationURI);
        }
        try {
            String file;
            URI resolvedURI;
            URL url;
            URI uri = URI.createURI((String)locationURI);
            try {
                uri = JETCompiler.resolve(uri);
                url = new URL(uri.toString());
            }
            catch (MalformedURLException exception) {
                url = new URL("file:" + locationURI);
            }
            try {
                resolvedURI = URI.createURI((String)url.toURI().toString());
            }
            catch (URISyntaxException exception) {
                resolvedURI = URI.createURI((String)url.toString());
            }
            if (resolvedURI.isFile() && new File(file = resolvedURI.toFileString()).isDirectory()) {
                throw new IOException("Cannot read a folder:" + file);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(url.openStream());
            return bufferedInputStream;
        }
        catch (IOException exception) {
            throw new JETException("jet.error.unknown", exception.getLocalizedMessage(), exception, null, null, 4);
        }
    }

    private static URI resolve(URI uri) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return JETNature.resolve(uri);
        }
        return CommonPlugin.resolve((URI)uri);
    }

    public static interface JETCompilerResultMonitor {
        public void setResult(JETCompilationUnit var1);
    }

    public static class JETInputStreamHandler {
        public InputStream openInputStream(String locationURI) throws JETException {
            return JETCompiler.openStream(locationURI, null);
        }
    }

    static class SkipSection {
        int depth;
        boolean skip;
        JETDirectiveItem jetDirectiveItem;

        SkipSection(int depth, boolean skip, JETDirectiveItem jetDirectiveItem) {
            this.depth = depth;
            this.skip = skip;
            this.jetDirectiveItem = jetDirectiveItem;
        }
    }
}

