/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.types.utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.comma.types.types.Dimension;
import org.eclipse.comma.types.types.EnumElement;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.IntExp;
import org.eclipse.comma.types.types.MapTypeConstructor;
import org.eclipse.comma.types.types.MapTypeDecl;
import org.eclipse.comma.types.types.RecordField;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeObject;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TypeUtilities {
    public static TypeObject getTypeObject(Type t) {
        TypeObject _xifexpression = null;
        _xifexpression = t instanceof TypeReference ? ((TypeReference)t).getType() : (TypeObject)((Object)t);
        return _xifexpression;
    }

    public static boolean isVectorType(Type t) {
        return TypeUtilities.isVectorType(TypeUtilities.getTypeObject(t));
    }

    public static boolean isVectorType(TypeObject t) {
        return t instanceof VectorTypeConstructor || t instanceof VectorTypeDecl;
    }

    public static boolean isRecordType(Type t) {
        TypeObject _typeObject = TypeUtilities.getTypeObject(t);
        return _typeObject instanceof RecordTypeDecl;
    }

    public static boolean isStructuredType(TypeObject to) {
        return to instanceof VectorTypeConstructor || to instanceof VectorTypeDecl || to instanceof RecordTypeDecl || to instanceof MapTypeDecl || to instanceof MapTypeConstructor;
    }

    public static boolean isMapType(Type t) {
        return TypeUtilities.isMapType(TypeUtilities.getTypeObject(t));
    }

    public static boolean isMapType(TypeObject t) {
        return t instanceof MapTypeConstructor || t instanceof MapTypeDecl;
    }

    public static TypeObject getKeyType(TypeObject t) {
        if (t instanceof MapTypeConstructor) {
            return ((MapTypeConstructor)t).getType();
        }
        if (t instanceof MapTypeDecl) {
            return ((MapTypeDecl)t).getConstructor().getType();
        }
        return null;
    }

    public static TypeObject getValueType(TypeObject t) {
        if (t instanceof MapTypeConstructor) {
            return TypeUtilities.getTypeObject(((MapTypeConstructor)t).getValueType());
        }
        if (t instanceof MapTypeDecl) {
            return TypeUtilities.getTypeObject(((MapTypeDecl)t).getConstructor().getValueType());
        }
        return null;
    }

    protected static boolean _usesMaps(TypeReference t) {
        boolean _tripleEquals;
        boolean _xblockexpression = false;
        TypeDecl _type = null;
        if (t != null) {
            _type = t.getType();
        }
        boolean bl = _tripleEquals = _type == null;
        if (_tripleEquals) {
            return false;
        }
        _xblockexpression = TypeUtilities.usesMaps(t.getType());
        return _xblockexpression;
    }

    protected static boolean _usesMaps(SimpleTypeDecl t) {
        return false;
    }

    protected static boolean _usesMaps(MapTypeDecl t) {
        return true;
    }

    protected static boolean _usesMaps(EnumTypeDecl t) {
        return false;
    }

    protected static boolean _usesMaps(RecordTypeDecl t) {
        boolean _tripleNotEquals;
        boolean _xifexpression = false;
        RecordTypeDecl _parent = t.getParent();
        boolean bl = _tripleNotEquals = _parent != null;
        if (_tripleNotEquals) {
            _xifexpression = TypeUtilities.usesMaps(t.getParent());
        } else {
            boolean _exists;
            boolean _or = false;
            Functions.Function1 _function = it -> it.getType();
            Functions.Function1 _function_1 = it -> TypeUtilities.usesMaps(it);
            _xifexpression = _or = (_exists = IterableExtensions.exists((Iterable)ListExtensions.map(t.getFields(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        }
        return _xifexpression;
    }

    protected static boolean _usesMaps(VectorTypeDecl t) {
        return TypeUtilities.usesMaps(t.getConstructor());
    }

    protected static boolean _usesMaps(VectorTypeConstructor t) {
        return TypeUtilities.usesMaps(t.getType());
    }

    protected static boolean _usesMaps(MapTypeConstructor t) {
        return true;
    }

    public static boolean isArray(Type t) {
        TypeObject to = TypeUtilities.getTypeObject(t);
        if (to instanceof VectorTypeConstructor) {
            int _size = ((Dimension)((VectorTypeConstructor)to).getDimensions().get(0)).getSize();
            return _size != 0;
        }
        if (to instanceof VectorTypeDecl) {
            int _size_1 = ((Dimension)((VectorTypeDecl)to).getConstructor().getDimensions().get(0)).getSize();
            return _size_1 != 0;
        }
        return false;
    }

    public static boolean isVoid(Type t) {
        TypeObject to = TypeUtilities.getTypeObject(t);
        if (to instanceof SimpleTypeDecl) {
            return ((SimpleTypeDecl)to).getName().equals("void");
        }
        return false;
    }

    public static boolean isPredefinedType(TypeDecl t) {
        if (t instanceof SimpleTypeDecl) {
            return TypeUtilities.isPredefinedType(((SimpleTypeDecl)t).getName());
        }
        return false;
    }

    public static boolean isPredefinedType(Type t) {
        boolean _xblockexpression = false;
        if (t instanceof TypeReference) {
            return TypeUtilities.isPredefinedType(((TypeReference)t).getType());
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public static boolean isPredefinedType(String typeName) {
        return typeName.equals("int") || typeName.equals("real") || typeName.equals("bool") || typeName.equals("string") || typeName.equals("void") || typeName.equals("any") || typeName.equals("bulkdata") || typeName.equals("id");
    }

    protected static TypeDecl _getBaseType(VectorTypeConstructor vtc) {
        TypeDecl _type = vtc.getType();
        if (_type instanceof VectorTypeDecl) {
            return TypeUtilities.getBaseType(vtc.getType());
        }
        return vtc.getType();
    }

    protected static TypeDecl _getBaseType(VectorTypeDecl vtd) {
        return TypeUtilities.getBaseType(vtd.getConstructor());
    }

    protected static int _getFirstDimension(VectorTypeConstructor vtc) {
        return ((Dimension)vtc.getDimensions().get(0)).getSize();
    }

    protected static int _getFirstDimension(VectorTypeDecl vtd) {
        return TypeUtilities.getFirstDimension(vtd.getConstructor());
    }

    public static List<RecordTypeDecl> getAllParents(RecordTypeDecl rt) {
        ArrayList<RecordTypeDecl> _xblockexpression = null;
        ArrayList<RecordTypeDecl> result = new ArrayList<RecordTypeDecl>();
        RecordTypeDecl current = rt.getParent();
        while (current != null && !result.contains(current)) {
            result.add(current);
            current = current.getParent();
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static List<RecordField> getAllFields(RecordTypeDecl rt) {
        ArrayList<RecordField> _xblockexpression = null;
        ArrayList<RecordField> result = new ArrayList<RecordField>();
        if (rt.getParent() != null && !TypeUtilities.getAllParents(rt).contains(rt)) {
            result.addAll(TypeUtilities.getAllFields(rt.getParent()));
        }
        result.addAll((Collection<RecordField>)rt.getFields());
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static EnumElement getEnumElementByValue(EnumTypeDecl enumType, int value) {
        int currentValue = -1;
        EList<EnumElement> _literals = enumType.getLiterals();
        for (EnumElement l : _literals) {
            boolean _tripleEquals;
            IntExp _value = l.getValue();
            boolean bl = _tripleEquals = _value == null;
            currentValue = _tripleEquals ? ++currentValue : l.getValue().getValue();
            if (currentValue != value) continue;
            return l;
        }
        return null;
    }

    public static boolean usesMaps(EObject t) {
        if (t instanceof EnumTypeDecl) {
            return TypeUtilities._usesMaps((EnumTypeDecl)t);
        }
        if (t instanceof MapTypeDecl) {
            return TypeUtilities._usesMaps((MapTypeDecl)t);
        }
        if (t instanceof RecordTypeDecl) {
            return TypeUtilities._usesMaps((RecordTypeDecl)t);
        }
        if (t instanceof SimpleTypeDecl) {
            return TypeUtilities._usesMaps((SimpleTypeDecl)t);
        }
        if (t instanceof VectorTypeDecl) {
            return TypeUtilities._usesMaps((VectorTypeDecl)t);
        }
        if (t instanceof MapTypeConstructor) {
            return TypeUtilities._usesMaps((MapTypeConstructor)t);
        }
        if (t instanceof TypeReference) {
            return TypeUtilities._usesMaps((TypeReference)t);
        }
        if (t instanceof VectorTypeConstructor) {
            return TypeUtilities._usesMaps((VectorTypeConstructor)t);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t).toString());
    }

    public static TypeDecl getBaseType(TypeObject vtd) {
        if (vtd instanceof VectorTypeDecl) {
            return TypeUtilities._getBaseType((VectorTypeDecl)vtd);
        }
        if (vtd instanceof VectorTypeConstructor) {
            return TypeUtilities._getBaseType((VectorTypeConstructor)vtd);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(vtd).toString());
    }

    public static int getFirstDimension(TypeObject vtd) {
        if (vtd instanceof VectorTypeDecl) {
            return TypeUtilities._getFirstDimension((VectorTypeDecl)vtd);
        }
        if (vtd instanceof VectorTypeConstructor) {
            return TypeUtilities._getFirstDimension((VectorTypeConstructor)vtd);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(vtd).toString());
    }
}

