/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient45;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.TextUtils;
import org.eclipse.ecf.core.util.ECFRuntimeException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.HttpClientDefaultSSLSocketFactoryModifier;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.HttpClientProxyCredentialProvider;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.IHttpClientFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.IHttpClientModifier;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.INTLMProxyHandler;
import org.eclipse.ecf.provider.filetransfer.httpclient45.HttpClientOptions;
import org.eclipse.ecf.provider.filetransfer.httpclient45.HttpClientRetrieveFileTransfer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component
public class ECFHttpClientFactory
implements IHttpClientFactory {
    private static final List<String> DEFAULT_PREFERRED_AUTH_SCHEMES_NO_NTLM = Arrays.asList("Basic", "Digest");
    private static final List<String> DEFAULT_PREFERRED_AUTH_SCHEMES = Arrays.asList("Basic", "Digest", "NTLM");
    public static final int DEFAULT_CONNECTION_TIMEOUT = HttpClientOptions.RETRIEVE_DEFAULT_CONNECTION_TIMEOUT;
    public static final int DEFAULT_CONNECTION_TTL = HttpClientOptions.RETRIEVE_DEFAULT_CONNECTION_TTL;
    public static final int DEFAULT_READ_TIMEOUT = HttpClientOptions.RETRIEVE_DEFAULT_READ_TIMEOUT;
    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = HttpClientOptions.RETRIEVE_DEFAULT_CONNECTION_TIMEOUT;
    public static final String NTLM_PROXY_HANDLER_ATTR = INTLMProxyHandler.class.getName();
    private static final Registry<AuthSchemeProvider> DEFAULT_AUTH_SCHEME_REGISTRY = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).register("Digest", (Object)new DigestSchemeFactory()).register("NTLM", (Object)new NTLMSchemeFactory()).build();
    private static final SocketConfig DEFAULT_SOCKET_CONFIG = SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT).setSoTimeout(DEFAULT_READ_TIMEOUT).setTcpNoDelay(true).build();
    private ReferenceQueue<CloseableHttpClient> collectedClients;
    private List<WeakReference<CloseableHttpClient>> trackedClients;

    @Override
    public HttpClientBuilder newClient() {
        HttpClientBuilder builder = this.createHttpClientBuilder();
        ECFHttpClientFactory.configureSSLSocketFactory(builder);
        builder.setDefaultCredentialsProvider((CredentialsProvider)new HttpClientProxyCredentialProvider());
        builder.setDefaultRequestConfig(this.newRequestConfig(null, System.getProperties()).build());
        builder.setConnectionTimeToLive((long)DEFAULT_CONNECTION_TTL, TimeUnit.MILLISECONDS);
        builder.setMaxConnPerRoute(100);
        builder.setMaxConnTotal(300);
        builder.setDefaultSocketConfig(DEFAULT_SOCKET_CONFIG);
        builder.setDefaultAuthSchemeRegistry(DEFAULT_AUTH_SCHEME_REGISTRY);
        builder = Activator.getDefault().runModifiers(builder, new ModifierRunner<HttpClientBuilder>(){

            @Override
            public HttpClientBuilder run(IHttpClientModifier modifier, HttpClientBuilder value) {
                return modifier.modifyClient(value);
            }
        });
        return builder;
    }

    protected HttpClientBuilder createHttpClientBuilder() {
        return new HttpClientBuilder(){

            public CloseableHttpClient build() {
                CloseableHttpClient client = super.build();
                ECFHttpClientFactory.this.track(client);
                return client;
            }
        };
    }

    @Override
    public HttpClientContext newClientContext() {
        HttpClientContext context = HttpClientContext.create();
        INTLMProxyHandler ntlmProxyHandler = Activator.getDefault().getNTLMProxyHandler();
        context.setAttribute(NTLM_PROXY_HANDLER_ATTR, (Object)ntlmProxyHandler);
        context.setAuthSchemeRegistry(DEFAULT_AUTH_SCHEME_REGISTRY);
        context = Activator.getDefault().runModifiers(context, new ModifierRunner<HttpClientContext>(){

            @Override
            public HttpClientContext run(IHttpClientModifier modifier, HttpClientContext value) {
                return modifier.modifyContext(value);
            }
        });
        return context;
    }

    @Override
    public RequestConfig.Builder newRequestConfig(final HttpClientContext context, final Map<?, ?> localOptions) {
        RequestConfig.Builder builder = RequestConfig.custom();
        int connectionRequestTimeout = DEFAULT_CONNECTION_REQUEST_TIMEOUT;
        int connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
        int readTimeout = DEFAULT_READ_TIMEOUT;
        if (localOptions != null) {
            connectionRequestTimeout = this.getIntOption("org.eclipse.ecf.provider.filetransfer.httpclient4.retrieve.connectTimeout", localOptions, connectionRequestTimeout);
            connectionTimeout = this.getIntOption("org.eclipse.ecf.provider.filetransfer.httpclient4.retrieve.connectTimeout", localOptions, connectionTimeout);
            readTimeout = this.getIntOption("org.eclipse.ecf.provider.filetransfer.httpclient4.retrieve.readTimeout", localOptions, readTimeout);
        }
        builder.setConnectionRequestTimeout(connectionRequestTimeout).setConnectTimeout(connectionTimeout).setSocketTimeout(readTimeout);
        boolean allowNTLMAuthentication = ECFHttpClientFactory.getNTLMProxyHandler((HttpContext)context).allowNTLMAuthentication(localOptions);
        List<String> preferredAuthSchemes = allowNTLMAuthentication ? DEFAULT_PREFERRED_AUTH_SCHEMES : DEFAULT_PREFERRED_AUTH_SCHEMES_NO_NTLM;
        builder.setProxyPreferredAuthSchemes(preferredAuthSchemes);
        builder.setTargetPreferredAuthSchemes(preferredAuthSchemes);
        builder = Activator.getDefault().runModifiers(builder, new ModifierRunner<RequestConfig.Builder>(){

            @Override
            public RequestConfig.Builder run(IHttpClientModifier modifier, RequestConfig.Builder value) {
                return modifier.modifyRequestConfig(value, context, localOptions);
            }
        });
        return builder;
    }

    private int getIntOption(String key, Map<?, ?> localOptions, int defaultValue) {
        Object option = localOptions.get(key);
        if (option != null) {
            int value = defaultValue;
            if (option instanceof Number) {
                value = ((Number)option).intValue();
            } else if (option instanceof String) {
                try {
                    value = Integer.parseInt((String)option);
                }
                catch (NumberFormatException e) {
                    Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)"org.eclipse.ecf.provider.filetransfer/debug/exceptions/catching", HttpClientRetrieveFileTransfer.class, (String)"getDnsHostName", (Throwable)e);
                }
            }
            return value;
        }
        return defaultValue;
    }

    private static void configureSSLSocketFactory(HttpClientBuilder builder) {
        SSLSocketFactory sslSocketFactory = Activator.getDefault().getSSLSocketFactory();
        if (sslSocketFactory == null) {
            try {
                sslSocketFactory = new HttpClientDefaultSSLSocketFactoryModifier().getSSLSocketFactory();
            }
            catch (IOException e) {
                Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)"org.eclipse.ecf.provider.filetransfer/debug/exceptions/catching", HttpClientDefaultSSLSocketFactoryModifier.class, (String)"getSSLSocketFactory()", (Throwable)e);
                throw new ECFRuntimeException("Unable to instantiate schemes for HttpClient.", (Throwable)e);
            }
        }
        if (sslSocketFactory == SSLSocketFactory.getDefault()) {
            sslSocketFactory = null;
        }
        if (sslSocketFactory != null) {
            PublicSuffixMatcher publicSuffixMatcherCopy = PublicSuffixMatcherLoader.getDefault();
            String systemHttpsProtocols = System.getProperty("https.protocols");
            String systemCipherSuites = System.getProperty("https.cipherSuites");
            String[] supportedProtocols = ECFHttpClientFactory.split(systemHttpsProtocols);
            String[] supportedCipherSuites = ECFHttpClientFactory.split(systemCipherSuites);
            DefaultHostnameVerifier hostnameVerifierCopy = new DefaultHostnameVerifier(publicSuffixMatcherCopy);
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslSocketFactory, supportedProtocols, supportedCipherSuites, (HostnameVerifier)hostnameVerifierCopy);
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
        }
    }

    private synchronized void track(CloseableHttpClient client) {
        this.clearCollectedClients();
        if (this.collectedClients == null) {
            this.collectedClients = new ReferenceQueue();
            this.trackedClients = new LinkedList<WeakReference<CloseableHttpClient>>();
        }
        this.trackedClients.add(new WeakReference<CloseableHttpClient>(client, this.collectedClients));
    }

    private synchronized void clearCollectedClients() {
        if (this.collectedClients == null) {
            return;
        }
        Reference<CloseableHttpClient> collectedReference = this.collectedClients.poll();
        while (collectedReference != null) {
            this.trackedClients.remove(collectedReference);
            collectedReference = this.collectedClients.poll();
        }
    }

    public synchronized void close() {
        if (this.trackedClients != null) {
            for (WeakReference<CloseableHttpClient> clientRef : this.trackedClients) {
                CloseableHttpClient client = (CloseableHttpClient)clientRef.get();
                if (client == null) continue;
                try {
                    client.close();
                }
                catch (IOException ex) {
                    Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)"org.eclipse.ecf.provider.filetransfer/debug/exceptions/catching", ECFHttpClientFactory.class, (String)"close", (Throwable)ex);
                }
            }
            this.trackedClients = null;
            this.collectedClients = null;
        }
    }

    @Deactivate
    public void deactivate() {
        this.close();
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s.split(" *, *");
    }

    public static CredentialsProvider modifyCredentialsProvider(CredentialsProvider credentialsProvider) {
        return Activator.getDefault().runModifiers(credentialsProvider, new ModifierRunner<CredentialsProvider>(){

            @Override
            public CredentialsProvider run(IHttpClientModifier modifier, CredentialsProvider value) {
                return modifier.modifyCredentialsProvider(value);
            }
        });
    }

    public static INTLMProxyHandler getNTLMProxyHandler(HttpContext httpContext) {
        Object value;
        Object object = value = httpContext == null ? null : httpContext.getAttribute(NTLM_PROXY_HANDLER_ATTR);
        if (value instanceof INTLMProxyHandler) {
            return (INTLMProxyHandler)value;
        }
        INTLMProxyHandler handler = Activator.getDefault().getNTLMProxyHandler();
        if (handler != null && httpContext != null && value == null) {
            httpContext.setAttribute(NTLM_PROXY_HANDLER_ATTR, (Object)handler);
        }
        return handler;
    }

    protected static interface ModifierRunner<T> {
        public T run(IHttpClientModifier var1, T var2);
    }
}

